/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.DerbyTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.mapping.datastore.BigIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryStreamRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BooleanRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DateRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DecimalRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.FloatRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.IntegerRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NumericRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.RealRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SmallIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SqlXmlRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimeRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimestampRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.method.AvgWithCastFunction;
import org.datanucleus.store.rdbms.sql.method.StringConcat1Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringMatchesDerbyMethod;
import org.datanucleus.store.rdbms.sql.method.StringStartsWith3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrim2Method;
import org.datanucleus.store.rdbms.sql.operation.Concat3Operation;
import org.datanucleus.store.rdbms.sql.operation.Mod2Operation;
import org.datanucleus.store.rdbms.sql.operation.NumericToString3Operation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DerbyAdapter
extends BaseDatastoreAdapter {
    private static final String DERBY_RESERVED_WORDS = "ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOOLEAN,BOTH,BY,CALL,CASCADE,CASCADED,CASE,CAST,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CHECK,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DIAGNOSTICS,DISCONNECT,DISTINCT,DOUBLE,DROP,ELSE,END,ENDEXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXPLAIN,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,FUNCTION,GET,GET_CURRENT_CONNECTION,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTO,IS,ISOLATION,JOIN,KEY,LAST,LEADING,LEFT,LIKE,LOCAL,LONGINT,LOWER,LTRIM,MATCH,MAX,MIN,MINUTE,NATIONAL,NATURAL,NCHAR,NVARCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUT,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,RTRIM,RUNTIMESTATISTICS,SCHEMA,SCROLL,SECOND,SELECT,SESSION_USER,SET,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTR,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,TIMEZONE_HOUR,TIMEZONE_MINUTE,TINYINT,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USER,USING,VALUES,VARCHAR,VARYING,VIEW,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR";

    public DerbyAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)DERBY_RESERVED_WORDS));
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_DefaultWithNotNull");
        if (this.datastoreMajorVersion >= 10) {
            this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        } else {
            this.supportedOptions.add("ColumnOptions_NullsKeyword");
        }
        if (this.datastoreMajorVersion < 10 || this.datastoreMajorVersion == 10 && this.datastoreMinorVersion < 6) {
            this.supportedOptions.remove("ANSI_CrossJoin_Syntax");
            this.supportedOptions.add("ANSI_CrossJoinAsInner11_Syntax");
            this.supportedOptions.remove("Sequences");
        }
        if (this.datastoreMajorVersion >= 11 || this.datastoreMinorVersion > 4) {
            this.supportedOptions.add("OrderByWithNullsDirectives");
        }
    }

    @Override
    public void initialiseDatastore(Connection conn) {
        try {
            Statement st = conn.createStatement();
            try {
                st.execute("DROP FUNCTION NUCLEUS_ASCII");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                st.execute("CREATE FUNCTION NUCLEUS_ASCII(C CHAR(1)) RETURNS INTEGER EXTERNAL NAME 'org.datanucleus.store.rdbms.adapter.DerbySQLFunction.ascii' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"051027", (Object[])new Object[]{sqle}));
            }
            try {
                st.execute("DROP FUNCTION NUCLEUS_MATCHES");
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                st.execute("CREATE FUNCTION NUCLEUS_MATCHES(TEXT VARCHAR(8000), PATTERN VARCHAR(8000)) RETURNS INTEGER EXTERNAL NAME 'org.datanucleus.store.rdbms.adapter.DerbySQLFunction.matches' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"051027", (Object[])new Object[]{sqle}));
            }
            st.close();
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)"Exception when trying to initialise datastore", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        return conn.getMetaData().getUserName().toUpperCase();
    }

    @Override
    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    @Override
    public String getVendorID() {
        return "derby";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new DerbyTypeInfo(rs);
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("Derby does not support dropping schema with cascade. You need to drop all tables first");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            return "CREATE UNIQUE INDEX " + identifier + " ON " + ck.getTable().toString() + " " + ck.getColumnList();
        }
        return "ALTER TABLE " + ck.getTable().toString() + " ADD " + ck;
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String extendedSetting = idx.getValueForExtension("extended-setting");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ").append(idx.getUnique() ? "UNIQUE " : "").append("INDEX ");
        stringBuilder.append(factory.newTableIdentifier(idx.getName()).getFullyQualifiedName(true));
        stringBuilder.append(" ON ").append(idx.getTable().toString());
        stringBuilder.append(" ").append(idx.getColumnList(true));
        if (extendedSetting != null) {
            stringBuilder.append(" ").append(extendedSetting);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    @Override
    public boolean isIdentityFieldDataType(String columnDef) {
        return columnDef != null && columnDef.toUpperCase().indexOf("AUTOINCREMENT") >= 0;
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    @Override
    public String getDatastoreDateStatement() {
        return "VALUES CURRENT_TIMESTAMP";
    }

    @Override
    public String getSelectForUpdateText() {
        return "WITH RR";
    }

    @Override
    public boolean validToSelectMappingInStatement(SelectStatement stmt, JavaTypeMapping m) {
        if (m.getNumberOfDatastoreMappings() <= 0) {
            return true;
        }
        for (int i = 0; i < m.getNumberOfDatastoreMappings(); ++i) {
            Column col = m.getDatastoreMapping(i).getColumn();
            if (col.getJdbcType() != JdbcType.CLOB && col.getJdbcType() != JdbcType.BLOB) continue;
            if (stmt.isDistinct()) {
                NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using DISTINCT"));
                return false;
            }
            if (stmt.getNumberOfUnions() <= 0) continue;
            NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using UNION"));
            return false;
        }
        return true;
    }

    @Override
    public String getNumericConversionFunction() {
        return "NUCLEUS_ASCII";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getSQLState().equalsIgnoreCase("XCL52");
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (this.datastoreMajorVersion < 10 || this.datastoreMajorVersion == 10 && this.datastoreMinorVersion < 5) {
            return "";
        }
        if (offset <= 0L && count <= 0L) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (offset > 0L) {
            str.append("OFFSET " + offset + (offset > 1L ? " ROWS " : " ROW "));
        }
        if (count > 0L) {
            str.append("FETCH NEXT " + (count > 1L ? count + " ROWS ONLY " : "ROW ONLY "));
        }
        return str.toString();
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        } else {
            stmt.append(" NO MAXVALUE");
        }
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        } else {
            stmt.append(" NO MINVALUE");
        }
        if (cacheSize != null) {
            throw new NucleusUserException(Localiser.msg((String)"051023"));
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("VALUES NEXT VALUE FOR ");
        stmt.append(sequenceName);
        stmt.append(" ");
        return stmt.toString();
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod2Operation.class;
        }
        if ("concat".equals(operationName)) {
            return Concat3Operation.class;
        }
        if ("numericToString".equals(operationName)) {
            return NumericToString3Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("avg".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
            if ("AVG".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
        } else if ("java.lang.String".equals(className)) {
            if ("concat".equals(methodName)) {
                return StringConcat1Method.class;
            }
            if ("length".equals(methodName)) {
                return StringLength3Method.class;
            }
            if ("matches".equals(methodName)) {
                return StringMatchesDerbyMethod.class;
            }
            if ("startsWith".equals(methodName)) {
                return StringStartsWith3Method.class;
            }
            if ("substring".equals(methodName)) {
                return StringSubstring3Method.class;
            }
            if ("trim".equals(methodName)) {
                return StringTrim2Method.class;
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerDatastoreMapping(Boolean.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerDatastoreMapping(Boolean.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Byte.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Character.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Double.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Double.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Float.class.getName(), FloatRDBMSMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerDatastoreMapping(Float.class.getName(), RealRDBMSMapping.class, JDBCType.REAL, "REAL", false);
        this.registerDatastoreMapping(Float.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", true);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Integer.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Long.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(Long.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Long.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Long.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Short.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(String.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerDatastoreMapping(String.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(String.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(String.class.getName(), LongVarcharRDBMSMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), ClobRDBMSMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerDatastoreMapping(String.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(String.class.getName(), SqlXmlRDBMSMapping.class, JDBCType.SQLXML, "XML", false);
        this.registerDatastoreMapping(String.class.getName(), NVarcharRDBMSMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), NCharRDBMSMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerDatastoreMapping(BigDecimal.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerDatastoreMapping(BigDecimal.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(BigInteger.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", true);
        this.registerDatastoreMapping(Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Time.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", true);
        this.registerDatastoreMapping(Time.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Time.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(Timestamp.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(java.util.Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Serializable.class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(Serializable.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(Serializable.class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(Serializable.class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "CHAR () FOR BIT DATA", false);
        this.registerDatastoreMapping(byte[].class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(byte[].class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(byte[].class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "CHAR () FOR BIT DATA", false);
        this.registerDatastoreMapping(File.class.getName(), BinaryStreamRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadDatastoreMappings(mgr, clr);
    }
}

