/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.LockMode;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LocateRequest
extends Request {
    private String statementUnlocked;
    private String statementLocked;
    private StatementClassMapping mappingDefinition;

    public LocateRequest(DatastoreClass table) {
        super(table);
        JavaTypeMapping softDeleteMapping;
        RDBMSStoreManager storeMgr = table.getStoreManager();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        SelectStatement sqlStatement = new SelectStatement(storeMgr, table, null, null);
        this.mappingDefinition = new StatementClassMapping();
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        JavaTypeMapping m = storeMgr.getMappingManager().getMapping(Integer.class);
        sqlStatement.select(exprFactory.newLiteral(sqlStatement, m, 1), null);
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(table.getType(), clr);
        int inputParamNum = 1;
        if (table.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false);
            SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, datastoreIdMapping, null, "ID");
            sqlStatement.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                this.mappingDefinition.addMappingForMember(SurrogateColumnType.DATASTORE_ID.getFieldNumber(), datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum++});
        } else if (table.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = table.getMemberMappingInDatastoreClass(mmd);
                if (pkMapping == null) {
                    pkMapping = table.getMemberMapping(mmd);
                }
                SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, pkMapping, null, "PK" + i);
                sqlStatement.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = this.mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    this.mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < pkMapping.getNumberOfDatastoreMappings(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        JavaTypeMapping multitenancyMapping = table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
        if (multitenancyMapping != null) {
            SQLExpression tenantExpr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), multitenancyMapping);
            SQLExpression tenantValParam = exprFactory.newLiteralParameter(sqlStatement, multitenancyMapping, null, "TENANT");
            sqlStatement.whereAnd(tenantExpr.eq(tenantValParam), true);
            StatementMappingIndex multitenancyIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.MULTITENANCY.getFieldNumber());
            if (multitenancyIdx == null) {
                multitenancyIdx = new StatementMappingIndex(multitenancyMapping);
                this.mappingDefinition.addMappingForMember(SurrogateColumnType.MULTITENANCY.getFieldNumber(), multitenancyIdx);
            }
            multitenancyIdx.addParameterOccurrence(new int[]{inputParamNum++});
        }
        if ((softDeleteMapping = table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
            SQLExpression softDeleteExpr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), softDeleteMapping);
            SQLExpression softDeleteValParam = exprFactory.newLiteralParameter(sqlStatement, softDeleteMapping, null, "SOFTDELETE");
            sqlStatement.whereAnd(softDeleteExpr.eq(softDeleteValParam), true);
            StatementMappingIndex softDeleteIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.SOFTDELETE.getFieldNumber());
            if (softDeleteIdx == null) {
                softDeleteIdx = new StatementMappingIndex(softDeleteMapping);
                this.mappingDefinition.addMappingForMember(SurrogateColumnType.SOFTDELETE.getFieldNumber(), softDeleteIdx);
            }
            softDeleteIdx.addParameterOccurrence(new int[]{inputParamNum++});
        }
        this.statementUnlocked = sqlStatement.getSQLText().toSQL();
        sqlStatement.addExtension("lock-for-update", Boolean.TRUE);
        this.statementLocked = sqlStatement.getSQLText().toSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ObjectProvider op) {
        if (this.statementLocked != null) {
            ExecutionContext ec = op.getExecutionContext();
            RDBMSStoreManager storeMgr = this.table.getStoreManager();
            boolean locked = ec.getSerializeReadForClass(op.getClassMetaData().getFullClassName());
            LockMode lockType = ec.getLockManager().getLockMode(op.getInternalObjectId());
            if (lockType != LockMode.LOCK_NONE && (lockType == LockMode.LOCK_PESSIMISTIC_READ || lockType == LockMode.LOCK_PESSIMISTIC_WRITE)) {
                locked = true;
            }
            String statement = locked ? this.statementLocked : this.statementUnlocked;
            try {
                ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    try {
                        JavaTypeMapping softDeleteMapping;
                        int i;
                        JavaTypeMapping multitenancyMapping;
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
                            for (int i2 = 0; i2 < datastoreIdx.getNumberOfParameterOccurrences(); ++i2) {
                                this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, datastoreIdx.getParameterPositionsForOccurrence(i2), op.getInternalObjectId());
                            }
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            op.provideFields(cmd.getPKMemberPositions(), (FieldManager)new ParameterSetter(op, ps, this.mappingDefinition));
                        }
                        if ((multitenancyMapping = this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false)) != null) {
                            StatementMappingIndex multitenancyIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.MULTITENANCY.getFieldNumber());
                            String tenantId = ec.getNucleusContext().getMultiTenancyId(ec, cmd);
                            for (i = 0; i < multitenancyIdx.getNumberOfParameterOccurrences(); ++i) {
                                multitenancyMapping.setObject(ec, ps, multitenancyIdx.getParameterPositionsForOccurrence(i), tenantId);
                            }
                        }
                        if ((softDeleteMapping = this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
                            StatementMappingIndex softDeleteIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.SOFTDELETE.getFieldNumber());
                            for (i = 0; i < softDeleteIdx.getNumberOfParameterOccurrences(); ++i) {
                                softDeleteMapping.setObject(ec, ps, softDeleteIdx.getParameterPositionsForOccurrence(i), Boolean.FALSE);
                            }
                        }
                        try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, statement, ps);){
                            if (!rs.next()) {
                                NucleusLogger.DATASTORE_RETRIEVE.info((Object)Localiser.msg((String)"050018", (Object[])new Object[]{op.getInternalObjectId()}));
                                throw new NucleusObjectNotFoundException("No such database row", op.getInternalObjectId());
                            }
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException sqle) {
                String msg = Localiser.msg((String)"052220", (Object[])new Object[]{op.getObjectAsPrintable(), statement, sqle.getMessage()});
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(sqle);
                while ((sqle = sqle.getNextException()) != null) {
                    exceptions.add(sqle);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
    }
}

