/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class ArraySizeMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(Localiser.msg((String)"060015", (Object[])new Object[]{"size/length", "ArrayExpression"}));
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (expr instanceof ArrayLiteral) {
            return exprFactory.newLiteral(stmt, exprFactory.getMappingForType(Integer.TYPE, false), Array.getLength(((ArrayLiteral)expr).getValue()));
        }
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        String elementType = ownerMmd.getArray().getElementType();
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        JavaTypeMapping ownerMapping = null;
        Table arrayTbl = null;
        if (ownerMmd.getMappedBy() != null) {
            AbstractMemberMetaData elementMmd = ownerMmd.getRelatedMemberMetaData(clr)[0];
            if (ownerMmd.getJoinMetaData() != null || elementMmd.getJoinMetaData() != null) {
                arrayTbl = storeMgr.getTable(ownerMmd);
                ownerMapping = ((JoinTable)arrayTbl).getOwnerMapping();
            } else {
                arrayTbl = storeMgr.getDatastoreClass(elementType, clr);
                ownerMapping = arrayTbl.getMemberMapping(elementMmd);
            }
        } else if (ownerMmd.getJoinMetaData() != null) {
            arrayTbl = storeMgr.getTable(ownerMmd);
            ownerMapping = ((JoinTable)arrayTbl).getOwnerMapping();
        } else {
            arrayTbl = storeMgr.getDatastoreClass(elementType, clr);
            ownerMapping = ((DatastoreClass)arrayTbl).getExternalMapping(ownerMmd, MappingType.EXTERNAL_FK);
        }
        SelectStatement subStmt = new SelectStatement(stmt, storeMgr, arrayTbl, null, null);
        subStmt.setClassLoaderResolver(clr);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        JavaTypeMapping subqMapping = exprFactory.getMappingForType(Integer.class, false);
        NumericSubqueryExpression subqExpr = new NumericSubqueryExpression(stmt, subStmt);
        subqExpr.setJavaTypeMapping(subqMapping);
        return subqExpr;
    }
}

