/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;

public final class PersistentClassROF<T>
implements ResultObjectFactory<T> {
    protected final RDBMSStoreManager storeMgr;
    protected final AbstractClassMetaData acmd;
    private Class<T> persistentClass;
    protected StatementClassMapping stmtMapping = null;
    protected final FetchPlan fetchPlan;
    private final boolean ignoreCache;
    private Map resolvedClasses = new SoftValueMap();

    public PersistentClassROF(RDBMSStoreManager storeMgr, AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, FetchPlan fetchPlan, Class<T> persistentClass) {
        if (mappingDefinition == null) {
            throw new NucleusException("Attempt to create PersistentClassROF with null mappingDefinition");
        }
        this.storeMgr = storeMgr;
        this.stmtMapping = mappingDefinition;
        this.acmd = acmd;
        this.ignoreCache = ignoreCache;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
    }

    @Override
    public T getObject(ExecutionContext ec, ResultSet rs) {
        int[] mappedFieldNumbers;
        StatementClassMapping mappingDefinition;
        AbstractClassMetaData cmd;
        Object[] subclasses;
        String[] subclasses2;
        String className = null;
        boolean requiresInheritanceCheck = true;
        StatementMappingIndex discrimMapIdx = this.stmtMapping.getMappingForMemberPosition(-3);
        if (discrimMapIdx != null) {
            try {
                String discrimValue = rs.getString(discrimMapIdx.getColumnPositions()[0]);
                if (discrimValue == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of discriminator is null so assuming object is null");
                    return null;
                }
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getTable().getDiscriminatorMetaData() : null;
                className = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discrimValue, dismd);
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception obtaining value of discriminator : " + sqle.getMessage()));
            }
        } else if (this.stmtMapping.getNucleusTypeColumnName() != null) {
            try {
                className = rs.getString(this.stmtMapping.getNucleusTypeColumnName());
                if (className == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of determiner column is null so assuming object is null");
                    return null;
                }
                className = className.trim();
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
        }
        if (requiresInheritanceCheck && ((subclasses2 = ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) == null || subclasses2.length == 0)) {
            requiresInheritanceCheck = false;
        }
        String warnMsg = null;
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            Class concreteSubclass = null;
            int numConcreteSubclasses = 0;
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                ++numConcreteSubclasses;
                concreteSubclass = subcls;
            }
            if (numConcreteSubclasses == 1) {
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)Localiser.msg((String)"052300", (Object[])new Object[]{pcClassForObject.getName(), concreteSubclass.getName()}));
                pcClassForObject = concreteSubclass;
            } else {
                if (numConcreteSubclasses == 0) {
                    throw new NucleusUserException(Localiser.msg((String)"052301", (Object[])new Object[]{pcClassForObject.getName()}));
                }
                warnMsg = "Found type=" + pcClassForObject + " but abstract and more than 1 concrete subclass (" + StringUtils.objectArrayToString((Object[])subclasses) + "). Really you need a discriminator to help identifying the type. Choosing " + concreteSubclass;
                pcClassForObject = concreteSubclass;
                requiresInheritanceCheck = true;
            }
        }
        if ((cmd = ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr)) == null) {
            return null;
        }
        int[] fieldNumbers = this.stmtMapping.getMemberNumbers();
        if (this.acmd instanceof InterfaceMetaData) {
            mappingDefinition = new StatementClassMapping();
            mappingDefinition.setNucleusTypeColumnName(this.stmtMapping.getNucleusTypeColumnName());
            mappedFieldNumbers = new int[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                mappingDefinition.addMappingForMember(mappedFieldNumbers[i], this.stmtMapping.getMappingForMemberPosition(fieldNumbers[i]));
            }
        } else {
            mappingDefinition = this.stmtMapping;
            mappedFieldNumbers = fieldNumbers;
        }
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        Object surrogateVersion = null;
        StatementMappingIndex versionMapping = null;
        if (vermd != null) {
            if (vermd.getFieldName() == null) {
                versionMapping = this.stmtMapping.getMappingForMemberPosition(-2);
            } else {
                AbstractMemberMetaData vermmd = cmd.getMetaDataForMember(vermd.getFieldName());
                versionMapping = this.stmtMapping.getMappingForMemberPosition(vermmd.getAbsoluteFieldNumber());
            }
        }
        if (versionMapping != null) {
            JavaTypeMapping mapping = versionMapping.getMapping();
            surrogateVersion = mapping.getObject(ec, rs, versionMapping.getColumnPositions());
        }
        Object obj = null;
        boolean needToSetVersion = false;
        if (this.persistentClass.isInterface() && !cmd.isImplementationOfPersistentDefinition() && (cmd = ec.getMetaDataManager().getMetaDataForInterface(this.persistentClass, clr)) == null) {
            cmd = ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNumbers = cmd.getPKMemberPositions();
            boolean nullObject = true;
            block8: for (int i = 0; i < pkNumbers.length; ++i) {
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
                if (pkIdx == null) {
                    throw new NucleusException("You have just executed an SQL statement yet the information for the primary key column(s) is not available! Please generate a testcase and report this issue");
                }
                int[] colPositions = pkIdx.getColumnPositions();
                for (int j = 0; j < colPositions.length; ++j) {
                    try {
                        Object pkObj = rs.getObject(colPositions[j]);
                        if (pkObj != null) {
                            nullObject = false;
                            continue block8;
                        }
                    }
                    catch (SQLException sqle) {
                        NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception thrown while retrieving results ", (Throwable)sqle);
                    }
                    if (!nullObject) continue block8;
                }
            }
            if (!nullObject) {
                Object id;
                String idClassName;
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if ((idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)(id = PersistentClassROF.getIdentityForResultSetRow(this.storeMgr, rs, mappingDefinition, ec, cmd, pcClassForObject, requiresInheritanceCheck)))) != null) {
                    pcClassForObject = ec.getClassLoaderResolver().classForName(idClassName);
                }
                obj = this.findObjectWithIdAndLoadFields(id, ec, rs, mappingDefinition, mappedFieldNumbers, pcClassForObject, cmd, surrogateVersion);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.stmtMapping.getMappingForMemberPosition(-1);
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            Object id = mapping.getObject(ec, rs, datastoreIdMapping.getColumnPositions());
            if (id != null) {
                String idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)id);
                if (!pcClassForObject.getName().equals(idClassName)) {
                    id = ec.getNucleusContext().getIdentityManager().getDatastoreId(pcClassForObject.getName(), IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
                }
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if (mappedFieldNumbers == null) {
                    obj = ec.findObject(id, false, requiresInheritanceCheck, null);
                    needToSetVersion = true;
                } else {
                    obj = this.findObjectWithIdAndLoadFields(id, ec, rs, mappingDefinition, mappedFieldNumbers, requiresInheritanceCheck ? null : pcClassForObject, cmd, surrogateVersion);
                }
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            String classNameForId = className;
            if (className == null) {
                classNameForId = cmd.getFullClassName();
            }
            Object id = ec.newObjectId(classNameForId, null);
            if (mappedFieldNumbers == null) {
                obj = ec.findObject(id, false, requiresInheritanceCheck, null);
                needToSetVersion = true;
            } else {
                obj = this.findObjectWithIdAndLoadFields(id, ec, rs, mappingDefinition, fieldNumbers, pcClassForObject, cmd, surrogateVersion);
            }
        }
        if (obj != null && needToSetVersion) {
            ObjectProvider objOP;
            Object verFieldValue;
            int versionFieldNumber;
            if (surrogateVersion != null) {
                ObjectProvider objOP2 = ec.findObjectProvider(obj);
                objOP2.setVersion(surrogateVersion);
            } else if (vermd != null && vermd.getFieldName() != null && this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = this.acmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objOP = ec.findObjectProvider(obj)).provideField(versionFieldNumber)) != null) {
                objOP.setVersion(verFieldValue);
            }
        }
        return (T)obj;
    }

    private T findObjectWithIdAndLoadFields(Object id, ExecutionContext ec, final ResultSet resultSet, final StatementClassMapping mappingDefinition, final int[] fieldNumbers, Class pcClass, final AbstractClassMetaData cmd, final Object surrogateVersion) {
        return (T)ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                Object verFieldValue;
                VersionMetaData vermd;
                int versionFieldNumber;
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(op, resultSet, mappingDefinition);
                op.replaceFields(fieldNumbers, fm, false);
                if (surrogateVersion != null) {
                    op.setVersion(surrogateVersion);
                } else if (cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getFieldName() != null && PersistentClassROF.this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = PersistentClassROF.this.acmd.getMetaDataForMember((vermd = cmd.getVersionMetaData()).getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = op.provideField(versionFieldNumber)) != null) {
                    op.setVersion(verFieldValue);
                }
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(op, resultSet, mappingDefinition);
                op.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache, false);
    }

    public static Object getIdentityForResultSetRow(RDBMSStoreManager storeMgr, ResultSet resultSet, StatementClassMapping mappingDefinition, ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return PersistentClassROF.getDatastoreIdentityForResultSetRow(ec, cmd, pcClass, inheritanceCheck, resultSet, mappingDefinition);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ResultSetGetter resultsFM = new ResultSetGetter(storeMgr, ec, resultSet, mappingDefinition, cmd);
            return IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, (Class)pcClass, (boolean)inheritanceCheck, (FieldManager)resultsFM);
        }
        return null;
    }

    public static Object getDatastoreIdentityForResultSetRow(ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck, ResultSet resultSet, StatementClassMapping mappingDefinition) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping;
            JavaTypeMapping mapping;
            Object id;
            if (pcClass == null) {
                pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
            }
            if ((id = (mapping = (datastoreIdMapping = mappingDefinition.getMappingForMemberPosition(-1)).getMapping()).getObject(ec, resultSet, datastoreIdMapping.getColumnPositions())) != null && !pcClass.getName().equals(IdentityUtils.getTargetClassNameForIdentity((Object)id))) {
                id = ec.getNucleusContext().getIdentityManager().getDatastoreId(pcClass.getName(), IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
            }
            if (inheritanceCheck) {
                if (ec.hasIdentityInCache(id)) {
                    return id;
                }
                String[] subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true);
                if (subclasses != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        id = ec.getNucleusContext().getIdentityManager().getDatastoreId(subclasses[i], IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
                        if (!ec.hasIdentityInCache(id)) continue;
                        return id;
                    }
                }
                String className = ec.getStoreManager().getClassNameForObjectID(id, ec.getClassLoaderResolver(), ec);
                return ec.getNucleusContext().getIdentityManager().getDatastoreId(className, IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
            }
            return id;
        }
        return null;
    }
}

