/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractSQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultMetaDataROF;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class SQLQuery
extends AbstractSQLQuery {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected transient boolean isCompiled = false;
    protected transient StatementMappingIndex[] stmtMappings;

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec, SQLQuery query) {
        super(storeMgr, ec, (AbstractSQLQuery)query);
    }

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        super(storeMgr, ec, (String)null);
    }

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec, String queryString) {
        super(storeMgr, ec, queryString);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.inputSQL.equals(((SQLQuery)((Object)obj)).inputSQL);
    }

    public int hashCode() {
        return super.hashCode() ^ this.inputSQL.hashCode();
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.stmtMappings = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean processesRangeInDatastoreQuery() {
        return true;
    }

    public void compileInternal(Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        this.compiledSQL = this.generateQueryStatement();
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("059012", (Object)this.compiledSQL));
        }
        this.isCompiled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected Object performExecute(Map parameters) {
        if (parameters.size() != (this.parameterNames != null ? this.parameterNames.length : 0)) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("059019", (Object)("" + this.parameterNames.length), (Object)("" + parameters.size())));
        }
        if (this.type == 2 || this.type == 1) {
            try {
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    Object obj;
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.compiledSQL, false);
                    try {
                        for (int i = 0; i < parameters.size(); ++i) {
                            obj = parameters.get(i + 1);
                            ps.setObject(i + 1, obj);
                        }
                        int[] rcs = sqlControl.executeStatementUpdate(this.ec, mconn, this.compiledSQL, ps, true);
                        obj = (long)rcs[0];
                    }
                    catch (Throwable throwable) {
                        sqlControl.closeStatement(mconn, ps);
                        throw throwable;
                    }
                    sqlControl.closeStatement(mconn, ps);
                    return obj;
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("059025", (Object)this.compiledSQL), (Throwable)e);
            }
        }
        if (this.type == 0) {
            AbstractRDBMSQueryResult qr = null;
            try {
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.compiledSQL, (Query)this);
                    try {
                        for (int i = 0; i < parameters.size(); ++i) {
                            Object obj = parameters.get(i + 1);
                            ps.setObject(i + 1, obj);
                        }
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                        ResultSet rs = sqlControl.executeStatementQuery(this.ec, mconn, this.compiledSQL, ps);
                        try {
                            ResultObjectFactory rof = null;
                            rof = this.resultMetaData != null ? new ResultMetaDataROF(storeMgr, this.resultMetaData) : (this.resultClass != null || this.candidateClass == null ? RDBMSQueryUtils.getResultObjectFactoryForNoCandidateClass(storeMgr, rs, this.resultClass) : this.getResultObjectFactoryForCandidateClass(rs));
                            String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                            qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, null) : new ForwardQueryResult((Query)this, rof, rs, null);
                            ((AbstractRDBMSQueryResult)qr).initialise();
                            AbstractRDBMSQueryResult qr1 = qr;
                            ManagedConnection mconn1 = mconn;
                            mconn.addListener(new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                final /* synthetic */ QueryResult val$qr1;
                                final /* synthetic */ ManagedConnection val$mconn1;
                                {
                                    this.val$qr1 = queryResult;
                                    this.val$mconn1 = managedConnection;
                                }

                                public void transactionFlushed() {
                                }

                                public void transactionPreClose() {
                                    this.val$qr1.disconnect();
                                }

                                public void managedConnectionPreClose() {
                                    if (!SQLQuery.this.ec.getTransaction().isActive()) {
                                        this.val$qr1.disconnect();
                                    }
                                }

                                public void managedConnectionPostClose() {
                                }

                                public void resourcePostClose() {
                                    this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                }
                            });
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    catch (QueryInterruptedException qie) {
                        ps.cancel();
                        throw qie;
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("059025", (Object)this.compiledSQL), (Throwable)e);
            }
            return qr;
        }
        try {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(this.ec);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.compiledSQL, (Query)this);
                try {
                    for (int i = 0; i < parameters.size(); ++i) {
                        Object obj = parameters.get(i + 1);
                        ps.setObject(i + 1, obj);
                    }
                    RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                    sqlControl.executeStatement(this.ec, mconn, this.compiledSQL, ps);
                }
                catch (QueryInterruptedException qie) {
                    ps.cancel();
                    throw qie;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("059025", (Object)this.compiledSQL), (Throwable)e);
        }
        return true;
    }

    protected void assertSupportsCancel() {
    }

    protected ResultObjectFactory getResultObjectFactoryForCandidateClass(ResultSet rs) throws SQLException {
        Object m;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
        AbstractClassMetaData candidateCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        int fieldCount = candidateCmd.getNoOfManagedMembers() + candidateCmd.getNoOfInheritedManagedMembers();
        HashMap<String, Integer> columnFieldNumberMap = new HashMap<String, Integer>();
        this.stmtMappings = new StatementMappingIndex[fieldCount];
        DatastoreClass tbl = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
            AbstractMemberMetaData fmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String fieldName = fmd.getName();
            Class fieldType = fmd.getType();
            m = null;
            if (fmd.getPersistenceModifier() != FieldPersistenceModifier.NONE && ((JavaTypeMapping)(m = tbl != null ? tbl.getMemberMapping(fmd) : storeMgr.getMappingManager().getMappingWithDatastoreMapping(fieldType, false, false, clr))).includeInFetchStatement()) {
                String columnName = null;
                if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                    for (int colNum = 0; colNum < fmd.getColumnMetaData().length; ++colNum) {
                        columnName = fmd.getColumnMetaData()[colNum].getName();
                        columnFieldNumberMap.put(columnName, fieldNumber);
                    }
                } else {
                    columnName = storeMgr.getIdentifierFactory().newColumnIdentifier(fieldName, this.ec.getNucleusContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifierName();
                    columnFieldNumberMap.put(columnName, fieldNumber);
                }
            }
            this.stmtMappings[fieldNumber] = new StatementMappingIndex((JavaTypeMapping)m);
        }
        if (columnFieldNumberMap.size() == 0) {
            throw new NucleusUserException(LOCALISER.msg("059030", (Object)this.candidateClass.getName())).setFatal();
        }
        DatastoreClass table = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        if (table == null) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(candidateCmd, clr);
            if (cmds != null && cmds.length == 1) {
                table = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
            } else {
                throw new NucleusUserException("SQL query specified with class " + this.candidateClass.getName() + " but this doesn't have its own table, or is mapped to multiple tables. Unsupported");
            }
        }
        PersistableMapping idMapping = (PersistableMapping)table.getIdMapping();
        String[] idColNames = new String[idMapping.getNumberOfDatastoreMappings()];
        for (int i = 0; i < idMapping.getNumberOfDatastoreMappings(); ++i) {
            m = idMapping.getDatastoreMapping(i);
            idColNames[i] = m.getColumn().getIdentifier().toString();
        }
        String discrimColName = table.getDiscriminatorMapping(false) != null ? table.getDiscriminatorMapping(false).getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
        String versionColName = table.getVersionMapping(false) != null ? table.getVersionMapping(false).getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        HashSet remainingColumnNames = new HashSet(columnFieldNumberMap.size());
        int colCount = rsmd.getColumnCount();
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        int[] discrimIndex = null;
        int[] matchedFieldNumbers = new int[colCount];
        int fieldNumberPosition = 0;
        for (int colNum = 1; colNum <= colCount; ++colNum) {
            String colName = rsmd.getColumnName(colNum);
            int fieldNumber = -1;
            Integer fieldNum = (Integer)columnFieldNumberMap.get(colName);
            if (fieldNum == null && (fieldNum = (Integer)columnFieldNumberMap.get(colName.toLowerCase())) == null) {
                fieldNum = (Integer)columnFieldNumberMap.get(colName.toUpperCase());
            }
            if (fieldNum != null) {
                fieldNumber = fieldNum;
            }
            if (fieldNumber >= 0) {
                int[] exprIndices = null;
                if (this.stmtMappings[fieldNumber].getColumnPositions() != null) {
                    exprIndices = new int[this.stmtMappings[fieldNumber].getColumnPositions().length + 1];
                    for (int i = 0; i < this.stmtMappings[fieldNumber].getColumnPositions().length; ++i) {
                        exprIndices[i] = this.stmtMappings[fieldNumber].getColumnPositions()[i];
                    }
                    exprIndices[exprIndices.length - 1] = colNum;
                } else {
                    exprIndices = new int[]{colNum};
                }
                this.stmtMappings[fieldNumber].setColumnPositions(exprIndices);
                remainingColumnNames.remove(colName);
                matchedFieldNumbers[fieldNumberPosition++] = fieldNumber;
            }
            if (discrimColName != null && colName.equals(discrimColName)) {
                discrimIndex = new int[]{colNum};
            }
            if (versionColName != null && colName.equals(versionColName)) {
                versionIndex = new int[]{colNum};
            }
            if (candidateCmd.getIdentityType() != IdentityType.DATASTORE || !SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) continue;
            datastoreIndex = new int[]{colNum};
        }
        int[] fieldNumbers = new int[fieldNumberPosition];
        for (int i = 0; i < fieldNumberPosition; ++i) {
            fieldNumbers[i] = matchedFieldNumbers[i];
        }
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            mappingDefinition.addMappingForMember(fieldNumbers[i], this.stmtMappings[fieldNumbers[i]]);
        }
        if (datastoreIndex != null) {
            StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(table.getDatastoreObjectIdMapping());
            datastoreMappingIdx.setColumnPositions(datastoreIndex);
            mappingDefinition.addMappingForMember(-1, datastoreMappingIdx);
        }
        if (discrimIndex != null) {
            StatementMappingIndex discrimMappingIdx = new StatementMappingIndex(table.getDiscriminatorMapping(true));
            discrimMappingIdx.setColumnPositions(discrimIndex);
            mappingDefinition.addMappingForMember(-3, discrimMappingIdx);
        }
        if (versionIndex != null) {
            StatementMappingIndex versionMappingIdx = new StatementMappingIndex(table.getVersionMapping(true));
            versionMappingIdx.setColumnPositions(versionIndex);
            mappingDefinition.addMappingForMember(-2, versionMappingIdx);
        }
        return storeMgr.newResultObjectFactory(candidateCmd, mappingDefinition, this.ignoreCache, this.getFetchPlan(), this.getCandidateClass());
    }

    public static boolean columnNamesAreTheSame(DatastoreAdapter dba, String name1, String name2) {
        return name1.equalsIgnoreCase(name2) || name1.equalsIgnoreCase(dba.getIdentifierQuoteString() + name2 + dba.getIdentifierQuoteString());
    }

    protected String generateQueryStatement() {
        String compiledSQL = this.getInputSQL();
        if (this.candidateClass != null && this.getType() == 0) {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
            if (cmd == null) {
                throw new ClassNotPersistableException(this.candidateClass.getName());
            }
            if (cmd.getPersistableSuperclass() != null) {
                // empty if block
            }
            if (this.getResultClass() == null) {
                int i;
                String[] selectedColumns;
                String selections = this.stripComments(compiledSQL.trim()).substring(7);
                int fromStart = selections.indexOf("FROM");
                if (fromStart == -1) {
                    fromStart = selections.indexOf("from");
                }
                if ((selectedColumns = StringUtils.split((String)(selections = selections.substring(0, fromStart).trim()), (String)",")) == null || selectedColumns.length == 0) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059003", (Object)compiledSQL));
                }
                if (selectedColumns.length == 1 && selectedColumns[0].trim().equals("*")) {
                    return compiledSQL;
                }
                DatastoreClass table = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
                PersistableMapping idMapping = (PersistableMapping)table.getIdMapping();
                String[] idColNames = new String[idMapping.getNumberOfDatastoreMappings()];
                boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreMappings()];
                for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreMappings(); ++i2) {
                    DatastoreMapping m = idMapping.getDatastoreMapping(i2);
                    idColNames[i2] = m.getColumn().getIdentifier().toString();
                    idColMissing[i2] = true;
                }
                String discriminatorColName = table.getDiscriminatorMapping(false) != null ? table.getDiscriminatorMapping(false).getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
                String versionColName = table.getVersionMapping(false) != null ? table.getVersionMapping(false).getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
                boolean discrimMissing = discriminatorColName != null;
                boolean versionMissing = true;
                if (versionColName == null) {
                    versionMissing = false;
                }
                DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                AbstractClassMetaData candidateCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                for (i = 0; i < selectedColumns.length; ++i) {
                    String colName = selectedColumns[i].trim();
                    if (colName.indexOf(" AS ") > 0) {
                        colName = colName.substring(colName.indexOf(" AS ") + 4).trim();
                    } else if (colName.indexOf(" as ") > 0) {
                        colName = colName.substring(colName.indexOf(" as ") + 4).trim();
                    }
                    if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                        if (SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) {
                            idColMissing[0] = false;
                        }
                    } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                        for (int j = 0; j < idColNames.length; ++j) {
                            if (!SQLQuery.columnNamesAreTheSame(dba, idColNames[j], colName)) continue;
                            idColMissing[j] = false;
                        }
                    }
                    if (discrimMissing && SQLQuery.columnNamesAreTheSame(dba, discriminatorColName, colName)) {
                        discrimMissing = false;
                        continue;
                    }
                    if (!versionMissing || !SQLQuery.columnNamesAreTheSame(dba, versionColName, colName)) continue;
                    versionMissing = false;
                }
                if (discrimMissing) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059014", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)discriminatorColName));
                }
                if (versionMissing) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059015", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)versionColName));
                }
                for (i = 0; i < idColMissing.length; ++i) {
                    if (!idColMissing[i]) continue;
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059013", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)idColNames[i]));
                }
            }
        }
        return compiledSQL;
    }

    private String stripComments(String sql) {
        return sql.replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "");
    }
}

