/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;

public class TypeConverterStringMapping
extends TypeConverterMapping {
    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)fieldType);
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for type " + type + " yet this is not using String in the datastore");
        }
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.initialize(mmd, table, clr, null);
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, TypeConverter conv) {
        super.initialize(mmd, table, clr, conv);
        Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)mmd.getType());
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for member " + mmd.getFullFieldName() + " yet this is not using String in the datastore");
        }
    }

    @Override
    public int getDefaultLength(int index) {
        if (this.converter instanceof ColumnLengthDefiningTypeConverter) {
            return ((ColumnLengthDefiningTypeConverter)this.converter).getDefaultColumnLength(index);
        }
        return super.getDefaultLength(index);
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return String.class.getName();
    }
}

