/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDBCUtils {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());

    public static String getSubprotocolForURL(String url) {
        StringTokenizer tokeniser = new StringTokenizer(url, ":");
        tokeniser.nextToken();
        return tokeniser.nextToken();
    }

    public static void logWarnings(SQLWarning warning) {
        while (warning != null) {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("052700", (Object)warning.getMessage()));
            warning = warning.getNextWarning();
        }
    }

    public static void logWarnings(Connection conn) {
        try {
            JDBCUtils.logWarnings(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052701", (Object)conn), (Throwable)e);
        }
    }

    public static void logWarnings(Statement stmt) {
        try {
            JDBCUtils.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052702", (Object)stmt), (Throwable)e);
        }
    }

    public static void logWarnings(ResultSet rs) {
        try {
            JDBCUtils.logWarnings(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052703", (Object)rs), (Throwable)e);
        }
    }
}

