/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.time.calendar.LocalDate;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.rdbms.mapping.java.TemporalMapping;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateMapping
extends TemporalMapping {
    @Override
    public Class getJavaType() {
        return LocalDate.class;
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.datastoreMappings == null || this.datastoreMappings.length == 0) {
            ColumnMetaData[] colmds = LocalDateMapping.getColumnMetaDataForMember(this.mmd, this.roleForMember);
            boolean useString = false;
            if (colmds != null && colmds.length > 0 && colmds[0].getJdbcType() != null && MetaDataUtils.isJdbcTypeString((String)colmds[0].getJdbcType())) {
                useString = true;
            }
            return useString ? ClassNameConstants.JAVA_LANG_STRING : ClassNameConstants.JAVA_SQL_DATE;
        }
        if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return ClassNameConstants.JAVA_SQL_DATE;
    }

    @Override
    protected int getDefaultLengthAsString() {
        return 10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
            return;
        } else if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(LocalDate.class, String.class);
            if (conv == null) throw new NucleusUserException("This type doesn't support persistence as a String");
            Object obj = conv.toDatastoreType(value);
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], obj);
            return;
        } else {
            LocalDate localDate = (LocalDate)value;
            Calendar cal = Calendar.getInstance();
            cal.set(localDate.getYear(), localDate.getMonthOfYear().ordinal(), localDate.getDayOfMonth());
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], cal);
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        if (datastoreValue == null) {
            return null;
        }
        if (datastoreValue instanceof String) {
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(LocalDate.class, String.class);
            if (conv != null) {
                return conv.toMemberType(datastoreValue);
            }
            throw new NucleusUserException("This type doesn't support persistence as a String");
        }
        if (datastoreValue instanceof Date) {
            Date date = (Date)datastoreValue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            LocalDate localDate = LocalDate.of((int)cal.get(1), (int)(cal.get(2) + 1), (int)cal.get(5));
            return localDate;
        }
        if (datastoreValue instanceof Timestamp) {
            Timestamp ts = (Timestamp)datastoreValue;
            LocalDate localDate = LocalDate.of((int)ts.getYear(), (int)(ts.getMonth() + 1), (int)ts.getDay());
            return localDate;
        }
        return null;
    }
}

