/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;

public final class PersistentClassROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected final RDBMSStoreManager storeMgr;
    protected final AbstractClassMetaData acmd;
    private Class persistentClass;
    protected StatementClassMapping stmtMapping = null;
    protected final FetchPlan fetchPlan;
    private final boolean ignoreCache;
    private Map resolvedClasses = new SoftValueMap();

    public PersistentClassROF(RDBMSStoreManager storeMgr, AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, FetchPlan fetchPlan, Class persistentClass) {
        if (mappingDefinition == null) {
            throw new NucleusException("Attempt to create PersistentIDROF with null mappingDefinition");
        }
        this.storeMgr = storeMgr;
        this.stmtMapping = mappingDefinition;
        this.acmd = acmd;
        this.ignoreCache = ignoreCache;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
    }

    public void setPersistentClass(Class cls) {
        this.persistentClass = cls;
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs) {
        int[] mappedFieldNumbers;
        StatementClassMapping mappingDefinition;
        AbstractClassMetaData cmd;
        Object[] subclasses;
        String className = null;
        boolean requiresInheritanceCheck = true;
        StatementMappingIndex discrimMapIdx = this.stmtMapping.getMappingForMemberPosition(-3);
        if (discrimMapIdx != null) {
            try {
                String discrimValue = rs.getString(discrimMapIdx.getColumnPositions()[0]);
                if (discrimValue == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of discriminator is null so assuming object is null");
                    return null;
                }
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getTable().getDiscriminatorMetaData() : null;
                className = MetaDataUtils.getClassNameFromDiscriminatorValue((String)discrimValue, (DiscriminatorMetaData)dismd, (ExecutionContext)ec);
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception obtaining value of discriminator : " + sqle.getMessage()));
            }
        } else if (this.stmtMapping.getNucleusTypeColumnName() != null) {
            try {
                className = rs.getString(this.stmtMapping.getNucleusTypeColumnName()).trim();
                if (className == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of determiner column is null so assuming object is null");
                    return null;
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
            requiresInheritanceCheck = false;
        }
        String warnMsg = null;
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            Class concreteSubclass = null;
            int numConcreteSubclasses = 0;
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                ++numConcreteSubclasses;
                concreteSubclass = subcls;
            }
            if (numConcreteSubclasses == 1) {
                pcClassForObject = concreteSubclass;
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)LOCALISER.msg("052300", (Object)pcClassForObject.getName(), (Object)concreteSubclass.getName()));
            } else {
                if (numConcreteSubclasses == 0) {
                    throw new NucleusUserException(LOCALISER.msg("052301", (Object)pcClassForObject.getName()));
                }
                warnMsg = "Found type=" + pcClassForObject + " but abstract and more than 1 concrete subclass (" + StringUtils.objectArrayToString((Object[])subclasses) + "). Really you need a discriminator " + " to help identifying the type. Choosing " + concreteSubclass;
                pcClassForObject = concreteSubclass;
                requiresInheritanceCheck = true;
            }
        }
        if ((cmd = ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr)) == null) {
            return null;
        }
        int[] fieldNumbers = this.stmtMapping.getMemberNumbers();
        if (this.acmd instanceof InterfaceMetaData) {
            mappingDefinition = new StatementClassMapping();
            mappingDefinition.setNucleusTypeColumnName(this.stmtMapping.getNucleusTypeColumnName());
            mappedFieldNumbers = new int[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                mappingDefinition.addMappingForMember(mappedFieldNumbers[i], this.stmtMapping.getMappingForMemberPosition(fieldNumbers[i]));
            }
        } else {
            mappingDefinition = this.stmtMapping;
            mappedFieldNumbers = fieldNumbers;
        }
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        Object surrogateVersion = null;
        StatementMappingIndex versionMapping = null;
        if (vermd != null) {
            if (vermd.getFieldName() == null) {
                versionMapping = this.stmtMapping.getMappingForMemberPosition(-2);
            } else {
                AbstractMemberMetaData vermmd = cmd.getMetaDataForMember(vermd.getFieldName());
                versionMapping = this.stmtMapping.getMappingForMemberPosition(vermmd.getAbsoluteFieldNumber());
            }
        }
        if (versionMapping != null) {
            JavaTypeMapping mapping = versionMapping.getMapping();
            surrogateVersion = mapping.getObject(ec, rs, versionMapping.getColumnPositions());
        }
        Object obj = null;
        boolean needToSetVersion = false;
        if (this.persistentClass.isInterface() && !cmd.isImplementationOfPersistentDefinition()) {
            cmd = ec.getMetaDataManager().getMetaDataForInterface(this.persistentClass, clr);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNumbers = cmd.getPKMemberPositions();
            boolean nullObject = true;
            block8: for (int i = 0; i < pkNumbers.length; ++i) {
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
                if (pkIdx == null) {
                    throw new NucleusException("You have just executed an SQL statement yet the information for the primary key column(s) is not available! Please generate a testcase and report this issue");
                }
                int[] colPositions = pkIdx.getColumnPositions();
                for (int j = 0; j < colPositions.length; ++j) {
                    try {
                        Object pkObj = rs.getObject(colPositions[j]);
                        if (pkObj != null) {
                            nullObject = false;
                            continue block8;
                        }
                    }
                    catch (SQLException sqle) {
                        NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception thrown while retrieving results ", (Throwable)sqle);
                    }
                    if (!nullObject) continue block8;
                }
            }
            if (nullObject) {
                obj = null;
            } else {
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                obj = this.getObjectForApplicationId(ec, rs, mappingDefinition, mappedFieldNumbers, pcClassForObject, cmd, requiresInheritanceCheck, surrogateVersion);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.stmtMapping.getMappingForMemberPosition(-1);
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            OID oid = (OID)mapping.getObject(ec, rs, datastoreIdMapping.getColumnPositions());
            if (oid != null) {
                OID id = oid;
                if (!pcClassForObject.getName().equals(oid.getPcClass())) {
                    id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)pcClassForObject.getName(), (Object)oid.getKeyValue());
                }
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if (mappedFieldNumbers == null) {
                    obj = ec.findObject((Object)id, false, requiresInheritanceCheck, null);
                    needToSetVersion = true;
                } else {
                    obj = this.getObjectForDatastoreId(ec, rs, mappingDefinition, mappedFieldNumbers, id, requiresInheritanceCheck ? null : pcClassForObject, cmd, surrogateVersion);
                }
            } else {
                obj = null;
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            Object id = ec.newObjectId(className, null);
            if (mappedFieldNumbers == null) {
                obj = ec.findObject(id, false, requiresInheritanceCheck, null);
                needToSetVersion = true;
            } else {
                obj = this.getObjectForDatastoreId(ec, rs, mappingDefinition, mappedFieldNumbers, id, pcClassForObject, cmd, surrogateVersion);
            }
        }
        if (obj != null && needToSetVersion) {
            ObjectProvider objSM;
            Object verFieldValue;
            int versionFieldNumber;
            if (surrogateVersion != null) {
                ObjectProvider objSM2 = ec.findObjectProvider(obj);
                objSM2.setVersion(surrogateVersion);
            } else if (vermd != null && vermd.getFieldName() != null && this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = this.acmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objSM = ec.findObjectProvider(obj)).provideField(versionFieldNumber)) != null) {
                objSM.setVersion(verFieldValue);
            }
        }
        return obj;
    }

    private Object getObjectForApplicationId(ExecutionContext ec, final ResultSet resultSet, final StatementClassMapping mappingDefinition, final int[] fieldNumbers, Class pcClass, final AbstractClassMetaData cmd, boolean requiresInheritanceCheck, final Object surrogateVersion) {
        Object id = PersistentClassROF.getIdentityForResultSetRow(this.storeMgr, resultSet, mappingDefinition, ec, cmd, pcClass, requiresInheritanceCheck);
        if (ec.getApiAdapter().isSingleFieldIdentity(id)) {
            pcClass = ec.getApiAdapter().getTargetClassForSingleFieldIdentity(id);
        }
        return ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                Object verFieldValue;
                VersionMetaData vermd;
                int versionFieldNumber;
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
                if (surrogateVersion != null) {
                    sm.setVersion(surrogateVersion);
                } else if (cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getFieldName() != null && PersistentClassROF.this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = PersistentClassROF.this.acmd.getMetaDataForMember((vermd = cmd.getVersionMetaData()).getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = sm.provideField(versionFieldNumber)) != null) {
                    sm.setVersion(verFieldValue);
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache, false);
    }

    public static Object getIdentityForResultSetRow(RDBMSStoreManager storeMgr, ResultSet resultSet, StatementClassMapping mappingDefinition, ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return PersistentClassROF.getDatastoreIdentityForResultSetRow(ec, cmd, pcClass, inheritanceCheck, resultSet, mappingDefinition);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ResultSetGetter resultsFM = new ResultSetGetter(storeMgr, ec, resultSet, mappingDefinition, cmd);
            return IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, (Class)pcClass, (boolean)inheritanceCheck, (FieldManager)resultsFM);
        }
        return null;
    }

    public static Object getDatastoreIdentityForResultSetRow(ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck, ResultSet resultSet, StatementClassMapping mappingDefinition) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping;
            JavaTypeMapping mapping;
            OID oid;
            if (pcClass == null) {
                pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
            }
            if ((oid = (OID)(mapping = (datastoreIdMapping = mappingDefinition.getMappingForMemberPosition(-1)).getMapping()).getObject(ec, resultSet, datastoreIdMapping.getColumnPositions())) != null && !pcClass.getName().equals(oid.getPcClass())) {
                oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)pcClass.getName(), (Object)oid.getKeyValue());
            }
            if (inheritanceCheck) {
                if (ec.hasIdentityInCache((Object)oid)) {
                    return oid;
                }
                String[] subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true);
                if (subclasses != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)subclasses[i], (Object)oid.getKeyValue());
                        if (!ec.hasIdentityInCache((Object)oid)) continue;
                        return oid;
                    }
                }
                String className = ec.getStoreManager().getClassNameForObjectID((Object)oid, ec.getClassLoaderResolver(), ec);
                return OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)className, (Object)oid.getKeyValue());
            }
            return oid;
        }
        return null;
    }

    private Object getObjectForDatastoreId(ExecutionContext ec, final ResultSet resultSet, final StatementClassMapping mappingDefinition, final int[] fieldNumbers, Object oid, Class pcClass, final AbstractClassMetaData cmd, final Object surrogateVersion) {
        if (oid == null) {
            return null;
        }
        return ec.findObject(oid, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                Object verFieldValue;
                VersionMetaData vermd;
                int versionFieldNumber;
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
                if (surrogateVersion != null) {
                    sm.setVersion(surrogateVersion);
                } else if (cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getFieldName() != null && PersistentClassROF.this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = PersistentClassROF.this.acmd.getMetaDataForMember((vermd = cmd.getVersionMetaData()).getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = sm.provideField(versionFieldNumber)) != null) {
                    sm.setVersion(verFieldValue);
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = PersistentClassROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache, false);
    }
}

