/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class RealRDBMSMapping
extends AbstractDatastoreMapping {
    protected RealRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public RealRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isDecimalBased() {
        return true;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(7, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(7);
    }

    @Override
    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setFloat(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"float", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = ((ResultSet)rs).getFloat(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            try {
                value = Float.parseFloat(((ResultSet)rs).getString(param));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                    throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new NucleusDataStoreException("Can't get float result: param = " + param + " - " + ((ResultSet)rs).getString(param), (Throwable)e);
                }
                catch (SQLException e2) {
                    throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"float", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
                }
            }
        }
        return value;
    }

    @Override
    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else {
                ((PreparedStatement)ps).setFloat(param, ((Float)value).floatValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Object getObject(Object rs, int param) {
        Float value;
        try {
            float f = ((ResultSet)rs).getFloat(param);
            value = ((ResultSet)rs).wasNull() ? null : new Float(f);
        }
        catch (SQLException e) {
            try {
                value = new Float(Float.parseFloat(((ResultSet)rs).getString(param)));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                    throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new NucleusDataStoreException("Can't get float result: param = " + param + " - " + ((ResultSet)rs).getString(param), (Throwable)e);
                }
                catch (SQLException e2) {
                    throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
                }
            }
        }
        return value;
    }
}

