/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected boolean usingDiscriminatorInSizeStmt = false;
    protected ElementInfo[] elementInfo;
    protected AbstractClassMetaData emd;
    protected DatastoreContainerObject containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    protected ClassLoaderResolver clr;

    protected ElementContainerStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.clr = clr;
    }

    public ElementInfo[] getElementInfo() {
        return this.elementInfo;
    }

    public JavaTypeMapping getElementMapping() {
        return this.elementMapping;
    }

    public JavaTypeMapping getOrderMapping() {
        return this.orderMapping;
    }

    public JavaTypeMapping getRelationDiscriminatorMapping() {
        return this.relationDiscriminatorMapping;
    }

    public String getRelationDiscriminatorValue() {
        return this.relationDiscriminatorValue;
    }

    public DatastoreContainerObject getContainerTable() {
        return this.containerTable;
    }

    public AbstractClassMetaData getEmd() {
        return this.emd;
    }

    public boolean isElementsAreSerialised() {
        return this.elementsAreSerialised;
    }

    public boolean isElementsAreEmbedded() {
        return this.elementsAreEmbedded;
    }

    protected ElementInfo[] getElementInformationForClass() {
        String[] clsNames;
        DatastoreClass tbl;
        ElementInfo[] info = null;
        if (!this.clr.classForName(this.elementType).isInterface()) {
            tbl = this.storeMgr.getDatastoreClass(this.elementType, this.clr);
            clsNames = new String[]{this.elementType};
        } else {
            clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, this.clr);
            tbl = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
        }
        if (tbl == null) {
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr);
            info = new ElementInfo[subclassCmds.length];
            for (int i = 0; i < subclassCmds.length; ++i) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                info[i] = new ElementInfo(subclassCmds[i], table);
            }
        } else {
            info = new ElementInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ElementInfo(cmd, table);
            }
        }
        return info;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType((Class)elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }

    protected boolean validateElementForReading(ObjectProvider op, Object element) {
        ExecutionContext ec;
        if (!this.validateElementType(op.getExecutionContext().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (ec = op.getExecutionContext()).getApiAdapter().isPersistent(element) && ec == ec.getApiAdapter().getExecutionContext(element) || ec.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(ExecutionContext ec, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(ec.getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("056033", (Object)element.getClass().getName(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectProvider elementSM = ec.findObjectProvider(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new NucleusUserException(LOCALISER.msg("056028", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            }
            persisted = SCOUtils.validateObjectForWriting((ExecutionContext)ec, (Object)element, (FieldValues)fieldValues);
        }
        return persisted;
    }

    public abstract Iterator iterator(ObjectProvider var1);

    public void clear(ObjectProvider ownerSM) {
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.executeClear(ownerSM);
        if (dependentElements != null && dependentElements.size() > 0) {
            for (Object obj : dependentElements) {
                if (ownerSM.getExecutionContext().getApiAdapter().isDeleted(obj)) continue;
                ownerSM.getExecutionContext().deleteObjectInternal(obj);
            }
        }
    }

    public int size(ObjectProvider op) {
        return this.getSize(op);
    }

    protected void invalidateAddStmt() {
        this.addStmt = null;
    }

    protected String getAddStmt() {
        if (this.addStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer("INSERT INTO ");
            stmt.append(this.getContainerTable().toString());
            stmt.append(" (");
            for (i = 0; i < this.getOwnerMapping().getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(this.getOwnerMapping().getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            for (i = 0; i < this.getElementMapping().getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.getElementMapping().getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            if (this.getOrderMapping() != null) {
                for (i = 0; i < this.getOrderMapping().getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(this.getOrderMapping().getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            if (this.getRelationDiscriminatorMapping() != null) {
                for (i = 0; i < this.getRelationDiscriminatorMapping().getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(this.getRelationDiscriminatorMapping().getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            stmt.append(") VALUES (");
            for (i = 0; i < this.getOwnerMapping().getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)this.getOwnerMapping().getDatastoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.getElementMapping().getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.getElementMapping().getDatastoreMapping(0)).getInsertionInputParameter());
            }
            if (this.getOrderMapping() != null) {
                for (i = 0; i < this.getOrderMapping().getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.getOrderMapping().getDatastoreMapping(0)).getInsertionInputParameter());
                }
            }
            if (this.getRelationDiscriminatorMapping() != null) {
                for (i = 0; i < this.getRelationDiscriminatorMapping().getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.getRelationDiscriminatorMapping().getDatastoreMapping(0)).getInsertionInputParameter());
                }
            }
            stmt.append(") ");
            this.addStmt = stmt.toString();
        }
        return this.addStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClear(ObjectProvider ownerSM) {
        String clearStmt = this.getClearStmt();
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    if (this.getRelationDiscriminatorMapping() != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)clearStmt), (Throwable)e);
        }
    }

    protected String getClearStmt() {
        if (this.clearStmt == null) {
            StringBuffer stmt = new StringBuffer("DELETE FROM ");
            stmt.append(this.getContainerTable().toString());
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            if (this.getRelationDiscriminatorMapping() != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            this.clearStmt = stmt.toString();
        }
        return this.clearStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(ObjectProvider ownerSM) {
        int numRows;
        String sizeStmt = this.getSizeStmt();
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    if (this.getElementInfo() != null && this.getElementInfo().length == 1) {
                        for (int i = 0; i < this.getElementInfo().length; ++i) {
                            if (this.getElementInfo()[i].getDiscriminatorMapping() == null) continue;
                            jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(ec, ps, jdbcPosition, true, this.getElementInfo()[i], this.clr);
                        }
                    }
                    if (this.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException(LOCALISER.msg("056007", (Object)sizeStmt));
                        }
                        numRows = rs.getInt(1);
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056007", (Object)sizeStmt), (Throwable)e);
        }
        return numRows;
    }

    protected String getSizeStmt() {
        int i;
        if (this.sizeStmt != null && !this.usingDiscriminatorInSizeStmt) {
            return this.sizeStmt;
        }
        boolean allowNulls = false;
        if (Boolean.TRUE.equals(this.getOwnerMemberMetaData().getContainer().allowNulls())) {
            allowNulls = true;
        }
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        StringBuffer stmt = new StringBuffer("SELECT COUNT(*) FROM ");
        stmt.append(this.getContainerTable().toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (this.getElementInfo() != null && this.getElementInfo().length == 1 && this.getElementInfo()[0].getDatastoreClass() != this.getContainerTable() && this.getElementInfo()[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = this.getElementInfo()[0].getDatastoreClass().getIdMapping();
            if (allowNulls) {
                stmt.append(" LEFT OUTER JOIN ");
            } else {
                stmt.append(" INNER JOIN ");
            }
            stmt.append(this.getElementInfo()[0].getDatastoreClass().toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i = 0; i < this.getElementMapping().getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(this.getElementMapping().getDatastoreMapping(i).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, containerAlias, true);
        if (this.orderMapping != null) {
            for (int i2 = 0; i2 < this.orderMapping.getNumberOfDatastoreMappings(); ++i2) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(this.orderMapping.getDatastoreMapping(i2).getDatastoreField().getIdentifier().toString());
                stmt.append(">=0");
            }
        }
        if (this.getElementInfo() != null && this.getElementInfo().length == 1) {
            StringBuffer discrStmt = new StringBuffer();
            for (i = 0; i < this.getElementInfo().length; ++i) {
                if (this.getElementInfo()[i].getDiscriminatorMapping() == null) continue;
                this.usingDiscriminatorInSizeStmt = true;
                if (discrStmt.length() > 0) {
                    discrStmt.append(" OR ");
                }
                JavaTypeMapping discrimMapping = this.getElementInfo()[i].getDiscriminatorMapping();
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (joinedDiscrim) {
                        discrStmt.append(joinedElementAlias);
                    } else {
                        discrStmt.append(containerAlias);
                    }
                    discrStmt.append(".");
                    discrStmt.append(discrimMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().toString());
                    discrStmt.append("=");
                    discrStmt.append(((RDBMSMapping)discrimMapping.getDatastoreMapping(j)).getUpdateInputParameter());
                }
                Collection subclasses = this.storeMgr.getSubClassesForClass(this.getElementInfo()[i].getClassName(), true, this.clr);
                if (subclasses == null || subclasses.size() <= 0) continue;
                for (int j = 0; j < subclasses.size(); ++j) {
                    for (int k = 0; k < discrimMapping.getNumberOfDatastoreMappings(); ++k) {
                        discrStmt.append(" OR ");
                        if (joinedDiscrim) {
                            discrStmt.append(joinedElementAlias);
                        } else {
                            discrStmt.append(containerAlias);
                        }
                        discrStmt.append(".");
                        discrStmt.append(discrimMapping.getDatastoreMapping(k).getDatastoreField().getIdentifier().toString());
                        discrStmt.append("=");
                        discrStmt.append(((RDBMSMapping)discrimMapping.getDatastoreMapping(k)).getUpdateInputParameter());
                    }
                }
            }
            if (discrStmt.length() > 0) {
                stmt.append(" AND (");
                stmt.append(discrStmt);
                if (allowNulls) {
                    stmt.append(" OR ");
                    stmt.append(this.getElementInfo()[0].getDiscriminatorMapping().getDatastoreMapping(0).getDatastoreField().getIdentifier().toString());
                    stmt.append(" IS NULL");
                }
                stmt.append(")");
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
        }
        this.sizeStmt = stmt.toString();
        return this.sizeStmt;
    }

    public static class ElementInfo {
        AbstractClassMetaData cmd;
        DatastoreClass table;

        public ElementInfo(AbstractClassMetaData cmd, DatastoreClass table) {
            this.cmd = cmd;
            this.table = table;
        }

        public String getClassName() {
            return this.cmd.getFullClassName();
        }

        public AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        public DatastoreClass getDatastoreClass() {
            return this.table;
        }

        public DiscriminatorStrategy getDiscriminatorStrategy() {
            return this.cmd.getDiscriminatorStrategyForTable();
        }

        public JavaTypeMapping getDiscriminatorMapping() {
            return this.table.getDiscriminatorMapping(false);
        }
    }
}

