/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;

public class BackingStoreHelper {
    public static int populateOwnerInStatement(ObjectProvider op, ExecutionContext ec, Object ps, int jdbcPosition, BaseContainerStore bcs) {
        if (!bcs.getStoreManager().insertValuesOnInsert(bcs.getOwnerMapping().getDatastoreMapping(0))) {
            return jdbcPosition;
        }
        if (bcs.getOwnerMemberMetaData() != null) {
            bcs.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)bcs.getOwnerMapping()), op.getObject(), op, bcs.getOwnerMemberMetaData().getAbsoluteFieldNumber());
        } else {
            bcs.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)bcs.getOwnerMapping()), op.getObject());
        }
        return jdbcPosition + bcs.getOwnerMapping().getNumberOfDatastoreMappings();
    }

    public static int populateRelationDiscriminatorInStatement(ExecutionContext ec, PreparedStatement ps, int jdbcPosition, ElementContainerStore ecs) {
        ecs.getRelationDiscriminatorMapping().setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ecs.getRelationDiscriminatorMapping()), (Object)ecs.getRelationDiscriminatorValue());
        return jdbcPosition + ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreMappings();
    }

    public static int populateOrderInStatement(ExecutionContext ec, Object ps, int idx, int jdbcPosition, JavaTypeMapping orderMapping) {
        orderMapping.setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)orderMapping), (Object)idx);
        return jdbcPosition + orderMapping.getNumberOfDatastoreMappings();
    }

    public static int populateElementInStatement(ExecutionContext ec, Object ps, Object element, int jdbcPosition, JavaTypeMapping elementMapping) {
        if (!elementMapping.getStoreManager().insertValuesOnInsert(elementMapping.getDatastoreMapping(0))) {
            return jdbcPosition;
        }
        elementMapping.setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)elementMapping), element);
        return jdbcPosition + elementMapping.getNumberOfDatastoreMappings();
    }

    public static int populateElementForWhereClauseInStatement(ExecutionContext ec, Object ps, Object element, int jdbcPosition, JavaTypeMapping elementMapping) {
        if (elementMapping.getStoreManager().insertValuesOnInsert(elementMapping.getDatastoreMapping(0))) {
            if (elementMapping instanceof ReferenceMapping && elementMapping.getNumberOfDatastoreMappings() > 1) {
                ReferenceMapping elemRefMapping = (ReferenceMapping)elementMapping;
                JavaTypeMapping[] elemFkMappings = elemRefMapping.getJavaTypeMapping();
                int[] positions = null;
                for (int i = 0; i < elemFkMappings.length; ++i) {
                    if (!elemFkMappings[i].getType().equals(element.getClass().getName())) continue;
                    positions = new int[elemFkMappings[i].getNumberOfDatastoreMappings()];
                    for (int j = 0; j < positions.length; ++j) {
                        positions[j] = jdbcPosition++;
                    }
                }
                elementMapping.setObject(ec, ps, positions, element);
                jdbcPosition += positions.length;
            } else {
                elementMapping.setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)elementMapping), element);
                jdbcPosition += elementMapping.getNumberOfDatastoreMappings();
            }
        }
        return jdbcPosition;
    }

    public static int populateKeyInStatement(ExecutionContext ec, PreparedStatement ps, Object key, int jdbcPosition, JavaTypeMapping keyMapping) {
        if (!((RDBMSMapping)keyMapping.getDatastoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        keyMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)keyMapping), key);
        return jdbcPosition + keyMapping.getNumberOfDatastoreMappings();
    }

    public static int populateValueInStatement(ExecutionContext ec, PreparedStatement ps, Object value, int jdbcPosition, JavaTypeMapping valueMapping) {
        if (!((RDBMSMapping)valueMapping.getDatastoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        valueMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)valueMapping), value);
        return jdbcPosition + valueMapping.getNumberOfDatastoreMappings();
    }

    public static int populateElementDiscriminatorInStatement(ExecutionContext ec, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ElementContainerStore.ElementInfo info, ClassLoaderResolver clr) {
        MappedStoreManager storeMgr;
        Collection subclasses;
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)info.getClassName());
            jdbcPosition += discrimMapping.getNumberOfDatastoreMappings();
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            discrimMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)info.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            jdbcPosition += discrimMapping.getNumberOfDatastoreMappings();
        }
        if (includeSubclasses && (subclasses = (storeMgr = discrimMapping.getStoreManager()).getSubClassesForClass(info.getClassName(), true, clr)) != null && subclasses.size() > 0) {
            for (String subclass : subclasses) {
                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                    discrimMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)subclass);
                    jdbcPosition += discrimMapping.getNumberOfDatastoreMappings();
                    continue;
                }
                if (strategy != DiscriminatorStrategy.VALUE_MAP) continue;
                AbstractClassMetaData subclassCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(subclass, clr);
                discrimMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                jdbcPosition += discrimMapping.getNumberOfDatastoreMappings();
            }
        }
        return jdbcPosition;
    }

    public static int populateEmbeddedElementFieldsInStatement(ObjectProvider op, Object element, Object ps, int jdbcPosition, AbstractMemberMetaData ownerFieldMetaData, JavaTypeMapping elementMapping, AbstractClassMetaData emd, BaseContainerStore bcs) {
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = emd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementSM = bcs.getObjectProviderForEmbeddedPCObject(op, element, ownerFieldMetaData, (short)2);
        elementSM.provideFields(elementFieldNumbers, elementMapping.getStoreManager().getFieldManagerForStatementGeneration(elementSM, ps, mappingDefinition, true));
        return jdbcPosition;
    }

    public static int populateEmbeddedKeyFieldsInStatement(ObjectProvider op, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData kmd = mapStore.getKmd();
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)mapStore.getKeyMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = kmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementSM = mapStore.getObjectProviderForEmbeddedPCObject(op, key, joinTable.getOwnerMemberMetaData(), (short)3);
        elementSM.provideFields(elementFieldNumbers, embeddedMapping.getStoreManager().getFieldManagerForStatementGeneration(elementSM, (Object)ps, mappingDefinition, true));
        return jdbcPosition;
    }

    public static int populateEmbeddedValueFieldsInStatement(ObjectProvider op, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData vmd = mapStore.getVmd();
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)mapStore.getValueMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = vmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementSM = mapStore.getObjectProviderForEmbeddedPCObject(op, value, joinTable.getOwnerMemberMetaData(), (short)4);
        elementSM.provideFields(elementFieldNumbers, embeddedMapping.getStoreManager().getFieldManagerForStatementGeneration(elementSM, (Object)ps, mappingDefinition, true));
        return jdbcPosition;
    }

    public static void appendWhereClauseForElement(StringBuffer stmt, JavaTypeMapping elementMapping, Object element, boolean elementsSerialised, String containerAlias, boolean firstWhereClause) {
        if (!firstWhereClause) {
            stmt.append(" AND ");
        }
        if (elementMapping instanceof ReferenceMapping && elementMapping.getNumberOfDatastoreMappings() > 1) {
            for (int i = 0; i < elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                if (containerAlias != null) {
                    stmt.append(containerAlias).append(".");
                }
                stmt.append(elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (((ReferenceMapping)elementMapping).getJavaTypeMapping()[i].getType().equals(element.getClass().getName())) {
                    if (elementsSerialised) {
                        stmt.append(" LIKE ");
                    } else {
                        stmt.append("=");
                    }
                    stmt.append(((RDBMSMapping)elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                    continue;
                }
                stmt.append(" IS NULL");
            }
        } else {
            for (int i = 0; i < elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                if (containerAlias != null) {
                    stmt.append(containerAlias).append(".");
                }
                stmt.append(elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (elementsSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append("=");
                }
                stmt.append(((RDBMSMapping)elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
    }

    public static void appendWhereClauseForMapping(StringBuffer stmt, JavaTypeMapping mapping, String containerAlias, boolean firstWhereClause) {
        for (int i = 0; i < mapping.getNumberOfDatastoreMappings(); ++i) {
            if (!firstWhereClause || firstWhereClause && i > 0) {
                stmt.append(" AND ");
            }
            if (containerAlias != null) {
                stmt.append(containerAlias).append(".");
            }
            stmt.append(mapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append("=");
            stmt.append(((RDBMSMapping)mapping.getDatastoreMapping(i)).getInsertionInputParameter());
        }
    }
}

