/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.mapped.mapping.AbstractDatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public abstract class RDBMSMapping
extends AbstractDatastoreMapping {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected final RDBMSStoreManager storeMgr;
    protected Column column;

    protected RDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(mapping);
        this.storeMgr = (RDBMSStoreManager)storeMgr;
    }

    protected RDBMSAdapter getDatabaseAdapter() {
        return (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
    }

    public abstract SQLTypeInfo getTypeInfo();

    public boolean isNullable() {
        if (this.column != null) {
            return this.column.isNullable();
        }
        return true;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean insertValuesOnInsert() {
        return this.getInsertionInputParameter().indexOf(63) > -1;
    }

    public String getInsertionInputParameter() {
        return this.column.getWrapperFunction(1);
    }

    public String getUpdateInputParameter() {
        return this.column.getWrapperFunction(2);
    }

    public DatastoreField getDatastoreField() {
        return this.column;
    }

    protected void initTypeInfo() {
        SQLTypeInfo typeInfo = this.getTypeInfo();
        if (typeInfo == null) {
            throw new UnsupportedDataTypeException(LOCALISER_RDBMS.msg("055000", (Object)this.column));
        }
        if (this.column != null) {
            this.column.setTypeInfo(typeInfo);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RDBMSMapping)) {
            return false;
        }
        RDBMSMapping cm = (RDBMSMapping)((Object)obj);
        return ((Object)((Object)this)).getClass().equals(((Object)((Object)cm)).getClass()) && ((Object)((Object)this.storeMgr)).equals((Object)cm.storeMgr) && (this.column == null ? cm.column == null : this.column.equals(cm.column));
    }

    public int hashCode() {
        return ((Object)((Object)this.storeMgr)).hashCode() ^ (this.column == null ? 0 : this.column.hashCode());
    }

    protected String failureMessage(String method, int position, Exception e) {
        return LOCALISER.msg("041050", (Object)(((Object)((Object)this)).getClass().getName() + "." + method), (Object)position, (Object)this.column, (Object)e.getMessage());
    }

    protected String failureMessage(String method, Object value, Exception e) {
        return LOCALISER.msg("041050", (Object)(((Object)((Object)this)).getClass().getName() + "." + method), value, (Object)this.column, (Object)e.getMessage());
    }
}

