/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class ArrayExpression
extends SQLExpression {
    protected List<SQLExpression> elementExpressions;

    public ArrayExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public ArrayExpression(SQLStatement stmt, JavaTypeMapping mapping, SQLExpression[] exprs) {
        super(stmt, null, mapping);
        this.elementExpressions = new ArrayList<SQLExpression>();
        for (int i = 0; i < exprs.length; ++i) {
            this.elementExpressions.add(exprs[i]);
        }
    }

    public List<SQLExpression> getElementExpressions() {
        return this.elementExpressions;
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, "ARRAY", methodName, this, args);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        return super.ne(expr);
    }
}

