/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.CollectionTable;

public class IndexFunction
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression ignore, List args) {
        if (ignore == null) {
            if (args == null || args.size() != 2) {
                throw new NucleusException("INDEX can only be used with 2 arguments - the element expression, and the collection expression");
            }
            SQLExpression elemSqlExpr = (SQLExpression)args.get(0);
            SQLExpression collSqlExpr = (SQLExpression)args.get(1);
            AbstractMemberMetaData mmd = collSqlExpr.getJavaTypeMapping().getMemberMetaData();
            if (!mmd.hasCollection()) {
                throw new NucleusException("INDEX expression for field " + mmd.getFullFieldName() + " does not represent a collection!");
            }
            if (!mmd.getOrderMetaData().isIndexedList()) {
                throw new NucleusException("INDEX expression for field " + mmd.getFullFieldName() + " does not represent an indexed list!");
            }
            JavaTypeMapping orderMapping = null;
            SQLTable orderTable = null;
            DatastoreContainerObject joinTbl = this.stmt.getRDBMSManager().getDatastoreContainerObject(mmd);
            if (joinTbl != null) {
                CollectionTable collTable = (CollectionTable)joinTbl;
                orderTable = this.stmt.getTableForDatastoreContainer(collTable);
                orderMapping = collTable.getOrderMapping();
            } else {
                orderTable = elemSqlExpr.getSQLTable();
                orderMapping = ((ClassTable)elemSqlExpr.getSQLTable().getTable()).getExternalMapping(mmd, 4);
            }
            return new NumericExpression(this.stmt, orderTable, orderMapping);
        }
        throw new NucleusException(LOCALISER.msg("060002", (Object)"INDEX", (Object)ignore));
    }
}

