/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLiteTypeInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class SQLiteAdapter
extends DatabaseAdapter {
    protected static final int MAX_IDENTIFIER_LENGTH = 128;

    public SQLiteAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("FKInEndCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("AutoIncrementPkInCreateTableColumnDef");
        this.supportedOptions.remove("TxIsolationReadCommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.maxTableNameLength = 128;
        this.maxColumnNameLength = 128;
        this.maxConstraintNameLength = 128;
        this.maxIndexNameLength = 128;
    }

    public String getVendorID() {
        return "sqlite";
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLiteTypeInfo sqlType = new SQLiteTypeInfo("double", 8, 0, null, null, null, 1, true, 3, false, false, false, "double", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new SQLiteTypeInfo("float", 6, 0, null, null, null, 1, true, 3, false, false, false, "float", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new SQLiteTypeInfo("decimal", 3, 0, null, null, null, 1, true, 3, false, false, false, "decimal", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new SQLiteTypeInfo("numeric", 2, 0, null, null, null, 1, true, 3, false, false, false, "numeric", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", 16, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", -7, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
        sqlType = new SQLiteTypeInfo("tinyint", -6, 0, null, null, null, 1, true, 3, false, false, false, "tinyint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new SQLiteTypeInfo("smallint", 5, 0, null, null, null, 1, true, 3, false, false, false, "smallint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)5, sqlType, true);
        sqlType = new SQLiteTypeInfo("bigint", -5, 0, null, null, null, 1, true, 3, false, false, false, "bigint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new SQLiteTypeInfo("char", 1, 255, null, null, null, 1, true, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new SQLiteTypeInfo("varchar", 12, 255, null, null, null, 1, true, 3, false, false, false, "varchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)12, sqlType, true);
        sqlType = new SQLiteTypeInfo("longvarchar", -1, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "longvarchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType, true);
        sqlType = new SQLiteTypeInfo("clob", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "clob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new SQLiteTypeInfo("date", 91, 0, null, null, null, 1, true, 3, false, false, false, "date", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        sqlType = new SQLiteTypeInfo("time", 92, 0, null, null, null, 1, true, 3, false, false, false, "time", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
        sqlType = new SQLiteTypeInfo("timestamp", 93, 0, null, null, null, 1, true, 3, false, false, false, "timestamp", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)93, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -2, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -3, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -4, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        return null;
    }

    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return null;
    }

    public String getRangeByLimitEndOfStatementClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 9223372036854775807 OFFSET " + offset + " ";
        }
        return "";
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT last_insert_rowid()";
    }

    public String getAutoIncrementKeyword() {
        return "autoincrement";
    }
}

