/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.ConnectionFactoryImpl;
import org.datanucleus.store.rdbms.DeleteTablesSchemaTransaction;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.JDOConnectionImpl;
import org.datanucleus.store.rdbms.NucleusSequenceImpl;
import org.datanucleus.store.rdbms.RDBMSPersistenceHandler;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreHelper;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.ValidateTableSchemaTransaction;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapterFactory;
import org.datanucleus.store.rdbms.autostart.SchemaAutoStarter;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.scostore.RDBMSFKArrayStore;
import org.datanucleus.store.rdbms.scostore.RDBMSFKListStore;
import org.datanucleus.store.rdbms.scostore.RDBMSFKMapStore;
import org.datanucleus.store.rdbms.scostore.RDBMSFKSetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSJoinArrayStore;
import org.datanucleus.store.rdbms.scostore.RDBMSJoinListStore;
import org.datanucleus.store.rdbms.scostore.RDBMSJoinMapStore;
import org.datanucleus.store.rdbms.scostore.RDBMSJoinSetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSPersistableRelationStore;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.PersistableJoinTable;
import org.datanucleus.store.rdbms.table.ProbeTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.rdbms.valuegenerator.SequenceTable;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.PersistableRelationStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBMSStoreManager
extends MappedStoreManager
implements SchemaAwareStoreManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private SQLController sqlController = null;
    protected SQLExpressionFactory expressionFactory;
    private ClassAdder classAdder = null;
    private final Object classAdditionLock = new Object();
    private Writer ddlWriter = null;
    private boolean completeDDL = false;
    private Set<String> writtenDdlStatements = null;
    private MultiMap schemaCallbacks = new MultiMap();
    private transient Calendar dateTimezoneCalendar = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSStoreManager(ClassLoaderResolver clr, NucleusContext ctx, Map<String, Object> props) {
        super("rdbms", clr, ctx, props);
        this.persistenceHandler = new RDBMSPersistenceHandler((StoreManager)this);
        this.schemaHandler = new RDBMSSchemaHandler(this);
        this.expressionFactory = new SQLExpressionFactory(this);
        try {
            ManagedConnection mc = this.getConnection(-1);
            Connection conn = (Connection)mc.getConnection();
            if (conn == null) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("050007"));
            }
            try {
                String validCatalogName;
                String validSchemaName;
                this.dba = RDBMSAdapterFactory.getInstance().getDatastoreAdapter(clr, conn, this.getStringProperty("datanucleus.rdbms.datastoreAdapterClassName"), ctx.getPluginManager());
                this.dba.initialiseTypes(this.schemaHandler, mc);
                this.dba.removeUnsupportedMappings(this.schemaHandler, mc);
                if (this.hasPropertyNotNull("datanucleus.mapping.Catalog")) {
                    if (!((RDBMSAdapter)this.dba).supportsOption("CatalogInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050002", (Object)this.getStringProperty("datanucleus.mapping.Catalog")));
                    } else {
                        this.catalogName = this.getStringProperty("datanucleus.mapping.Catalog");
                    }
                }
                if (this.hasPropertyNotNull("datanucleus.mapping.Schema")) {
                    if (!((RDBMSAdapter)this.dba).supportsOption("SchemaInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050003", (Object)this.getStringProperty("datanucleus.mapping.Schema")));
                    } else {
                        this.schemaName = this.getStringProperty("datanucleus.mapping.Schema");
                    }
                }
                this.initialiseIdentifierFactory(ctx);
                if (this.schemaName != null && !(validSchemaName = this.identifierFactory.getIdentifierInAdapterCase(this.schemaName)).equals(this.schemaName)) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_RDBMS.msg("020192", (Object)"schema", (Object)this.schemaName, (Object)validSchemaName));
                    this.schemaName = validSchemaName;
                }
                if (this.catalogName != null && !(validCatalogName = this.identifierFactory.getIdentifierInAdapterCase(this.catalogName)).equals(this.catalogName)) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_RDBMS.msg("020192", (Object)"catalog", (Object)this.catalogName, (Object)validCatalogName));
                    this.catalogName = validCatalogName;
                }
                this.sqlController = new SQLController(((RDBMSAdapter)this.dba).supportsOption("StatementBatching"), this.getIntProperty("datanucleus.rdbms.statementBatchLimit"), this.getIntProperty("datanucleus.datastoreReadTimeout"), this.getBooleanProperty("datanucleus.rdbms.sqlParamValuesInBrackets"));
                HashMap dbaProps = new HashMap();
                Map omfProps = ctx.getPersistenceConfiguration().getPersistenceProperties();
                for (Map.Entry entry : omfProps.entrySet()) {
                    String prop = (String)entry.getKey();
                    if (!prop.startsWith("datanucleus.rdbms.adapter.")) continue;
                    dbaProps.put(prop, entry.getValue());
                }
                if (dbaProps.size() > 0) {
                    this.dba.setProperties(dbaProps);
                }
                this.initialiseSchema(conn, clr);
                this.logConfiguration();
            }
            finally {
                mc.close();
            }
        }
        catch (NucleusException ne) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("050004"), (Throwable)ne);
            throw ne.setFatal();
        }
        catch (Exception e1) {
            String msg = LOCALISER_RDBMS.msg("050004") + ' ' + LOCALISER_RDBMS.msg("050006") + ' ' + LOCALISER_RDBMS.msg("048000", (Object)e1);
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg, (Throwable)e1);
            throw new NucleusUserException(msg, (Throwable)e1).setFatal();
        }
    }

    public String getQueryCacheKey() {
        return this.getStoreManagerKey() + "-" + this.getDatastoreAdapter().getVendorID();
    }

    public MultiMap getSchemaCallbacks() {
        return this.schemaCallbacks;
    }

    public void addSchemaCallback(String className, AbstractMemberMetaData mmd) {
        Collection coll = (Collection)this.schemaCallbacks.get((Object)className);
        if (coll == null || !coll.contains(mmd)) {
            this.schemaCallbacks.put((Object)className, (Object)mmd);
        }
    }

    protected void logConfiguration() {
        super.logConfiguration();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
            NucleusLogger.DATASTORE.debug((Object)("Datastore Adapter : " + this.dba.getClass().getName()));
            NucleusLogger.DATASTORE.debug((Object)("Datastore : name=\"" + rdba.getDatastoreProductName() + "\"" + " version=\"" + rdba.getDatastoreProductVersion() + "\""));
            NucleusLogger.DATASTORE.debug((Object)("Datastore Driver : name=\"" + rdba.getDatastoreDriverName() + "\"" + " version=\"" + rdba.getDatastoreDriverVersion() + "\""));
            ConnectionFactoryImpl txCF = (ConnectionFactoryImpl)this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
            String poolingType = txCF.getPoolingType();
            NucleusLogger.DATASTORE.debug((Object)("Transactional     Connections : Pooling = " + (poolingType == null || poolingType.equals("default") ? "None" : poolingType)));
            ConnectionFactoryImpl nontxCF = (ConnectionFactoryImpl)this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName);
            poolingType = nontxCF.getPoolingType();
            NucleusLogger.DATASTORE.debug((Object)("Non-Transactional Connections : Pooling = " + (poolingType == null || poolingType.equals("default") ? "None" : poolingType)));
            if (this.identifierFactory != null) {
                NucleusLogger.DATASTORE.debug((Object)("Datastore Identifiers : factory=\"" + this.getStringProperty("datanucleus.identifierFactory") + "\"" + " case=" + this.identifierFactory.getIdentifierCase().toString() + (this.catalogName != null ? " catalog=" + this.catalogName : "") + (this.schemaName != null ? " schema=" + this.schemaName : "")));
                NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Cases : " + (rdba.supportsOption("LowerCaseIdentifiers") ? "lowercase " : "") + (rdba.supportsOption("LowerCaseQuotedIdentifiers") ? "\"lowercase\" " : "") + (rdba.supportsOption("MixedCaseIdentifiers") ? "MixedCase " : "") + (rdba.supportsOption("MixedCaseQuotedIdentifiers") ? "\"MixedCase\" " : "") + (rdba.supportsOption("UpperCaseIdentifiers") ? "UPPERCASE " : "") + (rdba.supportsOption("UpperCaseQuotedIdentifiers") ? "\"UPPERCASE\" " : "") + (rdba.supportsOption("MixedCaseSensitiveIdentifiers") ? "MixedCase-Sensitive " : "") + (rdba.supportsOption("MixedCaseQuotedSensitiveIdentifiers") ? "\"MixedCase-Sensitive\" " : "")));
                NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Lengths (max) : Table=" + rdba.getDatastoreIdentifierMaxLength(IdentifierType.TABLE) + " Column=" + rdba.getDatastoreIdentifierMaxLength(IdentifierType.COLUMN) + " Constraint=" + rdba.getDatastoreIdentifierMaxLength(IdentifierType.CANDIDATE_KEY) + " Index=" + rdba.getDatastoreIdentifierMaxLength(IdentifierType.INDEX) + " Delimiter=" + rdba.getIdentifierQuoteString()));
                NucleusLogger.DATASTORE.debug((Object)("Support for Identifiers in DDL : catalog=" + rdba.supportsOption("CatalogInTableDefinition") + " schema=" + rdba.supportsOption("SchemaInTableDefinition")));
            }
            NucleusLogger.DATASTORE.debug((Object)("Datastore : " + (this.getBooleanProperty("datanucleus.rdbms.checkExistTablesOrViews") ? "checkTableViewExistence" : "") + ", rdbmsConstraintCreateMode=" + this.getStringProperty("datanucleus.rdbms.constraintCreateMode") + ", initialiseColumnInfo=" + this.getStringProperty("datanucleus.rdbms.initializeColumnInfo")));
            int batchLimit = this.getIntProperty("datanucleus.rdbms.statementBatchLimit");
            boolean supportBatching = rdba.supportsOption("StatementBatching");
            if (supportBatching) {
                NucleusLogger.DATASTORE.debug((Object)("Support Statement Batching : yes (max-batch-size=" + (batchLimit == -1 ? "UNLIMITED" : "" + batchLimit) + ")"));
            } else {
                NucleusLogger.DATASTORE.debug((Object)"Support Statement Batching : no");
            }
            NucleusLogger.DATASTORE.debug((Object)("Queries : Results direction=" + this.getStringProperty("datanucleus.rdbms.query.fetchDirection") + ", type=" + this.getStringProperty("datanucleus.rdbms.query.resultSetType") + ", concurrency=" + this.getStringProperty("datanucleus.rdbms.query.resultSetConcurrency")));
            NucleusLogger.DATASTORE.debug((Object)("Java-Types : string-default-length=" + this.getIntProperty("datanucleus.rdbms.stringDefaultLength")));
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null && typesInfo.getNumberOfChildren() > 0) {
                StringBuffer typeStr = new StringBuffer();
                Iterator<String> jdbcTypesIter = typesInfo.getChildren().keySet().iterator();
                while (jdbcTypesIter.hasNext()) {
                    String jdbcTypeStr = jdbcTypesIter.next();
                    short jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = Short.valueOf(jdbcTypeStr);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    String typeName = JDBCUtils.getNameForJDBCType(jdbcTypeNumber);
                    if (typeName == null) {
                        typeName = "[id=" + jdbcTypeNumber + "]";
                    }
                    typeStr.append(typeName);
                    if (!jdbcTypesIter.hasNext()) continue;
                    typeStr.append(", ");
                }
                NucleusLogger.DATASTORE.debug((Object)("JDBC-Types : " + typeStr));
            }
            NucleusLogger.DATASTORE.debug((Object)"===========================================================");
        }
    }

    public void close() {
        super.close();
        this.classAdder = null;
    }

    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return new NucleusSequenceImpl(ec, this, seqmd);
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        final boolean enlisted = ec.getTransaction().isActive();
        ConnectionFactory cf = null;
        cf = enlisted ? this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName) : this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName);
        final ManagedConnection mc = cf.getConnection(enlisted ? ec : null, ec.getTransaction(), null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    try {
                        ((Connection)mc.getConnection()).close();
                    }
                    catch (SQLException sqle) {
                        throw new NucleusDataStoreException(sqle.getMessage());
                    }
                }
            }
        };
        NucleusConnectionImpl nc = new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
        return new JDOConnectionImpl((NucleusConnection)nc);
    }

    public SQLController getSQLController() {
        return this.sqlController;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        return this.expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSchema(Connection conn, ClassLoaderResolver clr) throws Exception {
        block17: {
            RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
            if (this.schemaName == null && this.catalogName == null) {
                try {
                    try {
                        this.catalogName = rdba.getCatalogName(conn);
                        this.schemaName = rdba.getSchemaName(conn);
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.readOnlyDatastore || this.fixedDatastore) break block17;
                        ProbeTable pt = new ProbeTable(this);
                        pt.initialize(clr);
                        pt.create(conn);
                        try {
                            String[] schema_details = pt.findSchemaDetails(conn);
                            if (schema_details != null) {
                                this.catalogName = schema_details[0];
                                this.schemaName = schema_details[1];
                            }
                        }
                        finally {
                            pt.drop(conn);
                        }
                    }
                }
                catch (SQLException e) {
                    String msg = LOCALISER_RDBMS.msg("050005", (Object)e.getMessage()) + ' ' + LOCALISER_RDBMS.msg("050006");
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)msg);
                }
            }
        }
        if (!this.readOnlyDatastore) {
            this.dba.initialiseDatastore((Object)conn);
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && this.autoStartMechanism != null && this.autoStartMechanism.equals("SchemaTable")) {
            this.autoStartMechanism = "None";
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050008", (Object)this.catalogName, (Object)this.schemaName, (Object)this.autoStartMechanism));
        }
        this.initialiseAutoStart(clr);
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            if (this.readOnlyDatastore) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050010", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            } else if (this.fixedDatastore) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050011", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            } else {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050009", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            }
        }
    }

    private void clearSchemaData() {
        this.deregisterAllStoreData();
        this.schemaHandler.clear();
        ((RDBMSPersistenceHandler)this.persistenceHandler).removeAllRequests();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Date getDatastoreDate() {
        Date serverDate;
        block14: {
            serverDate = null;
            String dateStmt = ((RDBMSAdapter)this.dba).getDatastoreDateStatement();
            ManagedConnection mconn = null;
            try {
                mconn = this.getConnection(0);
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = this.getSQLController().getStatementForQuery(mconn, dateStmt);
                    rs = this.getSQLController().executeStatementQuery(null, mconn, dateStmt, ps);
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp(1, this.getCalendarForDateTimezone());
                        serverDate = new Date(time.getTime());
                        break block14;
                    }
                    Date time = null;
                    return time;
                }
                catch (SQLException sqle) {
                    String msg = LOCALISER_RDBMS.msg("050052", (Object)sqle.getMessage());
                    NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                    throw new NucleusUserException(msg, (Throwable)sqle).setFatal();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        this.getSQLController().closeStatement(mconn, ps);
                    }
                }
            }
            catch (SQLException sqle) {
                String msg = LOCALISER_RDBMS.msg("050052", (Object)sqle.getMessage());
                NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                throw new NucleusException(msg, (Throwable)sqle).setFatal();
            }
            finally {
                mconn.close();
            }
        }
        return serverDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        Object object = this.classAdditionLock;
        synchronized (object) {
            if (this.classAdder != null) {
                this.classAdder.addClasses(classNames, clr);
                return;
            }
            if (classNames != null && classNames.length > 0) {
                new ClassAdder(classNames, null).execute(clr);
            }
        }
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        DeleteTablesSchemaTransaction deleteTablesTxn = new DeleteTablesSchemaTransaction(this, 2, this.storeDataMgr);
        boolean success = true;
        try {
            deleteTablesTxn.execute(clr);
        }
        catch (NucleusException ne) {
            success = false;
            throw ne;
        }
        finally {
            if (success) {
                this.clearSchemaData();
            }
        }
    }

    public Writer getDdlWriter() {
        return this.ddlWriter;
    }

    public boolean getCompleteDDL() {
        return this.completeDDL;
    }

    public boolean hasWrittenDdlStatement(String stmt) {
        return this.writtenDdlStatements != null && this.writtenDdlStatements.contains(stmt);
    }

    public void addWrittenDdlStatement(String stmt) {
        if (this.writtenDdlStatements != null) {
            this.writtenDdlStatements.add(stmt);
        }
    }

    public void validateTable(TableImpl table, ClassLoaderResolver clr) {
        ValidateTableSchemaTransaction validateTblTxn = new ValidateTableSchemaTransaction(this, 2, table);
        validateTblTxn.execute(clr);
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        AbstractClassMetaData cmd;
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        ApiAdapter api = this.getApiAdapter();
        ArrayList<AbstractClassMetaData> rootCmds = new ArrayList<AbstractClassMetaData>();
        if (id instanceof OID) {
            OID oid = (OID)id;
            cmd = this.getMetaDataManager().getMetaDataForClass(oid.getPcClass(), clr);
            rootCmds.add(cmd);
            if (cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050022", id, (Object)cmd.getFullClassName()));
            }
        } else if (api.isSingleFieldIdentity(id)) {
            String className = api.getTargetClassNameForSingleFieldIdentity(id);
            cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            rootCmds.add(cmd);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050022", id, (Object)cmd.getFullClassName()));
            }
        } else {
            Collection pkCmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
            if (pkCmds != null && pkCmds.size() > 0) {
                for (AbstractClassMetaData pkCmd : pkCmds) {
                    AbstractClassMetaData cmdToSwap = null;
                    boolean toAdd = true;
                    for (AbstractClassMetaData rootCmd : rootCmds) {
                        if (rootCmd.isDescendantOf(pkCmd)) {
                            cmdToSwap = rootCmd;
                            toAdd = false;
                            break;
                        }
                        if (!pkCmd.isDescendantOf(rootCmd)) continue;
                        toAdd = false;
                    }
                    if (cmdToSwap != null) {
                        rootCmds.remove(cmdToSwap);
                        rootCmds.add(pkCmd);
                        continue;
                    }
                    if (!toAdd) continue;
                    rootCmds.add(pkCmd);
                }
            }
            if (rootCmds.size() == 0) {
                return null;
            }
        }
        AbstractClassMetaData rootCmd = (AbstractClassMetaData)rootCmds.get(0);
        if (ec != null) {
            if (rootCmds.size() == 1) {
                DatastoreClass primaryTable;
                String[] managedClassesInTable;
                HashSet subclasses;
                if (!rootCmd.isImplementationOfPersistentDefinition() && ((subclasses = this.getSubClassesForClass(rootCmd.getFullClassName(), true, clr)) == null || subclasses.isEmpty()) && (managedClassesInTable = (primaryTable = this.getDatastoreClass(rootCmd.getFullClassName(), clr)).getManagedClasses()).length == 1 && managedClassesInTable[0].equals(rootCmd.getFullClassName())) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)("Sole candidate for id is " + rootCmd.getFullClassName() + " and has no subclasses, so returning without checking datastore"));
                    }
                    return rootCmd.getFullClassName();
                }
                if (rootCmd.hasDiscriminatorStrategy()) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)("Performing query using discriminator on " + rootCmd.getFullClassName() + " and its subclasses to find the class of " + id));
                    }
                    return RDBMSStoreHelper.getClassNameForIdUsingDiscriminator(this, ec, id, rootCmd);
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)("Performing query using UNION on " + rootCmd.getFullClassName() + " and its subclasses to find the class of " + id));
                }
                return RDBMSStoreHelper.getClassNameForIdUsingUnion(this, ec, id, rootCmds);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer();
                Iterator rootCmdIter = rootCmds.iterator();
                while (rootCmdIter.hasNext()) {
                    AbstractClassMetaData cmd2 = (AbstractClassMetaData)rootCmdIter.next();
                    str.append(cmd2.getFullClassName());
                    if (!rootCmdIter.hasNext()) continue;
                    str.append(",");
                }
                NucleusLogger.PERSISTENCE.debug((Object)("Performing query using UNION on " + str.toString() + " and their subclasses to find the class of " + id));
            }
            return RDBMSStoreHelper.getClassNameForIdUsingUnion(this, ec, id, rootCmds);
        }
        if (rootCmds.size() > 1) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)("Id \"" + id + "\" has been determined to be the id of class " + rootCmd.getFullClassName() + " : this is the first of " + rootCmds.size() + " possible" + ", but unable to determine further"));
            }
            return rootCmd.getFullClassName();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Id \"" + id + "\" has been determined to be the id of class " + rootCmd.getFullClassName() + " : unable to determine if actually of a subclass"));
        }
        return rootCmd.getFullClassName();
    }

    public FieldManager getFieldManagerForResultProcessing(ObjectProvider sm, Object resultSet, StatementClassMapping resultMappings) {
        return new ResultSetGetter(this, sm, resultSet, resultMappings);
    }

    public FieldManager getFieldManagerForResultProcessing(ExecutionContext ec, Object resultSet, StatementClassMapping resultMappings, AbstractClassMetaData cmd) {
        return new ResultSetGetter(this, ec, resultSet, resultMappings, cmd);
    }

    public FieldManager getFieldManagerForStatementGeneration(ObjectProvider sm, Object stmt, StatementClassMapping stmtMappings, boolean checkNonNullable) {
        return new ParameterSetter(sm, stmt, stmtMappings, true);
    }

    public Object getResultValueAtPosition(Object resultSet, JavaTypeMapping mapping, int position) {
        try {
            return ((ResultSet)resultSet).getObject(position);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                final RDBMSStoreManager thisStoreMgr = this;
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        if (RDBMSStoreManager.this.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("UsePM")) {
                            this.mconn = thisStoreMgr.getConnection(ec);
                        } else {
                            int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName((String)RDBMSStoreManager.this.getStringProperty("datanucleus.valuegeneration.transactionIsolation"));
                            this.mconn = thisStoreMgr.getConnection(isolationLevel);
                        }
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        try {
                            if (RDBMSStoreManager.this.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("UsePM")) {
                                this.mconn.release();
                            } else {
                                this.mconn.close();
                            }
                            this.mconn = null;
                        }
                        catch (NucleusException e) {
                            String msg = LOCALISER_RDBMS.msg("050025", (Object)e);
                            NucleusLogger.VALUEGENERATION.error((Object)msg);
                            throw new NucleusDataStoreException(msg, (Throwable)e);
                        }
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ExecutionContext ec, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        int allocSize;
        AbstractMemberMetaData mmd = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            extensions = mmd.getExtensions();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
            sequence = idmd.getSequence();
            extensions = idmd.getExtensions();
        }
        DatastoreClass tbl = this.getDatastoreClass(cmd.getBaseAbstractClassMetaData().getFullClassName(), ec.getClassLoaderResolver());
        if (tbl == null) {
            tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, ec.getClassLoaderResolver());
        }
        JavaTypeMapping m = null;
        if (mmd != null) {
            m = tbl.getMemberMapping(mmd);
            if (m == null) {
                tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, ec.getClassLoaderResolver());
                m = tbl.getMemberMapping(mmd);
            }
        } else {
            m = tbl.getIdMapping();
        }
        StringBuffer columnsName = new StringBuffer();
        for (int i = 0; i < m.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                columnsName.append(",");
            }
            columnsName.append(m.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        Properties properties = new Properties();
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (mmd != null) {
            properties.setProperty("field-name", mmd.getFullFieldName());
        }
        if (cmd.getCatalog() != null) {
            properties.setProperty("catalog-name", cmd.getCatalog());
        }
        if (cmd.getSchema() != null) {
            properties.setProperty("schema-name", cmd.getSchema());
        }
        properties.setProperty("table-name", tbl.getIdentifier().toString());
        properties.setProperty("column-name", columnsName.toString());
        if (sequence != null) {
            properties.setProperty("sequence-name", sequence);
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                properties.put(extensions[i].getKey(), extensions[i].getValue());
            }
        }
        if (strategy == IdentityStrategy.INCREMENT && tablegenmd != null) {
            properties.put("key-initial-value", "" + tablegenmd.getInitialValue());
            properties.put("key-cache-size", "" + tablegenmd.getAllocationSize());
            if (tablegenmd.getTableName() != null) {
                properties.put("sequence-table-name", tablegenmd.getTableName());
            }
            if (tablegenmd.getCatalogName() != null) {
                properties.put("sequence-catalog-name", tablegenmd.getCatalogName());
            }
            if (tablegenmd.getSchemaName() != null) {
                properties.put("sequence-schema-name", tablegenmd.getSchemaName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-name-column-name", tablegenmd.getPKColumnName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-nextval-column-name", tablegenmd.getValueColumnName());
            }
            if (tablegenmd.getPKColumnValue() != null) {
                properties.put("sequence-name", tablegenmd.getPKColumnValue());
            }
            properties.remove("table-name");
            properties.remove("column-name");
        } else if (strategy == IdentityStrategy.INCREMENT && tablegenmd == null) {
            if (!properties.containsKey("key-cache-size")) {
                allocSize = this.getIntProperty("datanucleus.valuegeneration.increment.allocationSize");
                properties.put("key-cache-size", "" + allocSize);
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && seqmd != null) {
            if (StringUtils.isWhitespace((String)sequence) && seqmd != null && seqmd.getName() != null) {
                properties.put("sequence-name", seqmd.getName());
            }
            if (seqmd.getDatastoreSequence() != null) {
                if (seqmd.getInitialValue() >= 0) {
                    properties.put("key-initial-value", "" + seqmd.getInitialValue());
                }
                if (seqmd.getAllocationSize() > 0) {
                    properties.put("key-cache-size", "" + seqmd.getAllocationSize());
                } else {
                    allocSize = this.getIntProperty("datanucleus.valuegeneration.sequence.allocationSize");
                    properties.put("key-cache-size", "" + allocSize);
                }
                properties.put("sequence-name", "" + seqmd.getDatastoreSequence());
                ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
                if (seqExtensions != null) {
                    for (int i = 0; i < seqExtensions.length; ++i) {
                        properties.put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
                    }
                }
            }
        }
        return properties;
    }

    private DatastoreClass getTableForStrategy(AbstractClassMetaData cmd, int fieldNumber, ClassLoaderResolver clr) {
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), clr);
        if (t == null && cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            throw new NucleusUserException(LOCALISER.msg("032013", (Object)cmd.getFullClassName()));
        }
        if (fieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            t = t.getBaseDatastoreClassWithMember(mmd);
        } else if (t != null) {
            boolean has_superclass = true;
            while (has_superclass) {
                DatastoreClass supert = t.getSuperDatastoreClass();
                if (supert != null) {
                    t = supert;
                    continue;
                }
                has_superclass = false;
            }
        }
        return t;
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        if (this.getBooleanProperty("datanucleus.rdbms.useLegacyNativeValueStrategy")) {
            String sequence = null;
            sequence = absFieldNumber >= 0 ? cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber).getSequence() : cmd.getIdentityMetaData().getSequence();
            if (this.dba.supportsOption("Sequences") && sequence != null) {
                return "sequence";
            }
            return "table-sequence";
        }
        return super.getStrategyForNative(cmd, absFieldNumber);
    }

    public SQLTypeInfo getSQLTypeInfoForJDBCType(int jdbcType) throws UnsupportedDataTypeException {
        return this.getSQLTypeInfoForJDBCType(jdbcType, "DEFAULT");
    }

    public SQLTypeInfo getSQLTypeInfoForJDBCType(int jdbcType, String sqlType) throws UnsupportedDataTypeException {
        RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
        JDBCTypeInfo jdbcTypeInfo = (JDBCTypeInfo)typesInfo.getChild("" + jdbcType);
        if (jdbcTypeInfo.getNumberOfChildren() == 0) {
            throw new UnsupportedDataTypeException(LOCALISER.msg("051005", (Object)JDBCUtils.getNameForJDBCType(jdbcType)));
        }
        return (SQLTypeInfo)jdbcTypeInfo.getChild(sqlType != null ? sqlType : "DEFAULT");
    }

    public RDBMSColumnInfo getColumnInfoForColumnName(Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        RDBMSColumnInfo colInfo = (RDBMSColumnInfo)this.schemaHandler.getSchemaData((Object)conn, "column", new Object[]{table, column.getIdentifierName()});
        return colInfo;
    }

    public List getColumnInfoForTable(Table table, Connection conn) throws SQLException {
        RDBMSTableInfo tableInfo = (RDBMSTableInfo)this.schemaHandler.getSchemaData((Object)conn, "columns", new Object[]{table});
        if (tableInfo == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList cols = new ArrayList(tableInfo.getNumberOfChildren());
        cols.addAll(tableInfo.getChildren());
        return cols;
    }

    public void invalidateColumnInfoForTable(Table table) {
        RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData(null, "tables", null);
        if (schemaInfo != null && schemaInfo.getNumberOfChildren() > 0) {
            schemaInfo.getChildren().remove(table.getIdentifier().getFullyQualifiedName(true));
        }
    }

    public Collection getManagedTables(String catalog, String schema) {
        if (this.storeDataMgr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DatastoreContainerObject> tables = new HashSet<DatastoreContainerObject>();
        for (RDBMSStoreData sd : this.storeDataMgr.getManagedStoreData()) {
            if (sd.getDatastoreContainerObject() == null) continue;
            DatastoreIdentifier identifier = sd.getDatastoreContainerObject().getIdentifier();
            boolean catalogMatches = true;
            boolean schemaMatches = true;
            if (catalog != null && identifier.getCatalogName() != null && !catalog.equals(identifier.getCatalogName())) {
                catalogMatches = false;
            }
            if (schema != null && identifier.getSchemaName() != null && !schema.equals(identifier.getSchemaName())) {
                schemaMatches = false;
            }
            if (!catalogMatches || !schemaMatches) continue;
            tables.add(sd.getDatastoreContainerObject());
        }
        return tables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveIdentifierMacro(MacroString.IdentifierMacro im, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        DatastoreClass ct = this.getDatastoreClass(im.className, clr);
        if (im.fieldName == null) {
            im.value = ct.getIdentifier().toString();
            return;
        }
        if (im.fieldName.equals("this")) {
            if (!(ct instanceof ClassTable)) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050034", (Object)im.className));
            }
            if (im.subfieldName != null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050035", (Object)im.className, (Object)im.fieldName, (Object)im.subfieldName));
            }
            m = ct.getIdMapping();
        } else {
            AbstractMemberMetaData mmd = this.getMetaDataManager().getMetaDataForMember(im.className, im.fieldName, clr);
            m = ct.getMemberMapping(mmd);
            DatastoreContainerObject t = this.getDatastoreContainerObject(mmd);
            if (im.subfieldName == null) {
                if (t != null) {
                    im.value = t.getIdentifier().toString();
                    return;
                }
            } else if (t instanceof CollectionTable) {
                CollectionTable collTable = (CollectionTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = collTable.getOwnerMapping();
                } else if (im.subfieldName.equals("element")) {
                    m = collTable.getElementMapping();
                } else {
                    if (!im.subfieldName.equals("index")) throw new NucleusUserException(LOCALISER_RDBMS.msg("050036", (Object)im.subfieldName, (Object)im));
                    m = collTable.getOrderMapping();
                }
            } else {
                if (!(t instanceof MapTable)) throw new NucleusUserException(LOCALISER_RDBMS.msg("050035", (Object)im.className, (Object)im.fieldName, (Object)im.subfieldName));
                MapTable mt = (MapTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = mt.getOwnerMapping();
                } else if (im.subfieldName.equals("key")) {
                    m = mt.getKeyMapping();
                } else {
                    if (!im.subfieldName.equals("value")) throw new NucleusUserException(LOCALISER_RDBMS.msg("050037", (Object)im.subfieldName, (Object)im));
                    m = mt.getValueMapping();
                }
            }
        }
        im.value = ((Column)m.getDatastoreMapping(0).getDatastoreField()).getIdentifier().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInformation(String category, PrintStream ps) throws Exception {
        RDBMSAdapter dba = (RDBMSAdapter)this.getDatastoreAdapter();
        super.printInformation(category, ps);
        if (category.equalsIgnoreCase("DATASTORE")) {
            ps.println(dba.toString());
            ps.println();
            ps.println("Database TypeInfo");
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null) {
                for (String jdbcTypeStr : typesInfo.getChildren().keySet()) {
                    short jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = Short.valueOf(jdbcTypeStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JDBCTypeInfo jDBCTypeInfo = (JDBCTypeInfo)typesInfo.getChild(jdbcTypeStr);
                    Set sqlTypeNames = jDBCTypeInfo.getChildren().keySet();
                    String typeStr = "JDBC Type=" + JDBCUtils.getNameForJDBCType(jdbcTypeNumber) + " sqlTypes=" + StringUtils.collectionToString(sqlTypeNames);
                    ps.println(typeStr);
                    SQLTypeInfo sqlType = (SQLTypeInfo)jDBCTypeInfo.getChild("DEFAULT");
                    ps.println(sqlType);
                }
            }
            ps.println("");
            ps.println("Database Keywords");
            Iterator reservedWordsIter = dba.iteratorReservedWords();
            while (reservedWordsIter.hasNext()) {
                Object words = reservedWordsIter.next();
                ps.println(words);
            }
            ps.println("");
        } else if (category.equalsIgnoreCase("SCHEMA")) {
            ps.println(dba.toString());
            ps.println();
            ps.println("TABLES");
            ManagedConnection mc = this.getConnection(-1);
            try {
                Connection conn = (Connection)mc.getConnection();
                RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData((Object)conn, "tables", new Object[]{this.catalogName, this.schemaName});
                if (schemaInfo != null) {
                    for (RDBMSTableInfo rDBMSTableInfo : schemaInfo.getChildren().values()) {
                        ps.println(rDBMSTableInfo);
                        for (RDBMSColumnInfo colInfo : rDBMSTableInfo.getChildren()) {
                            ps.println(colInfo);
                        }
                    }
                }
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
            ps.println("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        AbstractMemberMetaData[] relatedMmds;
        if (mmd.getJoinMetaData() == null && ((relatedMmds = mmd.getRelatedMemberMetaData(clr)) == null || relatedMmds[0].getJoinMetaData() == null)) {
            Class element_class;
            if (mmd.hasCollection()) {
                element_class = clr.classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasMap()) {
                MapMetaData mapmd = (MapMetaData)mmd.getContainer();
                if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() != null) {
                    element_class = clr.classForName(mapmd.getKeyType());
                } else {
                    if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) throw new NucleusUserException(LOCALISER_RDBMS.msg("050050", (Object)mmd.getFullFieldName()));
                    element_class = clr.classForName(mapmd.getValueType());
                }
            } else {
                if (!mmd.hasArray()) return null;
                element_class = clr.classForName(mmd.getTypeName()).getComponentType();
            }
            if (this.getMetaDataManager().getMetaDataForClass(element_class, clr) != null) {
                return null;
            }
            if (!ClassUtils.isReferenceType(element_class)) throw new NucleusUserException(LOCALISER_RDBMS.msg("050049", (Object)mmd.getFullFieldName(), (Object)mmd.toString()));
            return null;
        }
        DatastoreContainerObject joinTable = this.getDatastoreContainerObject(mmd);
        if (joinTable != null) {
            return joinTable;
        }
        if (this.classAdder == null) {
            throw new IllegalStateException(LOCALISER_RDBMS.msg("050016"));
        }
        if (mmd.getType().isArray()) {
            return this.classAdder.addJoinTableForContainer(mmd, clr, 3);
        }
        if (Map.class.isAssignableFrom(mmd.getType())) {
            return this.classAdder.addJoinTableForContainer(mmd, clr, 2);
        }
        if (!Collection.class.isAssignableFrom(mmd.getType())) return this.classAdder.addJoinTableForContainer(mmd, clr, 4);
        return this.classAdder.addJoinTableForContainer(mmd, clr, 1);
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ORM");
        set.add("NonDurableIdentity");
        set.add("DatastoreIdentity");
        set.add("ApplicationIdentity");
        if (this.dba.supportsOption("TxIsolationReadCommitted")) {
            set.add("TransactionIsolationLevel.read-committed");
        }
        if (this.dba.supportsOption("TxIsolationReadUncommitted")) {
            set.add("TransactionIsolationLevel.read-uncommitted");
        }
        if (this.dba.supportsOption("TxIsolationReadRepeatableRead")) {
            set.add("TransactionIsolationLevel.repeatable-read");
        }
        if (this.dba.supportsOption("TxIsolationSerializable")) {
            set.add("TransactionIsolationLevel.serializable");
        }
        set.add("Query.Cancel");
        set.add("Datastore.Timeout");
        return set;
    }

    public boolean insertValuesOnInsert(DatastoreMapping datastoreMapping) {
        return ((RDBMSMapping)datastoreMapping).insertValuesOnInsert();
    }

    public boolean allowsBatching() {
        return this.dba.supportsOption("StatementBatching") && this.getIntProperty("datanucleus.rdbms.statementBatchLimit") != 0;
    }

    public ResultObjectFactory newResultObjectFactory(AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, FetchPlan fetchPlan, Class persistentClass) {
        return new PersistentClassROF(this, acmd, mappingDefinition, ignoreCache, fetchPlan, persistentClass);
    }

    protected ArrayStore newFKArrayStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        return new RDBMSFKArrayStore(mmd, this, clr);
    }

    protected ListStore newFKListStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        return new RDBMSFKListStore(mmd, this, clr);
    }

    protected SetStore newFKSetStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        return new RDBMSFKSetStore(mmd, this, clr);
    }

    protected MapStore newFKMapStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        return new RDBMSFKMapStore(mmd, this, clr);
    }

    protected ArrayStore newJoinArrayStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        return new RDBMSJoinArrayStore(mmd, (ArrayTable)table, clr);
    }

    protected MapStore newJoinMapStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        return new RDBMSJoinMapStore((MapTable)table, clr);
    }

    protected ListStore newJoinListStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        return new RDBMSJoinListStore(mmd, (CollectionTable)table, clr);
    }

    protected SetStore newJoinSetStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        return new RDBMSJoinSetStore(mmd, (CollectionTable)table, clr);
    }

    protected PersistableRelationStore newPersistableRelationStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        return new RDBMSPersistableRelationStore(mmd, (PersistableJoinTable)table, clr);
    }

    public boolean usesBackedSCOWrappers() {
        return true;
    }

    public Calendar getCalendarForDateTimezone() {
        if (this.dateTimezoneCalendar == null) {
            String serverTimeZoneID = this.getStringProperty("datanucleus.ServerTimeZoneID");
            TimeZone tz = serverTimeZoneID != null ? TimeZone.getTimeZone(serverTimeZoneID) : TimeZone.getDefault();
            this.dateTimezoneCalendar = new GregorianCalendar(tz);
        }
        return (Calendar)this.dateTimezoneCalendar.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(Set<String> inputClassNames, Properties props) {
        boolean autoStart;
        Set<String> classNames = RDBMSStoreManager.cleanInputClassNames(this.nucleusContext, inputClassNames);
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        String completeDdlProp = props != null ? props.getProperty("completeDdl") : null;
        boolean completeDdl = completeDdlProp != null && completeDdlProp.equalsIgnoreCase("true");
        String autoStartProp = props != null ? props.getProperty("autoStartTable") : null;
        boolean bl = autoStart = autoStartProp != null && autoStartProp.equalsIgnoreCase("true");
        if (classNames.size() > 0) {
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            OutputStreamWriter ddlFileWriter = null;
            try {
                if (ddlFilename != null) {
                    File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                    if (ddlFile.exists()) {
                        ddlFile.delete();
                    }
                    if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                        ddlFile.getParentFile().mkdirs();
                    }
                    ddlFile.createNewFile();
                    ddlFileWriter = new FileWriter(ddlFile);
                    SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    if (completeDdl) {
                        ddlFileWriter.write("-- Complete schema required for the following classes:-\n");
                    } else {
                        ddlFileWriter.write("-- Schema diff for " + this.getConnectionURL() + " and the following classes:-\n");
                    }
                    Iterator<String> classNameIter = classNames.iterator();
                    while (classNameIter.hasNext()) {
                        ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                    }
                    ddlFileWriter.write("--\n");
                }
                try {
                    if (ddlFileWriter != null) {
                        this.ddlWriter = ddlFileWriter;
                        this.completeDDL = completeDdl;
                        this.writtenDdlStatements = new HashSet<String>();
                    }
                    new ClassAdder(classNames.toArray(new String[classNames.size()]), ddlFileWriter).execute(clr);
                    if (autoStart) {
                        if (ddlFileWriter != null) {
                            try {
                                ddlFileWriter.write("\n");
                                ddlFileWriter.write("------------------------------------------------------------------\n");
                                ddlFileWriter.write("-- Table for SchemaTable auto-starter\n");
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        new SchemaAutoStarter((StoreManager)this, clr);
                    }
                    if (ddlFileWriter != null) {
                        this.ddlWriter = null;
                        this.completeDDL = false;
                        this.writtenDdlStatements.clear();
                        this.writtenDdlStatements = null;
                    }
                    if (ddlFileWriter != null) {
                        ddlFileWriter.write("\n");
                        ddlFileWriter.write("------------------------------------------------------------------\n");
                        ddlFileWriter.write("-- Sequences and SequenceTables\n");
                    }
                    this.createSchemaSequences(classNames, clr, (FileWriter)ddlFileWriter);
                }
                finally {
                    if (ddlFileWriter != null) {
                        ddlFileWriter.close();
                    }
                }
            }
            catch (IOException ioe) {}
        } else {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
    }

    protected void createSchemaSequences(Set<String> classNames, ClassLoaderResolver clr, FileWriter ddlWriter) {
        if (classNames != null && classNames.size() > 0) {
            HashSet<String> seqTablesGenerated = new HashSet<String>();
            HashSet<String> sequencesGenerated = new HashSet<String>();
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.getIdentityMetaData() != null && cmd.getIdentityMetaData().getValueStrategy() != null) {
                    if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)cmd.getIdentityMetaData(), clr, seqTablesGenerated);
                    } else if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.SEQUENCE) {
                        String seqName = cmd.getIdentityMetaData().getSequence();
                        if (StringUtils.isWhitespace((String)seqName)) {
                            seqName = cmd.getIdentityMetaData().getValueGeneratorName();
                        }
                        if (!StringUtils.isWhitespace((String)seqName)) {
                            this.addSequenceForMetaData((MetaData)cmd.getIdentityMetaData(), seqName, clr, sequencesGenerated, ddlWriter);
                        }
                    }
                }
                AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
                for (int j = 0; j < mmds.length; ++j) {
                    IdentityStrategy str = mmds[j].getValueStrategy();
                    if (str == IdentityStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)mmds[j], clr, seqTablesGenerated);
                        continue;
                    }
                    if (str != IdentityStrategy.SEQUENCE) continue;
                    String seqName = mmds[j].getSequence();
                    if (StringUtils.isWhitespace((String)seqName)) {
                        seqName = mmds[j].getValueGeneratorName();
                    }
                    if (StringUtils.isWhitespace((String)seqName)) continue;
                    this.addSequenceForMetaData((MetaData)mmds[j], seqName, clr, sequencesGenerated, ddlWriter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceTableForMetaData(MetaData md, ClassLoaderResolver clr, Set<String> seqTablesGenerated) {
        String catName = null;
        String schName = null;
        String tableName = "SEQUENCE_TABLE";
        String seqColName = "SEQUENCE_NAME";
        String nextValColName = "NEXT_VAL";
        if (md.hasExtension("sequence-catalog-name")) {
            catName = md.getValueForExtension("sequence-catalog-name");
        }
        if (md.hasExtension("sequence-schema-name")) {
            schName = md.getValueForExtension("sequence-schema-name");
        }
        if (md.hasExtension("sequence-table-name")) {
            tableName = md.getValueForExtension("sequence-table-name");
        }
        if (md.hasExtension("sequence-name-column-name")) {
            seqColName = md.getValueForExtension("sequence-name-column-name");
        }
        if (md.hasExtension("sequence-nextval-column-name")) {
            nextValColName = md.getValueForExtension("sequence-nextval-column-name");
        }
        if (!seqTablesGenerated.contains(tableName)) {
            ManagedConnection mconn = this.getConnection(0);
            Connection conn = (Connection)mconn.getConnection();
            try {
                DatastoreIdentifier tableIdentifier = this.identifierFactory.newDatastoreContainerIdentifier(tableName);
                if (catName != null) {
                    tableIdentifier.setCatalogName(catName);
                }
                if (schName != null) {
                    tableIdentifier.setSchemaName(schName);
                }
                SequenceTable seqTable = new SequenceTable(tableIdentifier, this, seqColName, nextValColName);
                seqTable.initialize(clr);
                seqTable.exists(conn, true);
            }
            catch (Exception e) {
            }
            finally {
                mconn.close();
            }
            seqTablesGenerated.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceForMetaData(MetaData md, String seq, ClassLoaderResolver clr, Set<String> sequencesGenerated, FileWriter ddlWriter) {
        String seqName = seq;
        Integer min = null;
        Integer max = null;
        Integer start = null;
        Integer increment = null;
        Integer cacheSize = null;
        SequenceMetaData seqmd = this.getMetaDataManager().getMetaDataForSequence(clr, seq);
        if (seqmd != null) {
            seqName = seqmd.getDatastoreSequence();
            if (seqmd.getAllocationSize() > 0) {
                increment = seqmd.getAllocationSize();
            }
            if (seqmd.getInitialValue() >= 0) {
                start = seqmd.getInitialValue();
            }
            md = seqmd;
        }
        if (md.hasExtension("key-min-value")) {
            min = Integer.valueOf(md.getValueForExtension("key-min-value"));
        }
        if (md.hasExtension("key-max-value")) {
            max = Integer.valueOf(md.getValueForExtension("key-max-value"));
        }
        if (md.hasExtension("key-cache-size")) {
            increment = Integer.valueOf(md.getValueForExtension("key-cache-size"));
        }
        if (md.hasExtension("key-initial-value")) {
            start = Integer.valueOf(md.getValueForExtension("key-initial-value"));
        }
        if (md.hasExtension("key-database-cache-size")) {
            cacheSize = Integer.valueOf(md.getValueForExtension("key-database-cache-size"));
        }
        if (!sequencesGenerated.contains(seqName)) {
            String stmt = ((RDBMSAdapter)this.getDatastoreAdapter()).getSequenceCreateStmt(seqName, min, max, start, increment, cacheSize);
            if (ddlWriter != null) {
                try {
                    ddlWriter.write(stmt + ";\n");
                }
                catch (IOException ioe) {}
            } else {
                PreparedStatement ps = null;
                ManagedConnection mconn = this.getConnection(0);
                try {
                    ps = this.sqlController.getStatementForUpdate(mconn, stmt, false);
                    this.sqlController.executeStatementUpdate(null, mconn, stmt, ps, true);
                }
                catch (SQLException e) {
                }
                finally {
                    try {
                        if (ps != null) {
                            this.sqlController.closeStatement(mconn, ps);
                        }
                    }
                    catch (SQLException e) {}
                    mconn.close();
                }
            }
            sequencesGenerated.add(seqName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Set<String> inputClassNames, Properties props) {
        Set<String> classNames = RDBMSStoreManager.cleanInputClassNames(this.nucleusContext, inputClassNames);
        if (classNames.size() > 0) {
            String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
            String completeDdlProp = props != null ? props.getProperty("completeDdl") : null;
            boolean completeDdl = completeDdlProp != null && completeDdlProp.equalsIgnoreCase("true");
            String autoStartProp = props != null ? props.getProperty("autoStartTable") : null;
            boolean autoStart = autoStartProp != null && autoStartProp.equalsIgnoreCase("true");
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            FileWriter ddlFileWriter = null;
            try {
                if (ddlFilename != null) {
                    File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                    if (ddlFile.exists()) {
                        ddlFile.delete();
                    }
                    if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                        ddlFile.getParentFile().mkdirs();
                    }
                    ddlFile.createNewFile();
                    ddlFileWriter = new FileWriter(ddlFile);
                    SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    ddlFileWriter.write("-- Delete schema required for the following classes:-\n");
                    Iterator<String> classNameIter = classNames.iterator();
                    while (classNameIter.hasNext()) {
                        ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                    }
                    ddlFileWriter.write("--\n");
                }
                try {
                    if (ddlFileWriter != null) {
                        this.ddlWriter = ddlFileWriter;
                        this.completeDDL = completeDdl;
                        this.writtenDdlStatements = new HashSet<String>();
                    }
                    String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                    this.addClasses(classNameArray, clr);
                    DeleteTablesSchemaTransaction deleteTablesTxn = new DeleteTablesSchemaTransaction(this, 2, this.storeDataMgr);
                    deleteTablesTxn.setWriter(this.ddlWriter);
                    boolean success = true;
                    try {
                        deleteTablesTxn.execute(clr);
                    }
                    catch (NucleusException ne) {
                        success = false;
                        throw ne;
                    }
                    finally {
                        if (success) {
                            this.clearSchemaData();
                        }
                    }
                    if (autoStart) {
                        // empty if block
                    }
                }
                finally {
                    if (ddlFileWriter != null) {
                        this.ddlWriter = null;
                        this.completeDDL = false;
                        this.writtenDdlStatements.clear();
                        this.writtenDdlStatements = null;
                        ddlFileWriter.close();
                    }
                }
            }
            catch (IOException ioe) {}
        } else {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
    }

    public void validateSchema(Set<String> inputClassNames, Properties props) {
        Set<String> classNames = RDBMSStoreManager.cleanInputClassNames(this.nucleusContext, inputClassNames);
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        this.addClasses(classNameArray, clr);
    }

    protected static Set<String> cleanInputClassNames(NucleusContext ctx, Set<String> inputClassNames) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (inputClassNames == null || inputClassNames.size() == 0) {
            Collection classesWithMetadata = ctx.getMetaDataManager().getClassesWithMetaData();
            classNames.addAll(classesWithMetadata);
        } else {
            classNames.addAll(inputClassNames);
        }
        return classNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassAdder
    extends AbstractSchemaTransaction {
        public static final int JOIN_TABLE_COLLECTION = 1;
        public static final int JOIN_TABLE_MAP = 2;
        public static final int JOIN_TABLE_ARRAY = 3;
        public static final int JOIN_TABLE_PERSISTABLE = 4;
        private Writer ddlWriter;
        protected final boolean checkExistTablesOrViews;
        private HashSet<RDBMSStoreData> schemaDataAdded;
        private final String[] classNames;
        private int addClassTablesRecursionCounter;

        private ClassAdder(String[] classNames, Writer writer) {
            super(RDBMSStoreManager.this, ((RDBMSAdapter)RDBMSStoreManager.this.dba).getTransactionIsolationForSchemaCreation());
            this.ddlWriter = null;
            this.schemaDataAdded = new HashSet();
            this.addClassTablesRecursionCounter = 0;
            this.ddlWriter = writer;
            this.classNames = RDBMSStoreManager.this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
            this.checkExistTablesOrViews = RDBMSStoreManager.this.getBooleanProperty("datanucleus.rdbms.checkExistTablesOrViews");
        }

        @Override
        public String toString() {
            return LOCALISER_RDBMS.msg("050038", (Object)RDBMSStoreManager.this.catalogName, (Object)RDBMSStoreManager.this.schemaName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run(ClassLoaderResolver clr) throws SQLException {
            if (this.classNames.length == 0) {
                return;
            }
            Object object = RDBMSStoreManager.this.classAdditionLock;
            synchronized (object) {
                RDBMSStoreManager.this.classAdder = this;
                try {
                    this.addClassTablesAndValidate(this.classNames, clr);
                }
                finally {
                    RDBMSStoreManager.this.classAdder = null;
                }
            }
        }

        private void addClasses(String[] classNames, ClassLoaderResolver clr) {
            classNames = RDBMSStoreManager.this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
            if (classNames.length == 0) {
                return;
            }
            try {
                if (this.getCurrentConnection() == null) {
                    throw new IllegalStateException(LOCALISER_RDBMS.msg("050039"));
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException("SQL exception: " + this, (Throwable)e);
            }
            this.addClassTables(classNames, clr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClassTables(String[] classNames, ClassLoaderResolver clr) {
            ++this.addClassTablesRecursionCounter;
            try {
                Iterator iter = RDBMSStoreManager.this.getMetaDataManager().getReferencedClasses(classNames, clr).iterator();
                try {
                    if (RDBMSStoreManager.this.starter != null && RDBMSStoreManager.this.starterInitialised && !RDBMSStoreManager.this.starter.isOpen()) {
                        RDBMSStoreManager.this.starter.open();
                    }
                    while (iter.hasNext()) {
                        ClassMetaData cmd = (ClassMetaData)iter.next();
                        this.addClassTable(cmd, clr);
                    }
                    for (RDBMSStoreData data : new HashSet<RDBMSStoreData>(this.schemaDataAdded)) {
                        AbstractClassMetaData cmd;
                        InheritanceMetaData imd;
                        if (data.getDatastoreContainerObject() != null || !data.isFCO() || (imd = (cmd = (AbstractClassMetaData)data.getMetaData()).getInheritanceMetaData()).getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
                        AbstractClassMetaData[] managingCmds = RDBMSStoreManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreClass superTable = null;
                        if (managingCmds == null || managingCmds.length != 1) continue;
                        RDBMSStoreData superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        if (superData == null) {
                            this.addClassTables(new String[]{managingCmds[0].getFullClassName()}, clr);
                            superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        }
                        if (superData == null) {
                            String msg = LOCALISER_RDBMS.msg("050013", (Object)cmd.getFullClassName());
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                        superTable = (DatastoreClass)superData.getDatastoreContainerObject();
                        data.setDatastoreContainerObject(superTable);
                    }
                }
                finally {
                    if (RDBMSStoreManager.this.starter != null && RDBMSStoreManager.this.starterInitialised && RDBMSStoreManager.this.starter.isOpen() && this.addClassTablesRecursionCounter <= 1) {
                        RDBMSStoreManager.this.starter.close();
                    }
                }
            }
            finally {
                --this.addClassTablesRecursionCounter;
            }
        }

        private void addClassTable(ClassMetaData cmd, ClassLoaderResolver clr) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE && cmd.hasExtension("requires-table") && cmd.getValueForExtension("requires-table") != null && cmd.getValueForExtension("requires-table").equalsIgnoreCase("false")) {
                return;
            }
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                    String baseClassWithMetaData = cmd.getBaseAbstractClassMetaData().getFullClassName();
                    Collection pkCmds = RDBMSStoreManager.this.getMetaDataManager().getClassMetaDataWithApplicationId(cmd.getObjectidClass());
                    if (pkCmds != null && pkCmds.size() > 0) {
                        boolean in_same_tree = false;
                        String sample_class_in_other_tree = null;
                        for (AbstractClassMetaData pkCmd : pkCmds) {
                            String otherClassBaseClass = pkCmd.getBaseAbstractClassMetaData().getFullClassName();
                            if (otherClassBaseClass.equals(baseClassWithMetaData)) {
                                in_same_tree = true;
                                break;
                            }
                            sample_class_in_other_tree = pkCmd.getFullClassName();
                        }
                        if (!in_same_tree) {
                            String error_msg = LOCALISER_RDBMS.msg("050021", (Object)cmd.getFullClassName(), (Object)cmd.getObjectidClass(), sample_class_in_other_tree);
                            NucleusLogger.DATASTORE.error((Object)error_msg);
                            throw new NucleusUserException(error_msg);
                        }
                    }
                }
                if (cmd.isEmbeddedOnly()) {
                    NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("032012", (Object)cmd.getFullClassName()));
                } else {
                    InheritanceMetaData imd = cmd.getInheritanceMetaData();
                    RDBMSStoreData sdNew = null;
                    if (imd.getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSStoreManager.this.registerStoreData((StoreData)sdNew);
                    } else if (imd.getStrategy() == InheritanceStrategy.COMPLETE_TABLE && cmd.isAbstract()) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSStoreManager.this.registerStoreData((StoreData)sdNew);
                    } else if (imd.getStrategy() == InheritanceStrategy.NEW_TABLE || imd.getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                        DatastoreIdentifier tableName = null;
                        RDBMSStoreData tmpData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(cmd.getFullClassName());
                        tableName = tmpData != null && tmpData.getDatastoreIdentifier() != null ? tmpData.getDatastoreIdentifier() : RDBMSStoreManager.this.identifierFactory.newDatastoreContainerIdentifier((AbstractClassMetaData)cmd);
                        StoreData[] existingStoreData = RDBMSStoreManager.this.getStoreDataForDatastoreContainerObject(tableName);
                        if (existingStoreData != null) {
                            String existingClass = null;
                            for (int j = 0; j < existingStoreData.length; ++j) {
                                if (existingStoreData[j].getName().equals(cmd.getFullClassName())) continue;
                                existingClass = existingStoreData[j].getName();
                                break;
                            }
                            if (existingClass != null) {
                                String msg = LOCALISER_RDBMS.msg("050015", (Object)cmd.getFullClassName(), (Object)tableName.getIdentifierName(), existingClass);
                                NucleusLogger.DATASTORE.warn((Object)msg);
                            }
                        }
                        AbstractTable t = null;
                        boolean hasViewDef = false;
                        if (RDBMSStoreManager.this.dba.getVendorID() != null) {
                            hasViewDef = cmd.hasExtension("view-definition-" + RDBMSStoreManager.this.dba.getVendorID());
                        }
                        if (!hasViewDef) {
                            hasViewDef = cmd.hasExtension("view-definition");
                        }
                        t = hasViewDef ? new ClassView(tableName, RDBMSStoreManager.this, cmd) : new ClassTable(tableName, RDBMSStoreManager.this, cmd);
                        sdNew = new RDBMSStoreData(cmd, t, true);
                        RDBMSStoreManager.this.registerStoreData((StoreData)sdNew);
                        ((Table)t).preInitialize(clr);
                    } else if (imd.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                        AbstractClassMetaData[] managingCmds = RDBMSStoreManager.this.getClassesManagingTableForClass((AbstractClassMetaData)cmd, clr);
                        DatastoreContainerObject superTable = null;
                        if (managingCmds != null && managingCmds.length == 1) {
                            RDBMSStoreData superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                            if (superData != null) {
                                superTable = superData.getDatastoreContainerObject();
                            }
                            sdNew = new RDBMSStoreData(cmd, superTable, false);
                            RDBMSStoreManager.this.registerStoreData((StoreData)sdNew);
                        } else {
                            String msg = LOCALISER_RDBMS.msg("050013", (Object)cmd.getFullClassName());
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                    }
                    this.schemaDataAdded.add(sdNew);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addClassTablesAndValidate(String[] classNames, ClassLoaderResolver clr) {
            StoreDataManager storeDataManager = RDBMSStoreManager.this.storeDataMgr;
            synchronized (storeDataManager) {
                block13: {
                    block12: {
                        RDBMSStoreManager.this.storeDataMgr.begin();
                        boolean completed = false;
                        List tablesCreated = null;
                        List tableConstraintsCreated = null;
                        List viewsCreated = null;
                        try {
                            List[] result;
                            List autoCreateErrors = new ArrayList();
                            this.addClassTables(classNames, clr);
                            List<DatastoreContainerObject>[] toValidate = this.initializeClassTables(classNames, clr);
                            if (toValidate[0] != null && toValidate[0].size() > 0) {
                                result = this.performTablesValidation(toValidate[0], clr);
                                tablesCreated = result[0];
                                tableConstraintsCreated = result[1];
                                autoCreateErrors = result[2];
                            }
                            if (toValidate[1] != null && toValidate[1].size() > 0) {
                                result = this.performViewsValidation(toValidate[1]);
                                viewsCreated = result[0];
                                autoCreateErrors.addAll(result[1]);
                            }
                            this.verifyErrors(autoCreateErrors);
                            completed = true;
                            if (completed) break block12;
                        }
                        catch (SQLException sqle) {
                            try {
                                String msg = LOCALISER_RDBMS.msg("050044", (Object)sqle);
                                NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                                throw new NucleusDataStoreException(msg, (Throwable)sqle);
                                catch (Exception e) {
                                    if (NucleusException.class.isAssignableFrom(e.getClass())) {
                                        throw (NucleusException)((Object)e);
                                    }
                                    NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("050044", (Object)e));
                                    throw new NucleusException(e.toString(), (Throwable)e).setFatal();
                                }
                            }
                            catch (Throwable throwable) {
                                if (!completed) {
                                    RDBMSStoreManager.this.storeDataMgr.rollback();
                                    this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                                } else {
                                    RDBMSStoreManager.this.storeDataMgr.commit();
                                }
                                this.schemaDataAdded.clear();
                                throw throwable;
                            }
                        }
                        RDBMSStoreManager.this.storeDataMgr.rollback();
                        this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                        break block13;
                    }
                    RDBMSStoreManager.this.storeDataMgr.commit();
                }
                this.schemaDataAdded.clear();
                return;
            }
        }

        private List<DatastoreContainerObject>[] initializeClassTables(String[] classNames, ClassLoaderResolver clr) {
            boolean someNeededInitialisation;
            ArrayList<Table> tablesToValidate = new ArrayList<Table>();
            ArrayList<Table> viewsToValidate = new ArrayList<Table>();
            ArrayList<Table> recentlyInitiliased = new ArrayList<Table>();
            do {
                someNeededInitialisation = false;
                RDBMSStoreData[] rdbmsStoreData = RDBMSStoreManager.this.storeDataMgr.getManagedStoreData().toArray(new RDBMSStoreData[RDBMSStoreManager.this.storeDataMgr.size()]);
                for (int i = 0; i < rdbmsStoreData.length; ++i) {
                    if (!rdbmsStoreData[i].hasTable()) continue;
                    Table t = (Table)rdbmsStoreData[i].getDatastoreContainerObject();
                    if (t instanceof DatastoreClass) {
                        ((RDBMSPersistenceHandler)RDBMSStoreManager.this.persistenceHandler).removeRequestsForTable((DatastoreClass)t);
                    }
                    if (!t.isInitialized()) {
                        t.initialize(clr);
                        recentlyInitiliased.add(t);
                        if (t instanceof ViewImpl) {
                            viewsToValidate.add(t);
                        } else {
                            tablesToValidate.add(t);
                        }
                        someNeededInitialisation = true;
                    }
                    if (rdbmsStoreData[i].isTableOwner() || ((ClassTable)t).managesClass(rdbmsStoreData[i].getName())) continue;
                    ((ClassTable)t).manageClass((AbstractClassMetaData)((ClassMetaData)rdbmsStoreData[i].getMetaData()), clr);
                    if (!tablesToValidate.contains(t)) {
                        tablesToValidate.add(t);
                    }
                    someNeededInitialisation = true;
                }
            } while (someNeededInitialisation);
            for (int j = 0; j < recentlyInitiliased.size(); ++j) {
                ((Table)recentlyInitiliased.get(j)).postInitialize(clr);
            }
            return new List[]{tablesToValidate, viewsToValidate};
        }

        private List[] performTablesValidation(List<DatastoreContainerObject> tablesToValidate, ClassLoaderResolver clr) throws SQLException {
            ArrayList autoCreateErrors = new ArrayList();
            ArrayList<TableImpl> tableConstraintsCreated = new ArrayList<TableImpl>();
            ArrayList<TableImpl> tablesCreated = new ArrayList<TableImpl>();
            if (this.ddlWriter != null) {
                tablesToValidate = this.removeDuplicateTablesFromList(tablesToValidate);
            }
            for (TableImpl tableImpl : tablesToValidate) {
                boolean columnsValidated = false;
                if (this.checkExistTablesOrViews) {
                    if (this.ddlWriter != null) {
                        try {
                            if (tableImpl instanceof ClassTable) {
                                this.ddlWriter.write("-- Table " + tableImpl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tableImpl).getManagedClasses()) + "\n");
                            } else if (tableImpl instanceof JoinTable) {
                                this.ddlWriter.write("-- Table " + tableImpl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                        }
                    }
                    if (!tablesCreated.contains(tableImpl) && tableImpl.exists(this.getCurrentConnection(), RDBMSStoreManager.this.autoCreateTables)) {
                        tablesCreated.add(tableImpl);
                        columnsValidated = true;
                    } else if (tableImpl.isInitializedModified() || RDBMSStoreManager.this.autoCreateColumns) {
                        tableImpl.validateColumns(this.getCurrentConnection(), false, RDBMSStoreManager.this.autoCreateColumns, autoCreateErrors);
                        columnsValidated = true;
                    }
                }
                if (RDBMSStoreManager.this.validateTables && !columnsValidated) {
                    tableImpl.validate(this.getCurrentConnection(), RDBMSStoreManager.this.validateColumns, false, autoCreateErrors);
                } else if (!columnsValidated) {
                    String initInfo = RDBMSStoreManager.this.getStringProperty("datanucleus.rdbms.initializeColumnInfo");
                    if (initInfo.equalsIgnoreCase("PK")) {
                        tableImpl.initializeColumnInfoForPrimaryKeyColumns(this.getCurrentConnection());
                    } else if (initInfo.equalsIgnoreCase("ALL")) {
                        tableImpl.initializeColumnInfoFromDatastore(this.getCurrentConnection());
                    }
                }
                RDBMSStoreManager.this.invalidateColumnInfoForTable(tableImpl);
            }
            for (TableImpl tableImpl : tablesToValidate) {
                if (!RDBMSStoreManager.this.validateConstraints && !RDBMSStoreManager.this.autoCreateConstraints) continue;
                if (this.ddlWriter != null) {
                    try {
                        if (tableImpl instanceof ClassTable) {
                            this.ddlWriter.write("-- Constraints for table " + tableImpl.toString() + " for class(es) " + StringUtils.objectArrayToString((Object[])((ClassTable)tableImpl).getManagedClasses()) + "\n");
                        } else {
                            this.ddlWriter.write("-- Constraints for table " + tableImpl.toString() + "\n");
                        }
                    }
                    catch (IOException ioe) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                    }
                }
                if (tablesCreated.contains(tableImpl) && !this.hasDuplicateTablesFromList(tablesToValidate)) {
                    if (tableImpl.createConstraints(this.getCurrentConnection(), autoCreateErrors, clr)) {
                        tableConstraintsCreated.add(tableImpl);
                    }
                } else if (tableImpl.validateConstraints(this.getCurrentConnection(), RDBMSStoreManager.this.autoCreateConstraints, autoCreateErrors, clr)) {
                    tableConstraintsCreated.add(tableImpl);
                }
                if (this.ddlWriter == null) continue;
                try {
                    this.ddlWriter.write("\n");
                }
                catch (IOException ioe) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                }
            }
            return new List[]{tablesCreated, tableConstraintsCreated, autoCreateErrors};
        }

        private List<DatastoreContainerObject> removeDuplicateTablesFromList(List<DatastoreContainerObject> newTables) {
            ArrayList<DatastoreContainerObject> result = new ArrayList<DatastoreContainerObject>();
            for (DatastoreContainerObject tbl : newTables) {
                if (result.contains(tbl)) continue;
                result.add(tbl);
            }
            return result;
        }

        private boolean hasDuplicateTablesFromList(List<DatastoreContainerObject> newTables) {
            HashMap<String, DatastoreContainerObject> map = new HashMap<String, DatastoreContainerObject>();
            for (int i = 0; i < newTables.size(); ++i) {
                DatastoreContainerObject t1 = newTables.get(i);
                if (map.containsKey(t1.getIdentifier().getIdentifierName())) {
                    return true;
                }
                map.put(t1.getIdentifier().getIdentifierName(), t1);
            }
            return false;
        }

        private List[] performViewsValidation(List<DatastoreContainerObject> viewsToValidate) throws SQLException {
            ArrayList<ViewImpl> viewsCreated = new ArrayList<ViewImpl>();
            ArrayList autoCreateErrors = new ArrayList();
            for (ViewImpl viewImpl : viewsToValidate) {
                if (this.checkExistTablesOrViews && viewImpl.exists(this.getCurrentConnection(), RDBMSStoreManager.this.autoCreateTables)) {
                    viewsCreated.add(viewImpl);
                }
                if (RDBMSStoreManager.this.validateTables) {
                    viewImpl.validate(this.getCurrentConnection(), true, false, autoCreateErrors);
                }
                RDBMSStoreManager.this.invalidateColumnInfoForTable(viewImpl);
            }
            return new List[]{viewsCreated, autoCreateErrors};
        }

        private void verifyErrors(List autoCreateErrors) {
            if (autoCreateErrors.size() > 0) {
                for (Throwable exc : autoCreateErrors) {
                    if (RDBMSStoreManager.this.autoCreateWarnOnError) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050044", (Object)exc));
                        continue;
                    }
                    NucleusLogger.DATASTORE.error((Object)LOCALISER_RDBMS.msg("050044", (Object)exc));
                }
                if (!RDBMSStoreManager.this.autoCreateWarnOnError) {
                    throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("050043"), autoCreateErrors.toArray(new Throwable[autoCreateErrors.size()]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackSchemaCreation(List<DatastoreContainerObject> viewsCreated, List<DatastoreContainerObject> tableConstraintsCreated, List<DatastoreContainerObject> tablesCreated) {
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050040"));
            }
            try {
                ListIterator<DatastoreContainerObject> li;
                if (viewsCreated != null) {
                    li = viewsCreated.listIterator(viewsCreated.size());
                    while (li.hasPrevious()) {
                        ((ViewImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
                if (tableConstraintsCreated != null) {
                    li = tableConstraintsCreated.listIterator(tableConstraintsCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).dropConstraints(this.getCurrentConnection());
                    }
                }
                if (tablesCreated != null) {
                    li = tablesCreated.listIterator(tablesCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_RDBMS.msg("050041", (Object)e));
            }
            if (RDBMSStoreManager.this.starter != null && RDBMSStoreManager.this.starterInitialised) {
                try {
                    if (!RDBMSStoreManager.this.starter.isOpen()) {
                        RDBMSStoreManager.this.starter.open();
                    }
                    for (RDBMSStoreData sd : this.schemaDataAdded) {
                        RDBMSStoreManager.this.starter.deleteClass(sd.getName());
                    }
                }
                finally {
                    if (RDBMSStoreManager.this.starter.isOpen()) {
                        RDBMSStoreManager.this.starter.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatastoreContainerObject addJoinTableForContainer(AbstractMemberMetaData mmd, ClassLoaderResolver clr, int type) {
            RDBMSStoreData data;
            DatastoreIdentifier tableName = null;
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(mmd);
            tableName = sd != null && sd.getDatastoreIdentifier() != null ? sd.getDatastoreIdentifier() : RDBMSStoreManager.this.identifierFactory.newDatastoreContainerIdentifier(mmd);
            JoinTable join = null;
            if (type == 1) {
                join = new CollectionTable(tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 2) {
                join = new MapTable(tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 3) {
                join = new ArrayTable(tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 4) {
                join = new PersistableJoinTable(tableName, mmd, RDBMSStoreManager.this);
            }
            try {
                if (RDBMSStoreManager.this.starter != null && RDBMSStoreManager.this.starterInitialised && !RDBMSStoreManager.this.starter.isOpen()) {
                    RDBMSStoreManager.this.starter.open();
                }
                data = new RDBMSStoreData(mmd, join);
                RDBMSStoreManager.this.registerStoreData((StoreData)data);
            }
            finally {
                if (RDBMSStoreManager.this.starter != null && RDBMSStoreManager.this.starterInitialised && RDBMSStoreManager.this.starter.isOpen()) {
                    RDBMSStoreManager.this.starter.close();
                }
            }
            this.schemaDataAdded.add(data);
            return join;
        }
    }
}

