/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.valuegenerator.ValueGenerationException;

public class SequenceTable
extends TableImpl {
    private JavaTypeMapping sequenceNameMapping = null;
    private JavaTypeMapping nextValMapping = null;
    private String insertStmt = null;
    private String incrementByStmt = null;
    private String deleteStmt = null;
    private String deleteAllStmt = null;
    private String fetchAllStmt = null;
    private String fetchStmt = null;
    private String sequenceNameColumnName;
    private String nextValColumnName;

    public SequenceTable(DatastoreIdentifier identifier, RDBMSStoreManager storeMgr, String seqNameColName, String nextValColName) {
        super(identifier, storeMgr);
        this.sequenceNameColumnName = seqNameColName;
        this.nextValColumnName = nextValColName;
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        this.sequenceNameMapping = this.storeMgr.getMappingManager().getMapping(String.class);
        Column colSequenceName = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier(this.sequenceNameColumnName), this.sequenceNameMapping, null);
        colSequenceName.setAsPrimaryKey();
        colSequenceName.getColumnMetaData().setLength(Integer.valueOf("255"));
        colSequenceName.getColumnMetaData().setJdbcType("VARCHAR");
        this.getStoreManager().getMappingManager().createDatastoreMapping(this.sequenceNameMapping, (DatastoreField)colSequenceName, String.class.getName());
        this.nextValMapping = this.storeMgr.getMappingManager().getMapping(Long.class);
        DatastoreField colNextVal = this.addDatastoreField(Long.class.getName(), idFactory.newDatastoreFieldIdentifier(this.nextValColumnName), this.nextValMapping, null);
        this.getStoreManager().getMappingManager().createDatastoreMapping(this.nextValMapping, colNextVal, Long.class.getName());
        this.insertStmt = "INSERT INTO " + this.identifier.getFullyQualifiedName(false) + " (" + colSequenceName.getIdentifier() + "," + colNextVal.getIdentifier() + ") VALUES (?,?)";
        this.incrementByStmt = "UPDATE " + this.identifier.getFullyQualifiedName(false) + " SET " + colNextVal.getIdentifier() + "=(" + colNextVal.getIdentifier() + "+?) WHERE " + colSequenceName.getIdentifier() + "=?";
        this.deleteStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + colSequenceName.getIdentifier() + "=?";
        this.deleteAllStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false);
        this.fetchStmt = "SELECT " + colNextVal.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + colSequenceName.getIdentifier() + "=?";
        if (this.dba.supportsOption("LockWithSelectForUpdate")) {
            this.fetchStmt = this.fetchStmt + " FOR UPDATE";
        }
        this.fetchAllStmt = "SELECT " + colNextVal.getIdentifier() + "," + colSequenceName.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " ORDER BY " + colSequenceName.getIdentifier();
        this.state = 2;
    }

    public JavaTypeMapping getIdMapping() {
        throw new NucleusException("Attempt to get ID mapping of Sequence table!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getFetchAllSequences(ManagedConnection conn) throws SQLException {
        HashSet<String> sequenceNames = new HashSet<String>();
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForQuery(conn, this.fetchAllStmt);
            ResultSet rs = sqlControl.executeStatementQuery(null, conn, this.fetchAllStmt, ps);
            try {
                while (rs.next()) {
                    sequenceNames.add(rs.getString(2));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
        return sequenceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Long getNextVal(String sequenceName, ManagedConnection conn, int incrementBy, DatastoreIdentifier tableIdentifier, String columnName, int initialValue) throws SQLException {
        Long nextVal;
        block22: {
            PreparedStatement ps = null;
            nextVal = null;
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                ps = sqlControl.getStatementForQuery(conn, this.fetchStmt);
                this.sequenceNameMapping.setString(null, (Object)ps, new int[]{1}, sequenceName);
                ResultSet rs = sqlControl.executeStatementQuery(null, conn, this.fetchStmt, ps);
                try {
                    block24: {
                        if (rs.next()) break block24;
                        boolean addedSequence = false;
                        if (initialValue >= 0) {
                            this.addSequence(sequenceName, Long.valueOf(incrementBy + initialValue), conn);
                            nextVal = initialValue;
                            break block22;
                        }
                        if (columnName != null && tableIdentifier != null) {
                            PreparedStatement ps2;
                            block23: {
                                ps2 = null;
                                ResultSet rs2 = null;
                                try {
                                    String fetchInitStmt = "SELECT MAX(" + columnName + ") FROM " + tableIdentifier.getFullyQualifiedName(false);
                                    ps2 = sqlControl.getStatementForQuery(conn, fetchInitStmt);
                                    rs2 = sqlControl.executeStatementQuery(null, conn, fetchInitStmt, ps2);
                                    if (rs2.next()) {
                                        long val = rs2.getLong(1);
                                        this.addSequence(sequenceName, (long)(incrementBy + 1) + val, conn);
                                        nextVal = 1L + val;
                                        addedSequence = true;
                                    }
                                    if (rs2 == null) break block23;
                                }
                                catch (Exception e) {
                                    if (rs2 != null) {
                                        rs2.close();
                                    }
                                    if (ps2 != null) {
                                        sqlControl.closeStatement(conn, ps2);
                                    }
                                    catch (Throwable throwable) {
                                        if (rs2 != null) {
                                            rs2.close();
                                        }
                                        if (ps2 != null) {
                                            sqlControl.closeStatement(conn, ps2);
                                        }
                                        throw throwable;
                                    }
                                }
                                rs2.close();
                            }
                            if (ps2 != null) {
                                sqlControl.closeStatement(conn, ps2);
                            }
                        }
                        if (!addedSequence) {
                            this.addSequence(sequenceName, Long.valueOf(incrementBy + 0), conn);
                            nextVal = initialValue;
                        }
                        break block22;
                    }
                    nextVal = rs.getLong(1);
                    this.incrementSequence(sequenceName, incrementBy, conn);
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw new ValueGenerationException(LOCALISER.msg("061001", (Object)e.getMessage()), (Throwable)e);
            }
            finally {
                if (ps != null) {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequence(String sequenceName, long incrementBy, ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.incrementByStmt, false);
            this.nextValMapping.setLong(null, (Object)ps, new int[]{1}, incrementBy);
            this.sequenceNameMapping.setString(null, (Object)ps, new int[]{2}, sequenceName);
            sqlControl.executeStatementUpdate(null, conn, this.incrementByStmt, ps, true);
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    private void addSequence(String sequenceName, Long nextVal, ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.insertStmt, false);
            this.sequenceNameMapping.setString(null, (Object)ps, new int[]{1}, sequenceName);
            this.nextValMapping.setLong(null, (Object)ps, new int[]{2}, nextVal.longValue());
            sqlControl.executeStatementUpdate(null, conn, this.insertStmt, ps, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequence(String sequenceName, ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.deleteStmt, false);
            ps.setString(1, sequenceName);
            sqlControl.executeStatementUpdate(null, conn, this.deleteStmt, ps, true);
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSequences(ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.deleteAllStmt, false);
            sqlControl.executeStatementUpdate(null, conn, this.deleteAllStmt, ps, true);
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

