/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class DecimalRDBMSMapping
extends RDBMSMapping {
    private static final int INT_MAX_DECIMAL_DIGITS = 10;
    private static final int LONG_MAX_DECIMAL_DIGITS = 19;

    protected DecimalRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public DecimalRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && this.column.getColumnMetaData().getLength() == null) {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(10));
                this.column.checkDecimal();
            } else {
                this.column.getColumnMetaData().setLength(Integer.valueOf(Math.min(this.getTypeInfo().getPrecision(), 19)));
                this.column.checkDecimal();
            }
        }
        this.initTypeInfo();
    }

    public boolean isDecimalBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(3, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(3);
    }

    public void setDouble(Object ps, int param, double value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"double", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"float", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public double getDouble(Object rs, int param) {
        double value;
        try {
            value = ((ResultSet)rs).getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"double", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = (float)((ResultSet)rs).getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"float", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"long", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"long", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((Integer)value));
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((Long)value));
            } else if (value instanceof BigDecimal) {
                ((PreparedStatement)ps).setBigDecimal(param, (BigDecimal)value);
            } else if (value instanceof Float) {
                ((PreparedStatement)ps).setDouble(param, ((Float)value).doubleValue());
            } else if (value instanceof Double) {
                ((PreparedStatement)ps).setDouble(param, (Double)value);
            } else if (value instanceof BigInteger) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((BigInteger)value));
            } else {
                ((PreparedStatement)ps).setInt(param, (Integer)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Number value;
        try {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : Integer.valueOf(value.toBigInteger().intValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : Long.valueOf(value.toBigInteger().longValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGINTEGER)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : value.toBigInteger();
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL)) {
                value = ((ResultSet)rs).getBigDecimal(param);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT)) {
                double d = ((ResultSet)rs).getDouble(param);
                value = ((ResultSet)rs).wasNull() ? null : new Float(d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_DOUBLE)) {
                double d = ((ResultSet)rs).getDouble(param);
                value = ((ResultSet)rs).wasNull() ? null : new Double(d);
            } else {
                int i = ((ResultSet)rs).getInt(param);
                value = ((ResultSet)rs).wasNull() ? null : Integer.valueOf(i);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

