/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.types.sco.SCOUtils;

public class OracleMapMapping
extends MapMapping {
    public void postInsert(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            Map value = (Map)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value != null) {
                ExecutionContext ec = ownerOP.getExecutionContext();
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            byte[] bytes = new byte[]{};
            if (value != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    bytes = baos.toByteArray();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            OracleBlobRDBMSMapping.updateBlobColumn(ownerOP, this.getDatastoreContainer(), this.getDatastoreMapping(0), bytes);
        } else {
            super.postInsert(ownerOP);
        }
    }

    public void postUpdate(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            Map value = (Map)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value != null) {
                ExecutionContext ec = ownerOP.getExecutionContext();
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            this.postInsert(ownerOP);
        } else {
            super.postUpdate(ownerOP);
        }
    }
}

