/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.CandidateIdsQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.QueryToSQLMapper;
import org.datanucleus.store.rdbms.query.RDBMSQueryCompilation;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient RDBMSQueryCompilation datastoreCompilation;
    public static final String EXTENSION_RDBMS_RESULTSET_TYPE = "datanucleus.rdbms.query.resultSetType";
    public static final String EXTENSION_RDBMS_RESULTSET_CONCURRENCY = "datanucleus.rdbms.query.resultSetConcurrency";
    public static final String EXTENSION_RDBMS_FETCH_DIRECTION = "datanucleus.rdbms.query.fetchDirection";

    public JPQLQuery(ExecutionContext ec) {
        this(ec, (JPQLQuery)null);
    }

    public JPQLQuery(ExecutionContext ec, JPQLQuery q) {
        super(ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    public void setImplicitParameter(int position, Object value) {
        if (this.datastoreCompilation != null && !this.datastoreCompilation.isPrecompilable()) {
            this.datastoreCompilation = null;
        }
        super.setImplicitParameter(position, value);
    }

    public void setImplicitParameter(String name, Object value) {
        if (this.datastoreCompilation != null && !this.datastoreCompilation.isPrecompilable()) {
            this.datastoreCompilation = null;
        }
        super.setImplicitParameter(name, value);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.candidateCollection != null) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = storeMgr.getQueryCacheKey();
        String queryCacheKey = this.getQueryCacheKey();
        if (this.useCaching() && queryCacheKey != null) {
            boolean nullParameter = false;
            if (parameterValues != null) {
                for (Object val : parameterValues.values()) {
                    if (val != null) continue;
                    nullParameter = true;
                    break;
                }
            }
            if (!nullParameter) {
                this.datastoreCompilation = (RDBMSQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), queryCacheKey);
                if (this.datastoreCompilation != null) {
                    return;
                }
            }
        }
        if (this.type == 1) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryUpdate(parameterValues, acmd);
        } else if (this.type == 2) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryDelete(parameterValues, acmd);
        } else {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            if (inMemory) {
                this.compileQueryToRetrieveCandidates(parameterValues, acmd);
            } else {
                this.compileQueryFull(parameterValues, acmd);
                if (this.result != null) {
                    StatementResultMapping resultMapping = this.datastoreCompilation.getResultDefinition();
                    for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                        StatementMappingIndex idx;
                        AbstractMemberMetaData mmd;
                        Object stmtMap = resultMapping.getMappingForResultExpression(i);
                        if (!(stmtMap instanceof StatementMappingIndex) || (mmd = (idx = (StatementMappingIndex)stmtMap).getMapping().getMemberMetaData()) == null || !mmd.hasCollection() && !mmd.hasMap() && !mmd.hasArray()) continue;
                        throw new NucleusUserException(LOCALISER.msg("021213"));
                    }
                }
            }
            if (this.resultClass != null && this.result != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        StatementResultMapping resultMapping = JPQLQuery.this.datastoreCompilation.getResultDefinition();
                        if (QueryUtils.resultClassIsSimple((String)JPQLQuery.this.resultClass.getName())) {
                            Class resultClassPrimitive;
                            if (resultMapping.getNumberOfResultExpressions() > 1) {
                                throw new NucleusUserException(LOCALISER.msg("021201", (Object)JPQLQuery.this.resultClass.getName()));
                            }
                            Object stmtMap = resultMapping.getMappingForResultExpression(0);
                            StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                            Class exprType = idx.getMapping().getJavaType();
                            boolean typeConsistent = false;
                            if (exprType == JPQLQuery.this.resultClass) {
                                typeConsistent = true;
                            } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType((Class)JPQLQuery.this.resultClass)) == exprType) {
                                typeConsistent = true;
                            }
                            if (!typeConsistent) {
                                throw new NucleusUserException(LOCALISER.msg("021202", (Object)JPQLQuery.this.resultClass.getName(), (Object)exprType));
                            }
                        } else if (QueryUtils.resultClassIsUserType((String)JPQLQuery.this.resultClass.getName())) {
                            Class[] ctrTypes = new Class[resultMapping.getNumberOfResultExpressions()];
                            for (int i = 0; i < ctrTypes.length; ++i) {
                                Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                if (stmtMap instanceof StatementMappingIndex) {
                                    ctrTypes[i] = ((StatementMappingIndex)stmtMap).getMapping().getJavaType();
                                    continue;
                                }
                                if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                            }
                            Constructor ctr = ClassUtils.getConstructorWithArguments((Class)JPQLQuery.this.resultClass, (Class[])ctrTypes);
                            if (ctr == null && !ClassUtils.hasDefaultConstructor((Class)JPQLQuery.this.resultClass)) {
                                throw new NucleusUserException(LOCALISER.msg("021205", (Object)JPQLQuery.this.resultClass.getName()));
                            }
                            if (ctr == null) {
                                for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                                    Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                    if (stmtMap instanceof StatementMappingIndex) {
                                        Method putMethod;
                                        Method setMethod;
                                        StatementMappingIndex mapIdx = (StatementMappingIndex)stmtMap;
                                        AbstractMemberMetaData mmd = mapIdx.getMapping().getMemberMetaData();
                                        String fieldName = mapIdx.getColumnAlias();
                                        Class fieldType = mapIdx.getMapping().getJavaType();
                                        if (fieldName == null && mmd != null) {
                                            fieldName = mmd.getName();
                                        }
                                        if (fieldName == null) continue;
                                        Class<?> resultFieldType = null;
                                        boolean publicField = true;
                                        try {
                                            Field fld = JPQLQuery.this.resultClass.getDeclaredField(fieldName);
                                            resultFieldType = fld.getType();
                                            if (!ClassUtils.typesAreCompatible((Class)fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, (Class)fieldType)) {
                                                throw new NucleusUserException(LOCALISER.msg("021211", (Object)fieldName, (Object)fieldType.getName(), (Object)resultFieldType.getName()));
                                            }
                                            if (!Modifier.isPublic(fld.getModifiers())) {
                                                publicField = false;
                                            }
                                        }
                                        catch (NoSuchFieldException nsfe) {
                                            publicField = false;
                                        }
                                        if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass((Class)JPQLQuery.this.resultClass, (String)fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)JPQLQuery.this.resultClass)) != null) continue;
                                        throw new NucleusUserException(LOCALISER.msg("021212", (Object)JPQLQuery.this.resultClass.getName(), (Object)fieldName));
                                    }
                                    if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021085", (Object)this, (Object)this.datastoreCompilation.getSQL()));
            }
            boolean hasParams = false;
            if (this.explicitParameters != null) {
                hasParams = true;
            } else if (parameterValues != null && parameterValues.size() > 0) {
                hasParams = true;
            }
            if (!this.datastoreCompilation.isPrecompilable() || this.datastoreCompilation.getSQL().indexOf(63) < 0 && hasParams) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021075"));
            } else if (this.useCaching() && queryCacheKey != null) {
                qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), queryCacheKey, (Object)this.datastoreCompilation);
            }
        }
    }

    public String getSQL() {
        if (this.datastoreCompilation != null) {
            return this.datastoreCompilation.getSQL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        List cachedResults;
        if (this.candidateCollection != null) {
            if (this.candidateCollection.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList candidates = new ArrayList(this.candidateCollection);
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.clr);
            return resultMapper.execute(true, true, true, true, true);
        }
        if (this.type == 0 && (cachedResults = this.getQueryManager().getDatastoreQueryResult((Query)this, parameters)) != null) {
            return new CandidateIdsQueryResult((Query)this, cachedResults);
        }
        Object results = null;
        ManagedConnection mconn = this.ec.getStoreManager().getConnection(this.ec);
        try {
            long startTime;
            block29: {
                startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)this.getLanguage(), (Object)this.getSingleStringQuery(), null));
                }
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
                SQLController sqlControl = storeMgr.getSQLController();
                PreparedStatement ps = null;
                try {
                    if (this.type == 0) {
                        ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.datastoreCompilation.getSQL(), (Query)this);
                        SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), null, parameters);
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                        this.registerTask(ps);
                        ResultSet rs = null;
                        try {
                            rs = sqlControl.executeStatementQuery(mconn, this.toString(), ps);
                        }
                        finally {
                            this.deregisterTask();
                        }
                        AbstractRDBMSQueryResult qr = null;
                        try {
                            if (this.evaluateInMemory()) {
                                ResultObjectFactory rof = storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), this.getFetchPlan(), this.candidateClass);
                                ArrayList<Object> candidates = new ArrayList<Object>();
                                while (rs.next()) {
                                    candidates.add(rof.getObject(this.ec, (Object)rs));
                                }
                                JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.clr);
                                results = resultMapper.execute(true, true, true, true, true);
                            } else {
                                ResultClassROF rof = null;
                                rof = this.result != null ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinition()) : (this.resultClass != null && this.resultClass != this.candidateClass ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinitionForClass()) : storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), this.getFetchPlan(), this.candidateClass));
                                String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                                qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection);
                                ScrollableQueryResult qr1 = qr;
                                ManagedConnection mconn1 = mconn;
                                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                    final /* synthetic */ QueryResult val$qr1;
                                    final /* synthetic */ ManagedConnection val$mconn1;
                                    {
                                        this.val$qr1 = queryResult;
                                        this.val$mconn1 = managedConnection;
                                    }

                                    public void transactionFlushed() {
                                    }

                                    public void transactionPreClose() {
                                        this.val$qr1.disconnect();
                                    }

                                    public void managedConnectionPreClose() {
                                    }

                                    public void managedConnectionPostClose() {
                                    }

                                    public void resourcePostClose() {
                                        this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                    }
                                };
                                mconn.addListener(listener);
                                ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                results = qr;
                            }
                            break block29;
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    if (this.type == 1) {
                        ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                        SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), null, parameters);
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                        int[] updateResults = sqlControl.executeStatementUpdate(mconn, this.toString(), ps, true);
                        try {
                            this.ec.getNucleusContext().getLevel2Cache().evictAll(this.candidateClass, this.subclasses);
                        }
                        catch (UnsupportedOperationException uoe) {
                            // empty catch block
                        }
                        results = (long)updateResults[0];
                        break block29;
                    }
                    if (this.type != 2) break block29;
                    ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                    SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), null, parameters);
                    RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                    int[] deleteResults = sqlControl.executeStatementUpdate(mconn, this.toString(), ps, true);
                    try {
                        this.ec.getNucleusContext().getLevel2Cache().evictAll(this.candidateClass, this.subclasses);
                    }
                    catch (UnsupportedOperationException uoe) {
                        // empty catch block
                    }
                    results = (long)deleteResults[0];
                }
                catch (SQLException sqle) {
                    if (((RDBMSAdapter)storeMgr.getDatastoreAdapter()).isStatementCancel(sqle)) {
                        throw new QueryInterruptedException("Query has been interrupted", (Throwable)sqle);
                    }
                    if (((RDBMSAdapter)storeMgr.getDatastoreAdapter()).isStatementTimeout(sqle)) {
                        throw new QueryTimeoutException("Query has been timed out", (Throwable)sqle);
                    }
                    throw new NucleusException(LOCALISER.msg("021042"), (Throwable)sqle);
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Long l = results;
            return l;
        }
        finally {
            mconn.release();
        }
    }

    protected void assertSupportsCancel() {
    }

    protected boolean cancelTaskObject(Object obj) {
        Statement ps = (Statement)obj;
        try {
            ps.cancel();
            return true;
        }
        catch (SQLException sqle) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Error cancelling query", (Throwable)sqle);
            return false;
        }
    }

    protected boolean supportsTimeout() {
        return true;
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        if (this.candidateCollection != null) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        if (this.result != null) {
            this.datastoreCompilation.setResultDefinition(new StatementResultMapping());
        } else {
            this.datastoreCompilation.setResultDefinitionForClass(new StatementClassMapping());
        }
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ec, this.candidateClass, this.subclasses, this.result, this.compilation.getCandidateAlias(), this.compilation.getCandidateAlias());
        HashSet<String> options = new HashSet<String>();
        options.add("CASE_INSENSITIVE");
        options.add("EXPLICIT_JOINS");
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameters, this.datastoreCompilation.getResultDefinitionForClass(), this.datastoreCompilation.getResultDefinition(), candidateCmd, this.getFetchPlan(), this.ec, null, options, this.extensions);
        sqlMapper.setDefaultJoinType(SQLJoin.JoinType.INNER_JOIN);
        sqlMapper.compile();
        this.datastoreCompilation.setParameterNameByPosition(sqlMapper.getParameterNameByPosition());
        this.datastoreCompilation.setPrecompilable(sqlMapper.isPrecompilable());
        if (this.range != null) {
            long lower = this.fromInclNo;
            long upper = this.toExclNo;
            if (this.fromInclParam != null) {
                lower = ((Number)parameters.get(this.fromInclParam)).longValue();
            }
            if (this.toExclParam != null) {
                upper = ((Number)parameters.get(this.toExclParam)).longValue();
            }
            stmt.setRange(lower, upper - lower);
        }
        boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
        stmt.addExtension("lock-for-update", useUpdateLock);
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }

    private void compileQueryToRetrieveCandidates(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        if (this.candidateCollection != null) {
            return;
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        this.datastoreCompilation.setResultDefinitionForClass(resultsDef);
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ec, this.candidateClass, this.subclasses, this.result, null, null);
        if (stmt.allUnionsForSamePrimaryTable()) {
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd, this.getFetchPlan(), 1);
        } else {
            SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd);
        }
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add(EXTENSION_RDBMS_RESULTSET_TYPE);
        supported.add(EXTENSION_RDBMS_RESULTSET_CONCURRENCY);
        supported.add(EXTENSION_RDBMS_FETCH_DIRECTION);
        return supported;
    }

    protected boolean applyRangeChecks() {
        if (this.range == null) {
            return false;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.ec.getStoreManager();
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        boolean using_limit_where_clause = dba.getRangeByLimitEndOfStatementClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0;
        return this.range != null && !using_limit_where_clause && !using_rownum;
    }

    protected void compileQueryUpdate(Map parameterValues, AbstractClassMetaData candidateCmd) {
        Expression[] updateExprs = this.compilation.getExprUpdate();
        if (updateExprs == null || updateExprs.length == 0) {
            return;
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, resultsDef, this.ec, this.candidateClass, this.subclasses, this.result, null, null);
        HashSet<String> options = new HashSet<String>();
        options.add("CASE_INSENSITIVE");
        options.add("EXPLICIT_JOINS");
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, resultsDef, null, candidateCmd, this.getFetchPlan(), this.ec, null, options, this.extensions);
        sqlMapper.setDefaultJoinType(SQLJoin.JoinType.INNER_JOIN);
        sqlMapper.compile();
        DatastoreAdapter dba = ((RDBMSStoreManager)this.ec.getStoreManager()).getDatastoreAdapter();
        if (stmt.getNumberOfTables() > 0 && !dba.supportsOption("UpdateMultiTable")) {
            throw new NucleusDataStoreException("Bulk update requires use of multiple tables yet datastore doesnt allow multiple table syntax");
        }
        this.datastoreCompilation.setSQL(stmt.getUpdateStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    protected void compileQueryDelete(Map parameterValues, AbstractClassMetaData candidateCmd) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        HashSet subclassNames = this.ec.getStoreManager().getSubClassesForClass(candidateCmd.getFullClassName(), true, clr);
        if (subclassNames != null && !subclassNames.isEmpty()) {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.ec.getStoreManager();
            DatastoreClass candidateTbl = storeMgr.getDatastoreClass(candidateCmd.getFullClassName(), clr);
            for (String subclassName : subclassNames) {
                DatastoreClass subclassTbl = storeMgr.getDatastoreClass(subclassName, clr);
                if (candidateTbl == null || candidateTbl == subclassTbl) continue;
                throw new NucleusException("Bulk delete doesn't currently support deletion where the candidate table also has subclasses in their own tables");
            }
            if (candidateTbl.getSuperDatastoreClass() != null) {
                throw new NucleusException("Bulk delete doesn't currently support deletion where the candidate table also has superclass table(s)");
            }
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, resultsDef, this.ec, this.candidateClass, this.subclasses, this.result, null, null);
        HashSet<String> options = new HashSet<String>();
        options.add("CASE_INSENSITIVE");
        options.add("EXPLICIT_JOINS");
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, resultsDef, null, candidateCmd, this.getFetchPlan(), this.ec, null, options, this.extensions);
        sqlMapper.setDefaultJoinType(SQLJoin.JoinType.INNER_JOIN);
        sqlMapper.compile();
        this.datastoreCompilation.setSQL(stmt.getDeleteStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    public void addExtension(String key, Object value) {
        if (key != null && key.equals("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.addExtension(key, value);
    }

    public void setExtensions(Map extensions) {
        if (extensions != null && extensions.containsKey("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.setExtensions(extensions);
    }
}

