/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKSetStore;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractSetStoreSpecialization;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class RDBMSFKSetStore
extends FKSetStore {
    private String updateFkStmt;
    private String clearNullifyStmt;
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementClassMapping iteratorMappingDef = null;
    private StatementParameterMapping iteratorMappingParams = null;

    public RDBMSFKSetStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(mmd, (MappedStoreManager)storeMgr, clr, (AbstractSetStoreSpecialization)new RDBMSAbstractSetStoreSpecialization(LOCALISER, clr, storeMgr));
    }

    private RDBMSStoreManager getStoreMgr() {
        return (RDBMSStoreManager)this.storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(ObjectProvider ownerSM, ExecutionContext ec) {
        String stmt = this.getClearNullifyStmt();
        try {
            if (this.elementInfo.length > 1) {
                DatastoreClass table = this.getStoreMgr().getDatastoreClass(this.elementInfo[0].getClassName(), this.clr);
                if (table != null) {
                    stmt = stmt.replace("<TABLE NAME>", table.toString());
                } else {
                    NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + this.elementInfo[0].getClassName()));
                }
            }
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)this);
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)stmt), (Throwable)e);
        }
    }

    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("<TABLE NAME>");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("<TABLE NAME>");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateElementFkInternal(ObjectProvider sm, Object element, Object owner) {
        boolean retval;
        ExecutionContext ec = sm.getExecutionContext();
        String stmt = this.getUpdateFkStmt();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                int jdbcPosition = 1;
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.getStoreMgr().getDatastoreClass(element.getClass().getName(), this.clr);
                    if (table != null) {
                        stmt = stmt.replace("<TABLE NAME>", table.toString());
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                    }
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.ownerMapping), null);
                        }
                    } else if (this.ownerMemberMetaData != null) {
                        this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.ownerMapping), sm.getObject(), sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                    } else {
                        this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.ownerMapping), sm.getObject());
                    }
                    jdbcPosition += this.ownerMapping.getNumberOfDatastoreMappings();
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, (ElementContainerStore)this);
                    }
                    this.elementMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.elementMapping), element);
                    jdbcPosition += this.elementMapping.getNumberOfDatastoreMappings();
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * Exception decompiling
     */
    public Iterator iterator(ObjectProvider ownerSM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider ownerSM) {
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            return null;
        }
        SQLStatement sqlStmt = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        this.iteratorMappingDef = new StatementClassMapping();
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getCollection().getElementType();
            if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                String[] clsNames = storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(storeMgr, clr, cls, true, null, null).getStatement();
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(storeMgr, clr, clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement();
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerSM.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, clr, elementCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                this.iteratorMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
                SQLStatement subStmt = stmtGen.getStatement();
                if (sqlStmt == null) {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, this.iteratorMappingDef, ownerSM.getExecutionContext().getFetchPlan(), subStmt.getPrimaryTable(), this.emd, 0);
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, ownerSM.getExecutionContext().getFetchPlan(), subStmt.getPrimaryTable(), this.emd, 0);
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                sqlStmt.union(subStmt);
            }
        }
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            sqlStmt.setOrdering(orderExprs, descendingOrder);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        this.iteratorMappingParams = new StatementParameterMapping();
        this.iteratorMappingParams.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }
}

