/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class DriverManagerDataSource
implements DataSource {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private final String driverName;
    private final String url;
    private final ClassLoaderResolver clr;
    private final String userName;
    private final String password;

    public DriverManagerDataSource(String driverName, String url, String userName, String password, ClassLoaderResolver clr) {
        this.driverName = driverName;
        this.url = url;
        this.clr = clr;
        this.userName = userName;
        this.password = password;
        if (driverName != null) {
            try {
                clr.classForName(driverName).newInstance();
            }
            catch (Exception e) {
                try {
                    Class.forName(driverName).newInstance();
                }
                catch (Exception e2) {
                    throw new NucleusUserException(LOCALISER.msg("047006", (Object)driverName), (Throwable)e).setFatal();
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (StringUtils.isWhitespace((String)this.driverName)) {
            throw new NucleusUserException(LOCALISER.msg("047007"));
        }
        return this.getConnection(this.userName, this.password);
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            Properties info = new Properties();
            if (userName != null) {
                info.put("user", this.userName);
            }
            if (password != null) {
                info.put("password", this.password);
            }
            return ((Driver)this.clr.classForName(this.driverName).newInstance()).connect(this.url, info);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (Exception e2) {
                throw new NucleusUserException(LOCALISER.msg("047006", (Object)this.driverName), (Throwable)e).setFatal();
            }
        }
    }

    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DriverManagerDataSource)) {
            return false;
        }
        DriverManagerDataSource dmds = (DriverManagerDataSource)obj;
        if (this.driverName == null ? dmds.driverName != null : !this.driverName.equals(dmds.driverName)) {
            return false;
        }
        return !(this.url == null ? dmds.url != null : !this.url.equals(dmds.url));
    }

    public int hashCode() {
        return (this.driverName == null ? 0 : this.driverName.hashCode()) ^ (this.url == null ? 0 : this.url.hashCode());
    }

    public Object unwrap(Class iface) throws SQLException {
        if (!DataSource.class.equals((Object)iface)) {
            throw new SQLException("DataSource of type [" + this.getClass().getName() + "] can only be unwrapped as [javax.sql.DataSource], not as [" + iface.getName() + "]");
        }
        return this;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return DataSource.class.equals((Object)iface);
    }
}

