/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.ConnectionFactoryNotFoundException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.UnsupportedConnectionFactoryException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    Object[] dataSource;
    String poolingType = null;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        if (resourceType.equals("tx")) {
            String configuredResourceTypeProperty = storeMgr.getStringProperty("datanucleus.connection.resourceType");
            if (configuredResourceTypeProperty != null) {
                this.options.put("resource-type", configuredResourceTypeProperty);
            }
            String requiredPoolingType = storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            Object connDS = storeMgr.getConnectionFactory();
            String connJNDI = storeMgr.getConnectionFactoryName();
            String connURL = storeMgr.getConnectionURL();
            this.initialiseDataSources(connDS, connJNDI, resourceType, requiredPoolingType, connURL);
            if (this.dataSource == null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047009", (Object)"transactional")).setFatal();
            }
        } else {
            String requiredPoolingType;
            String configuredResourceTypeProperty = storeMgr.getStringProperty("datanucleus.connection2.resourceType");
            if (configuredResourceTypeProperty != null) {
                this.options.put("resource-type", configuredResourceTypeProperty);
            }
            if ((requiredPoolingType = storeMgr.getStringProperty("datanucleus.connectionPoolingType.nontx")) == null) {
                requiredPoolingType = storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            }
            Object connDS = storeMgr.getConnectionFactory2();
            String connJNDI = storeMgr.getConnectionFactory2Name();
            String connURL = storeMgr.getConnectionURL();
            this.initialiseDataSources(connDS, connJNDI, resourceType, requiredPoolingType, connURL);
            if (this.dataSource == null) {
                connDS = storeMgr.getConnectionFactory();
                connJNDI = storeMgr.getConnectionFactoryName();
                this.initialiseDataSources(connDS, connJNDI, resourceType, requiredPoolingType, connURL);
            }
            if (this.dataSource == null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047009", (Object)"non-transactional")).setFatal();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialiseDataSources(Object connDS, String connJNDI, String resourceType, String requiredPoolingType, String connURL) {
        if (connDS != null) {
            if (!(connDS instanceof DataSource) && !(connDS instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(connDS);
            }
            this.dataSource = new DataSource[1];
            this.dataSource[0] = connDS;
            return;
        } else if (connJNDI != null) {
            String[] connectionFactoryNames = StringUtils.split((String)connJNDI, (String)",");
            this.dataSource = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                this.dataSource[i] = this.lookupDataSource(connectionFactoryNames[i]);
            }
            return;
        } else {
            if (connURL == null) return;
            this.dataSource = new DataSource[1];
            String poolingType = this.calculatePoolingType(requiredPoolingType);
            try {
                DataNucleusDataSourceFactory dataSourceFactory = (DataNucleusDataSourceFactory)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.datasource", "name", poolingType, "class-name", null, null);
                if (dataSourceFactory == null) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType)).setFatal();
                }
                this.dataSource[0] = dataSourceFactory.makePooledDataSource(this.storeMgr);
                if (!NucleusLogger.CONNECTION.isDebugEnabled()) return;
                NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("047008", (Object)resourceType, (Object)poolingType));
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType), (Throwable)cnfe).setFatal();
            }
            catch (Exception e) {
                if (!(e instanceof InvocationTargetException)) throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)e.getMessage()), (Throwable)e).setFatal();
                InvocationTargetException ite = (InvocationTargetException)e;
                throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
            }
        }
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        boolean releaseAfterUse;
        ManagedConnectionImpl mconn = new ManagedConnectionImpl(transactionOptions);
        if (this.resourceType.equalsIgnoreCase("nontx") && !(releaseAfterUse = this.storeMgr.getBooleanProperty("datanucleus.connection.nontx.releaseAfterUse"))) {
            mconn.setPooled();
        }
        return mconn;
    }

    private Object lookupDataSource(String name) {
        Object obj;
        try {
            obj = new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryNotFoundException(name, (Exception)e);
        }
        if (!(obj instanceof DataSource) && !(obj instanceof XADataSource)) {
            throw new UnsupportedConnectionFactoryException(obj);
        }
        return obj;
    }

    public String getPoolingType() {
        if (this.poolingType == null) {
            this.poolingType = "datasource";
        }
        return this.poolingType;
    }

    protected String calculatePoolingType(String requiredPoolingType) {
        if (this.poolingType != null) {
            return this.poolingType;
        }
        this.poolingType = requiredPoolingType;
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        if (this.poolingType != null) {
            if (this.poolingType.equals("DBCP") && !this.dbcpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"DBCP specified but not present in CLASSPATH (or one of dependencies)");
                this.poolingType = null;
            } else if (this.poolingType.equals("C3P0") && !this.c3p0Present(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"C3P0 specified but not present in CLASSPATH (or one of dependencies)");
                this.poolingType = null;
            } else if (this.poolingType.equals("Proxool") && !this.proxoolPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"Proxool specified but not present in CLASSPATH (or one of dependencies)");
                this.poolingType = null;
            } else if (this.poolingType.equals("BoneCP") && !this.bonecpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"BoneCP specified but not present in CLASSPATH (or one of dependencies)");
                this.poolingType = null;
            }
        }
        if (this.poolingType == null && this.dbcpPresent(clr)) {
            this.poolingType = "DBCP";
        }
        if (this.poolingType == null && this.c3p0Present(clr)) {
            this.poolingType = "C3P0";
        }
        if (this.poolingType == null && this.proxoolPresent(clr)) {
            this.poolingType = "Proxool";
        }
        if (this.poolingType == null && this.bonecpPresent(clr)) {
            this.poolingType = "BoneCP";
        }
        if (this.poolingType == null) {
            this.poolingType = JavaUtils.isJRE1_6OrAbove() ? "dbcp-builtin" : "None";
        }
        return this.poolingType;
    }

    protected boolean dbcpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.apache.commons.pool.ObjectPool");
            clr.classForName("org.apache.commons.dbcp.ConnectionFactory");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected boolean c3p0Present(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.mchange.v2.c3p0.ComboPooledDataSource");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected boolean proxoolPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.logicalcobwebs.proxool.ProxoolDriver");
            clr.classForName("org.apache.commons.logging.Log");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected boolean bonecpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.jolbox.bonecp.BoneCPDataSource");
            clr.classForName("org.slf4j.Logger");
            clr.classForName("com.google.common.collect.Multiset");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    static class EmulatedXAResource
    implements XAResource {
        Connection conn;

        EmulatedXAResource(Connection conn) {
            this.conn = conn;
        }

        public void commit(Xid xid, boolean flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with flags " + flags));
            try {
                this.conn.commit();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with flags " + flags));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to commit connection for transaction " + xid.toString() + " with flags " + flags));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is ending for transaction " + xid.toString() + " with flags " + flags));
        }

        public void forget(Xid arg0) throws XAException {
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }

        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            try {
                this.conn.rollback();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to rollback connection for transaction " + xid.toString()));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public boolean setTransactionTimeout(int arg0) throws XAException {
            return false;
        }

        public void start(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting for transaction " + xid.toString() + " with flags " + flags));
        }
    }

    class ManagedConnectionImpl
    extends AbstractManagedConnection {
        int isolation;
        boolean needsCommitting = false;
        ConnectionProvider connProvider = null;

        ManagedConnectionImpl(Map transactionOptions) {
            this.isolation = transactionOptions != null && transactionOptions.get("transaction.isolation") != null ? ((Number)transactionOptions.get("transaction.isolation")).intValue() : TransactionUtils.getTransactionIsolationLevelForName((String)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.transactionIsolation"));
            try {
                this.connProvider = (ConnectionProvider)ConnectionFactoryImpl.this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.connectionprovider", "name", ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), "class-name", null, null);
                if (this.connProvider == null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("050000", (Object)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"))).setFatal();
                }
                this.connProvider.setFailOnError(ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.rdbms.connectionProviderFailOnError"));
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER_RDBMS.msg("050001", (Object)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), (Object)e.getMessage()), (Throwable)e).setFatal();
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                try {
                    Connection conn = this.getSqlConnection();
                    if (conn != null && !conn.isClosed() && !conn.getAutoCommit()) {
                        ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController().processConnectionStatement((ManagedConnection)this);
                        this.needsCommitting = false;
                        conn.commit();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052005", (Object)conn.toString()));
                        }
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                }
            }
            super.release();
        }

        public XAResource getXAResource() {
            if (this.getConnection() instanceof Connection) {
                return new EmulatedXAResource((Connection)this.getConnection());
            }
            try {
                return ((XAConnection)this.getConnection()).getXAResource();
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                Connection cnx;
                block28: {
                    cnx = null;
                    try {
                        RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr;
                        boolean readOnly = ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore");
                        if (rdbmsMgr.getDatastoreAdapter() != null) {
                            RDBMSAdapter rdba = (RDBMSAdapter)rdbmsMgr.getDatastoreAdapter();
                            int reqdIsolationLevel = this.isolation;
                            if (rdba.getRequiredTransactionIsolationLevel() >= 0) {
                                reqdIsolationLevel = rdba.getRequiredTransactionIsolationLevel();
                            }
                            cnx = this.connProvider.getConnection((DataSource[])ConnectionFactoryImpl.this.dataSource);
                            boolean succeeded = false;
                            try {
                                if (cnx.isReadOnly() != readOnly) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting readonly=" + readOnly + " to connection: " + cnx.toString()));
                                    cnx.setReadOnly(readOnly);
                                }
                                if (reqdIsolationLevel == 0) {
                                    if (!cnx.getAutoCommit()) {
                                        NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true to connection: " + cnx.toString()));
                                        cnx.setAutoCommit(true);
                                    }
                                } else {
                                    if (cnx.getAutoCommit()) {
                                        NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=false to connection: " + cnx.toString()));
                                        cnx.setAutoCommit(false);
                                    }
                                    if (rdba.supportsTransactionIsolation(reqdIsolationLevel)) {
                                        int currentIsolationLevel = cnx.getTransactionIsolation();
                                        if (currentIsolationLevel != reqdIsolationLevel) {
                                            NucleusLogger.CONNECTION.debug((Object)("Setting transaction isolation " + TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel) + " to connection: " + cnx.toString()));
                                            cnx.setTransactionIsolation(reqdIsolationLevel);
                                        }
                                    } else {
                                        NucleusLogger.CONNECTION.warn((Object)LOCALISER_RDBMS.msg("051008", (long)reqdIsolationLevel));
                                    }
                                }
                                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                    NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052002", (Object)cnx.toString(), (Object)TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel)));
                                }
                                if (reqdIsolationLevel != this.isolation && this.isolation == 0 && !cnx.getAutoCommit()) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true to connection: " + cnx.toString()));
                                    cnx.setAutoCommit(true);
                                }
                                succeeded = true;
                                break block28;
                            }
                            catch (SQLException e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (!succeeded) {
                                    try {
                                        cnx.close();
                                    }
                                    catch (SQLException e) {}
                                    if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                        String cnxStr = cnx.toString();
                                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)cnxStr));
                                    }
                                }
                            }
                        }
                        cnx = ((DataSource)ConnectionFactoryImpl.this.dataSource[0]).getConnection();
                        if (cnx == null) {
                            String msg = LOCALISER_RDBMS.msg("052000", ConnectionFactoryImpl.this.dataSource[0]);
                            NucleusLogger.CONNECTION.error((Object)msg);
                            throw new NucleusDataStoreException(msg);
                        }
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052001", (Object)cnx.toString()));
                        }
                    }
                    catch (SQLException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                }
                this.conn = cnx;
            }
            this.needsCommitting = true;
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            Connection conn = this.getSqlConnection();
            if (conn != null) {
                try {
                    String connStr = conn.toString();
                    if (this.commitOnRelease && this.needsCommitting && !conn.isClosed() && !conn.getAutoCommit()) {
                        SQLController sqlController = ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController();
                        if (sqlController != null) {
                            sqlController.processConnectionStatement((ManagedConnection)this);
                        }
                        conn.commit();
                        this.needsCommitting = false;
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052005", (Object)connStr));
                        }
                    }
                    if (!conn.isClosed()) {
                        conn.close();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)connStr));
                        }
                    } else if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052004", (Object)connStr));
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                }
            }
            try {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
            finally {
                this.listeners.clear();
            }
            this.conn = null;
        }

        private Connection getSqlConnection() {
            if (this.conn != null && this.conn instanceof Connection) {
                return (Connection)this.conn;
            }
            if (this.conn != null && this.conn instanceof XAConnection) {
                try {
                    return ((XAConnection)this.conn).getConnection();
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
    }
}

