/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.IdentifierCase;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.NucleusLogger;

public class ProbeTable
extends TableImpl {
    public ProbeTable(RDBMSStoreManager storeMgr) {
        super(storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier("DELETEME" + System.currentTimeMillis()), storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
        DatastoreField column = this.addDatastoreField(Integer.TYPE.getName(), this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier("UNUSED"), mapping, null);
        this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, column, Integer.TYPE.getName());
        this.state = 2;
    }

    public JavaTypeMapping getIdMapping() {
        throw new NucleusException("Attempt to get ID mapping of ProbeTable!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSchemaDetails(Connection conn) throws SQLException {
        String[] schemaDetails = new String[2];
        DatabaseMetaData dmd = conn.getMetaData();
        String table_name = this.identifier.getIdentifierName();
        if (this.storeMgr.getIdentifierFactory().getIdentifierCase() == IdentifierCase.LOWER_CASE || this.storeMgr.getIdentifierFactory().getIdentifierCase() == IdentifierCase.LOWER_CASE_QUOTED) {
            table_name = table_name.toLowerCase();
        } else if (this.storeMgr.getIdentifierFactory().getIdentifierCase() == IdentifierCase.UPPER_CASE || this.storeMgr.getIdentifierFactory().getIdentifierCase() == IdentifierCase.UPPER_CASE_QUOTED) {
            table_name = table_name.toUpperCase();
        }
        String catalog_name = this.storeMgr.getStringProperty("datanucleus.mapping.Catalog");
        String schema_name = this.storeMgr.getStringProperty("datanucleus.mapping.Schema");
        if (!this.dba.supportsOption("CatalogInTableDefinition")) {
            catalog_name = null;
        }
        if (!this.dba.supportsOption("SchemaInTableDefinition")) {
            schema_name = null;
        }
        ResultSet rs = dmd.getTables(catalog_name, schema_name, table_name, null);
        try {
            if (!rs.next()) {
                throw new NucleusDataStoreException(LOCALISER.msg("057027", (Object)this.identifier));
            }
            schemaDetails[0] = rs.getString(1);
            schemaDetails[1] = rs.getString(2);
        }
        finally {
            rs.close();
        }
        if (schemaDetails[0] == null) {
            NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("057026"));
        }
        if (schemaDetails[1] == null) {
            NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("057025"));
        }
        return schemaDetails;
    }

    protected boolean allowDDLOutput() {
        return false;
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

