/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.TypeConversionHelper;

public class TimestampRDBMSMapping
extends RDBMSMapping {
    protected TimestampRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TimestampRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(93);
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Date) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Date)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Date)value).getTime()));
                }
            } else if (value instanceof Time) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Time)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Time)value).getTime()));
                }
            } else if (value instanceof java.sql.Date) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()));
                }
            } else if (value instanceof Calendar) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()));
                }
            } else if (cal != null) {
                ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
            } else {
                ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Timestamp", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    protected Timestamp getTimestamp(Object rs, int param) {
        Timestamp value;
        Calendar cal = this.storeMgr.getCalendarForDateTimezone();
        try {
            value = cal != null ? ((ResultSet)rs).getTimestamp(param, cal) : ((ResultSet)rs).getTimestamp(param);
        }
        catch (SQLException e) {
            try {
                String s = ((ResultSet)rs).getString(param);
                value = ((ResultSet)rs).wasNull() ? null : (s == null ? null : TypeConversionHelper.stringToTimestamp((String)s, (Calendar)cal));
            }
            catch (SQLException nestedEx) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Timestamp", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)nestedEx);
            }
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        Timestamp value = this.getTimestamp(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new Date(this.getDatabaseAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
            return new java.sql.Date(this.getDatabaseAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
            return new Time(this.getDatabaseAdapter().getAdapterTime(value));
        }
        return new Timestamp(this.getDatabaseAdapter().getAdapterTime(value));
    }
}

