/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.RegularExpressionConverter;

public class StringMatchesMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() > 2) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        if (!(args.get(0) instanceof StringExpression) && !(args.get(0) instanceof ParameterLiteral)) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        StringExpression argExpr = (StringExpression)args.get(0);
        SQLExpression escapeExpr = null;
        if (args.size() > 1) {
            escapeExpr = (SQLExpression)args.get(1);
        }
        if (argExpr instanceof StringLiteral && ((StringLiteral)argExpr).isParameter()) {
            this.stmt.getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)argExpr));
        }
        if (expr instanceof StringLiteral && argExpr instanceof StringLiteral) {
            String primary = (String)((StringLiteral)expr).getValue();
            String pattern = (String)((StringLiteral)argExpr).getValue();
            return new BooleanLiteral(this.stmt, this.exprFactory.getMappingForType(Boolean.TYPE, false), primary.matches(pattern));
        }
        if (expr instanceof StringLiteral) {
            return this.getBooleanLikeExpression(expr, argExpr, escapeExpr);
        }
        if (expr instanceof StringExpression && argExpr instanceof StringLiteral) {
            String pattern = (String)((StringLiteral)argExpr).getValue();
            if (this.stmt.getQueryGenerator().getQueryLanguage().equalsIgnoreCase("JDOQL")) {
                boolean caseSensitive = false;
                if (pattern.startsWith("(?i)")) {
                    caseSensitive = true;
                    pattern = pattern.substring(4);
                }
                DatabaseAdapter dba = this.stmt.getDatabaseAdapter();
                RegularExpressionConverter converter = new RegularExpressionConverter(dba.getPatternExpressionZeroMoreCharacters().charAt(0), dba.getPatternExpressionAnyCharacter().charAt(0), dba.getEscapeCharacter().charAt(0));
                if (caseSensitive) {
                    SQLExpression patternExpr = this.exprFactory.newLiteral(this.stmt, argExpr.getJavaTypeMapping(), converter.convert(pattern).toLowerCase());
                    return this.getBooleanLikeExpression(expr.invoke("toLowerCase", null), patternExpr, escapeExpr);
                }
                SQLExpression patternExpr = this.exprFactory.newLiteral(this.stmt, argExpr.getJavaTypeMapping(), converter.convert(pattern));
                return this.getBooleanLikeExpression(expr, patternExpr, escapeExpr);
            }
            SQLExpression patternExpr = this.exprFactory.newLiteral(this.stmt, argExpr.getJavaTypeMapping(), pattern);
            return this.getBooleanLikeExpression(expr, patternExpr, escapeExpr);
        }
        if (expr instanceof StringExpression) {
            return this.getExpressionForStringExpressionInput(expr, argExpr, escapeExpr);
        }
        throw new NucleusException(LOCALISER.msg("060001", (Object)"matches", (Object)expr));
    }

    protected BooleanExpression getExpressionForStringExpressionInput(SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        BooleanExpression likeExpr = this.getBooleanLikeExpression(expr, regExpr, escapeExpr);
        return likeExpr;
    }

    protected BooleanExpression getBooleanLikeExpression(SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        BooleanExpression likeExpr = new BooleanExpression(this.stmt, this.exprFactory.getMappingForType(Boolean.TYPE, false));
        SQLText sql = likeExpr.toSQLText();
        sql.clearStatement();
        if (Expression.OP_LIKE.isHigherThanLeftSide(expr.getLowestOperator())) {
            sql.append("(").append(expr).append(")");
        } else {
            sql.append(expr);
        }
        sql.append(" LIKE ");
        if (Expression.OP_LIKE.isHigherThanRightSide(regExpr.getLowestOperator())) {
            sql.append("(").append(regExpr).append(")");
        } else {
            sql.append(regExpr);
        }
        DatabaseAdapter dba = (DatabaseAdapter)this.stmt.getRDBMSManager().getDatastoreAdapter();
        if (escapeExpr != null) {
            if (escapeExpr instanceof CharacterLiteral) {
                String chr = "" + ((CharacterLiteral)escapeExpr).getValue();
                if (chr.equals(dba.getEscapeCharacter())) {
                    sql.append(dba.getEscapePatternExpression());
                } else {
                    sql.append(" ESCAPE " + escapeExpr);
                }
            } else {
                sql.append(" ESCAPE " + escapeExpr);
            }
        } else {
            sql.append(" " + dba.getEscapePatternExpression());
        }
        return likeExpr;
    }
}

