/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.valuegenerator.SequenceTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTool {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private String apiName = "JDO";
    private String ddlFilename = null;
    private boolean completeDdl = false;
    private boolean verbose = false;
    public static final int SCHEMATOOL_CREATE_MODE = 1;
    public static final int SCHEMATOOL_DELETE_MODE = 2;
    public static final int SCHEMATOOL_VALIDATE_MODE = 3;
    public static final int SCHEMATOOL_DATABASE_INFO_MODE = 4;
    public static final int SCHEMATOOL_SCHEMA_INFO_MODE = 5;
    public static NucleusLogger LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.SchemaTool");

    public static void main(String[] args) throws Exception {
        String ddlFilename;
        SchemaTool tool = new SchemaTool();
        CommandLine cmd = new CommandLine();
        cmd.addOption("create", "create", null, LOCALISER.msg(false, "014026"));
        cmd.addOption("delete", "delete", null, LOCALISER.msg(false, "014027"));
        cmd.addOption("validate", "validate", null, LOCALISER.msg(false, "014028"));
        cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg(false, "014029"));
        cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg(false, "014030"));
        cmd.addOption("help", "help", null, LOCALISER.msg(false, "014033"));
        cmd.addOption("ddlFile", "ddlFile", "ddlFile", LOCALISER.msg(false, "014031"));
        cmd.addOption("completeDdl", "completeDdl", null, LOCALISER.msg(false, "014032"));
        cmd.addOption("api", "api", "api", "API Adapter (JDO, JPA, etc)");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("pu", "persistenceUnit", "<persistence-unit>", "name of the persistence unit to handle the schema for");
        cmd.addOption("props", "properties", "props", "path to a properties file");
        cmd.parse(args);
        String[] filenames = cmd.getDefaultArgs();
        if (cmd.hasOption("api")) {
            tool.setApi(cmd.getOptionArg("api"));
        }
        String msg = null;
        int mode = 1;
        if (cmd.hasOption("create")) {
            mode = 1;
            msg = LOCALISER.msg(false, "014000", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        } else if (cmd.hasOption("delete")) {
            mode = 2;
            msg = LOCALISER.msg(false, "014001", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        } else if (cmd.hasOption("validate")) {
            mode = 3;
            msg = LOCALISER.msg(false, "014002", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        } else if (cmd.hasOption("dbinfo")) {
            mode = 4;
            msg = LOCALISER.msg(false, "014003", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        } else if (cmd.hasOption("schemainfo")) {
            mode = 5;
            msg = LOCALISER.msg(false, "014004", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        } else if (cmd.hasOption("help")) {
            System.out.println(LOCALISER.msg(false, "014023"));
            System.out.println(LOCALISER.msg(false, "014024"));
            System.out.println(LOCALISER.msg(false, "014025"));
            System.out.println(cmd.toString());
            System.out.println(LOCALISER.msg(false, "014034"));
            System.out.println(LOCALISER.msg(false, "014035"));
            System.exit(0);
        }
        LOGGER.info((Object)msg);
        System.out.println(msg);
        String propsFileName = null;
        String persistenceUnitName = null;
        if (cmd.hasOption("ddlFile")) {
            tool.setDdlFile(cmd.getOptionArg("ddlFile"));
        }
        if (cmd.hasOption("completeDdl")) {
            tool.setCompleteDdl(true);
        }
        if (cmd.hasOption("v")) {
            tool.setVerbose(true);
        }
        if (cmd.hasOption("pu")) {
            persistenceUnitName = cmd.getOptionArg("pu");
        }
        if (cmd.hasOption("props")) {
            propsFileName = cmd.getOptionArg("props");
        }
        msg = LOCALISER.msg(false, "014005");
        LOGGER.info((Object)msg);
        if (tool.isVerbose()) {
            System.out.println(msg);
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            msg = LOCALISER.msg(false, "014006", (Object)tokeniser.nextToken());
            LOGGER.info((Object)msg);
            if (!tool.isVerbose()) continue;
            System.out.println(msg);
        }
        if (tool.isVerbose()) {
            System.out.println();
        }
        if ((ddlFilename = tool.getDdlFile()) != null) {
            msg = LOCALISER.msg(false, tool.getCompleteDdl() ? "014018" : "014019", (Object)ddlFilename);
            LOGGER.info((Object)msg);
            if (tool.isVerbose()) {
                System.out.println(msg);
                System.out.println();
            }
        }
        boolean requiresAutoStartTable = false;
        JDOPersistenceManagerFactory pmf = null;
        try {
            if (propsFileName != null) {
                Properties props = PersistenceUtils.setPropertiesUsingFile((String)propsFileName);
                String autostart = props.getProperty("datanucleus.autoStartMechanism");
                if (autostart != null && autostart.equalsIgnoreCase("SchemaTable")) {
                    requiresAutoStartTable = true;
                }
                pmf = SchemaTool.getPMFForMode(mode, tool.getApi(), props, persistenceUnitName, ddlFilename, tool.isVerbose());
            } else {
                pmf = SchemaTool.getPMFForMode(mode, tool.getApi(), null, persistenceUnitName, ddlFilename, tool.isVerbose());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error creating PMF", (Throwable)e);
            System.out.println(LOCALISER.msg(false, "014008", (Object)e.getMessage()));
            System.exit(1);
            return;
        }
        TreeSet<String> classNames = null;
        if (mode != 5 && mode != 4) {
            try {
                MetaDataManager metaDataMgr = pmf.getOMFContext().getMetaDataManager();
                ClassLoaderResolver clr = pmf.getOMFContext().getClassLoaderResolver(null);
                FileMetaData[] filemds = SchemaTool.getFileMetaDataForInput(metaDataMgr, clr, tool.isVerbose(), persistenceUnitName, filenames);
                classNames = new TreeSet<String>();
                if (filemds == null) {
                    msg = LOCALISER.msg(false, "014021");
                    LOGGER.error((Object)msg);
                    System.out.println(msg);
                    System.exit(2);
                    return;
                }
                for (int i = 0; i < filemds.length; ++i) {
                    for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                        for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                            String className = filemds[i].getPackage(j).getClass(k).getFullClassName();
                            if (classNames.contains(className)) continue;
                            classNames.add(className);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.exit(2);
                return;
            }
        }
        try {
            StoreManager srm;
            if (mode == 1) {
                tool.createSchema(pmf, classNames, requiresAutoStartTable);
            } else if (mode == 2) {
                tool.deleteSchema(pmf, classNames);
            } else if (mode == 3) {
                tool.validateSchema(pmf, classNames);
            } else if (mode == 4) {
                srm = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.printInformation("DATASTORE", System.out);
            } else if (mode == 5) {
                srm = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.printInformation("SCHEMA", System.out);
            }
            msg = LOCALISER.msg(false, "014043");
            LOGGER.info((Object)msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            msg = LOCALISER.msg(false, "014037", (Object)e.getMessage());
            System.out.println(msg);
            LOGGER.error((Object)msg, (Throwable)e);
            System.exit(2);
            return;
        }
    }

    protected static JDOPersistenceManagerFactory getPMFForMode(int mode, String api, Map userProps, String persistenceUnitName, String ddlFile, boolean verbose) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (persistenceUnitName != null) {
            props.put("javax.jdo.option.PersistenceUnitName", persistenceUnitName);
        }
        if (userProps != null) {
            props.putAll(userProps);
        } else {
            String[] propNames = new String[]{"datanucleus.ConnectionURL", "datanucleus.ConnectionDriverName", "datanucleus.ConnectionUserName", "datanucleus.ConnectionPassword", "datanucleus.Mapping", "javax.jdo.option.ConnectionURL", "javax.jdo.option.ConnectionDriverName", "javax.jdo.option.ConnectionUserName", "javax.jdo.option.ConnectionPassword", "javax.jdo.option.Mapping"};
            for (int i = 0; i < propNames.length; ++i) {
                if (System.getProperty(propNames[i]) == null) continue;
                props.put(propNames[i], System.getProperty(propNames[i]));
            }
            if (persistenceUnitName == null && props.get("javax.jdo.option.ConnectionURL") == null && props.get("datanucleus.ConnectionURL") == null && props.get("javax.persistence.jdbc.url") == null) {
                File file = new File(System.getProperty("user.home") + "/datanucleus.properties");
                if (file.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        Properties fileProps = new Properties();
                        fileProps.load(is);
                        props.putAll(fileProps);
                        ((InputStream)is).close();
                    }
                    catch (IOException ioe) {}
                } else {
                    throw new NucleusException(LOCALISER.msg("014041"));
                }
            }
        }
        props.put("javax.jdo.PersistenceManagerFactoryClass", JDOPersistenceManagerFactory.class.getName());
        props.put("datanucleus.persistenceApiName", api);
        props.put("datanucleus.autostartmechanism", "None");
        if (mode == 1) {
            if (ddlFile != null) {
                props.put("datanucleus.validateconstraints", "false");
                props.put("datanucleus.validatecolumns", "false");
                props.put("datanucleus.validatetables", "false");
            }
            props.put("datanucleus.autocreateschema", "true");
            props.put("datanucleus.autocreatetables", "true");
            props.put("datanucleus.autocreateconstraints", "true");
            props.put("datanucleus.fixeddatastore", "false");
            props.put("datanucleus.readOnlydatastore", "false");
            props.put("datanucleus.rdbms.checkexisttablesorviews", "true");
        } else if (mode == 2) {
            props.put("datanucleus.fixeddatastore", "false");
            props.put("datanucleus.readonlydatastore", "false");
        } else if (mode == 3) {
            props.put("datanucleus.autocreateschema", "false");
            props.put("datanucleus.autocreatetables", "false");
            props.put("datanucleus.autocreateconstraints", "false");
            props.put("datanucleus.autocreatecolumns", "false");
            props.put("datanucleus.validatetables", "true");
            props.put("datanucleus.validatecolumns", "true");
            props.put("datanucleus.validateconstraints", "true");
        }
        JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(props);
        if (verbose) {
            String msg = LOCALISER.msg(false, "014020");
            LOGGER.info((Object)msg);
            System.out.println(msg);
            Map pmfProps = pmf.getConfiguration().getPersistenceProperties();
            Set keys = pmfProps.keySet();
            ArrayList keyNames = new ArrayList(keys);
            Collections.sort(keyNames);
            for (String key : keyNames) {
                Object value = pmfProps.get(key);
                boolean display = true;
                if (!key.startsWith("datanucleus")) {
                    display = false;
                } else if (key.equals("datanucleus.connectionpassword")) {
                    display = false;
                } else if (value == null) {
                    display = false;
                } else if (value instanceof String && StringUtils.isWhitespace((String)((String)value))) {
                    display = false;
                }
                if (!display) continue;
                msg = LOCALISER.msg(false, "014022", (Object)key, value);
                LOGGER.info((Object)msg);
                System.out.println(msg);
            }
            System.out.println();
        }
        return pmf;
    }

    protected static FileMetaData[] getFileMetaDataForInput(MetaDataManager metaDataMgr, ClassLoaderResolver clr, boolean verbose, String persistenceUnitName, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        if (inputFiles == null && persistenceUnitName == null) {
            msg = LOCALISER.msg(false, "014007");
            LOGGER.error((Object)msg);
            System.out.println(msg);
            throw new NucleusUserException(msg);
        }
        if (persistenceUnitName != null) {
            msg = LOCALISER.msg(false, "014015", (Object)persistenceUnitName);
            LOGGER.info((Object)msg);
            if (verbose) {
                System.out.println(msg);
                System.out.println();
            }
            filemds = metaDataMgr.getFileMetaData();
        } else {
            msg = LOCALISER.msg(false, "014009");
            LOGGER.info((Object)msg);
            if (verbose) {
                System.out.println(msg);
            }
            for (int i = 0; i < inputFiles.length; ++i) {
                String entry = LOCALISER.msg(false, "014010", (Object)inputFiles[i]);
                LOGGER.info((Object)entry);
                if (!verbose) continue;
                System.out.println(entry);
            }
            if (verbose) {
                System.out.println();
            }
            try {
                int i;
                LOGGER.debug((Object)LOCALISER.msg(false, "014011", (Object)("" + inputFiles.length)));
                HashSet<String> metadataFiles = new HashSet<String>();
                HashSet<String> classNames = new HashSet<String>();
                for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                    if (inputFiles[i2].endsWith(".class")) {
                        URL classFileURL = null;
                        try {
                            classFileURL = new URL("file:" + inputFiles[i2]);
                        }
                        catch (Exception e) {
                            msg = LOCALISER.msg(false, "014013", (Object)inputFiles[i2]);
                            LOGGER.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                        String className = ClassUtils.getClassNameForFileURL((URL)classFileURL);
                        classNames.add(className);
                        continue;
                    }
                    metadataFiles.add(inputFiles[i2]);
                }
                FileMetaData[] filemds1 = metaDataMgr.loadMetadataFiles(metadataFiles.toArray(new String[metadataFiles.size()]), null);
                FileMetaData[] filemds2 = metaDataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), null);
                filemds = new FileMetaData[filemds1.length + filemds2.length];
                int pos = 0;
                for (i = 0; i < filemds1.length; ++i) {
                    filemds[pos++] = filemds1[i];
                }
                for (i = 0; i < filemds2.length; ++i) {
                    filemds[pos++] = filemds2[i];
                }
                LOGGER.debug((Object)LOCALISER.msg(false, "014012", (Object)("" + inputFiles.length)));
            }
            catch (Exception e) {
                msg = LOCALISER.msg(false, "014014", (Object)e.getMessage());
                LOGGER.error((Object)msg, (Throwable)e);
                System.out.println(msg);
                if (e instanceof NucleusException) {
                    throw (NucleusException)((Object)e);
                }
                throw new NucleusUserException(msg, (Throwable)e);
            }
        }
        return filemds;
    }

    protected static Set<String> cleanInputClassNames(JDOPersistenceManagerFactory pmf, Set<String> inputClassNames) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (inputClassNames == null || inputClassNames.size() == 0) {
            MetaDataManager mmgr = pmf.getOMFContext().getMetaDataManager();
            Collection classesWithMetadata = mmgr.getClassesWithMetaData();
            classNames.addAll(classesWithMetadata);
        } else {
            classNames.addAll(inputClassNames);
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(JDOPersistenceManagerFactory pmf, Set<String> inputClassNames, boolean autoStart) throws Exception {
        Set<String> classNames = SchemaTool.cleanInputClassNames(pmf, inputClassNames);
        if (classNames.size() > 0) {
            ExecutionContext ec = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getExecutionContext();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)ec.getStoreManager();
            OutputStreamWriter ddlFileWriter = null;
            String ddlFilename = this.getDdlFile();
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (version " + ObjectManagerFactoryImpl.getVersionNumber() + ")" + " ran at " + fmt.format(new Date()) + "\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                if (this.getCompleteDdl()) {
                    ddlFileWriter.write("-- Complete schema required for the following classes:-\n");
                } else {
                    ddlFileWriter.write("-- Schema diff for " + pmf.getConnectionURL() + " and the following classes:-\n");
                }
                Iterator<String> classNameIter = classNames.iterator();
                while (classNameIter.hasNext()) {
                    ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                }
                ddlFileWriter.write("--\n");
            }
            try {
                String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                storeMgr.addClassesForSchemaTool(classNameArray, clr, ddlFileWriter, this.getCompleteDdl(), autoStart);
                if (ddlFileWriter != null) {
                    try {
                        ddlFileWriter.write("\n");
                        ddlFileWriter.write("------------------------------------------------------------------\n");
                        ddlFileWriter.write("-- Sequences and SequenceTables\n");
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.createSchemaSequences(pmf, classNames, clr, (FileWriter)ddlFileWriter);
            }
            finally {
                if (ddlFileWriter != null) {
                    ddlFileWriter.close();
                }
            }
        }
        String msg = LOCALISER.msg(false, "014039");
        LOGGER.error((Object)msg);
        System.out.println(msg);
        throw new Exception(msg);
    }

    protected void createSchemaSequences(JDOPersistenceManagerFactory pmf, Set<String> classNames, ClassLoaderResolver clr, FileWriter ddlWriter) {
        RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)pmf.getOMFContext().getStoreManager();
        if (classNames != null && classNames.size() > 0) {
            HashSet<String> seqTablesGenerated = new HashSet<String>();
            HashSet<String> sequencesGenerated = new HashSet<String>();
            for (String className : classNames) {
                AbstractClassMetaData cmd = rdbmsMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.getIdentityMetaData() != null && cmd.getIdentityMetaData().getValueStrategy() != null) {
                    if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)cmd.getIdentityMetaData(), rdbmsMgr, clr, seqTablesGenerated);
                    } else if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.SEQUENCE) {
                        String seqName = cmd.getIdentityMetaData().getSequence();
                        if (StringUtils.isWhitespace((String)seqName)) {
                            seqName = cmd.getIdentityMetaData().getValueGeneratorName();
                        }
                        if (!StringUtils.isWhitespace((String)seqName)) {
                            this.addSequenceForMetaData((MetaData)cmd.getIdentityMetaData(), seqName, rdbmsMgr, clr, sequencesGenerated, ddlWriter);
                        }
                    }
                }
                AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
                for (int j = 0; j < mmds.length; ++j) {
                    IdentityStrategy str = mmds[j].getValueStrategy();
                    if (str == IdentityStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)mmds[j], rdbmsMgr, clr, seqTablesGenerated);
                        continue;
                    }
                    if (str != IdentityStrategy.SEQUENCE) continue;
                    String seqName = mmds[j].getSequence();
                    if (StringUtils.isWhitespace((String)seqName)) {
                        seqName = mmds[j].getValueGeneratorName();
                    }
                    if (StringUtils.isWhitespace((String)seqName)) continue;
                    this.addSequenceForMetaData((MetaData)mmds[j], seqName, rdbmsMgr, clr, sequencesGenerated, ddlWriter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceTableForMetaData(MetaData md, RDBMSStoreManager rdbmsMgr, ClassLoaderResolver clr, Set<String> seqTablesGenerated) {
        String catName = null;
        String schName = null;
        String tableName = "SEQUENCE_TABLE";
        String seqColName = "SEQUENCE_NAME";
        String nextValColName = "NEXT_VAL";
        if (md.hasExtension("sequence-catalog-name")) {
            catName = md.getValueForExtension("sequence-catalog-name");
        }
        if (md.hasExtension("sequence-schema-name")) {
            schName = md.getValueForExtension("sequence-schema-name");
        }
        if (md.hasExtension("sequence-table-name")) {
            tableName = md.getValueForExtension("sequence-table-name");
        }
        if (md.hasExtension("sequence-name-column-name")) {
            seqColName = md.getValueForExtension("sequence-name-column-name");
        }
        if (md.hasExtension("sequence-nextval-column-name")) {
            nextValColName = md.getValueForExtension("sequence-nextval-column-name");
        }
        if (!seqTablesGenerated.contains(tableName)) {
            ManagedConnection mconn = rdbmsMgr.getConnection(0);
            Connection conn = (Connection)mconn.getConnection();
            try {
                DatastoreIdentifier tableIdentifier = rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(tableName);
                if (catName != null) {
                    tableIdentifier.setCatalogName(catName);
                }
                if (schName != null) {
                    tableIdentifier.setSchemaName(schName);
                }
                SequenceTable seqTable = new SequenceTable(tableIdentifier, rdbmsMgr, seqColName, nextValColName);
                seqTable.initialize(clr);
                seqTable.exists(conn, true);
            }
            catch (Exception e) {
            }
            finally {
                mconn.close();
            }
            seqTablesGenerated.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceForMetaData(MetaData md, String seq, RDBMSStoreManager rdbmsMgr, ClassLoaderResolver clr, Set<String> sequencesGenerated, FileWriter ddlWriter) {
        String seqName = seq;
        Integer min = null;
        Integer max = null;
        Integer start = null;
        Integer increment = null;
        Integer cacheSize = null;
        SequenceMetaData seqmd = rdbmsMgr.getMetaDataManager().getMetaDataForSequence(clr, seq);
        if (seqmd != null) {
            seqName = seqmd.getDatastoreSequence();
            if (seqmd.getAllocationSize() > 0) {
                increment = new Integer(seqmd.getAllocationSize());
            }
            if (seqmd.getInitialValue() >= 0) {
                start = new Integer(seqmd.getInitialValue());
            }
            md = seqmd;
        }
        if (md.hasExtension("key-min-value")) {
            min = Integer.valueOf(md.getValueForExtension("key-min-value"));
        }
        if (md.hasExtension("key-max-value")) {
            max = Integer.valueOf(md.getValueForExtension("key-max-value"));
        }
        if (md.hasExtension("key-increment-by")) {
            increment = Integer.valueOf(md.getValueForExtension("key-increment-by"));
        }
        if (md.hasExtension("key-start-with")) {
            start = Integer.valueOf(md.getValueForExtension("key-start-with"));
        }
        if (md.hasExtension("key-database-cache-size")) {
            cacheSize = Integer.valueOf(md.getValueForExtension("key-database-cache-size"));
        }
        if (!sequencesGenerated.contains(seqName)) {
            String stmt = ((RDBMSAdapter)rdbmsMgr.getDatastoreAdapter()).getSequenceCreateStmt(seqName, min, max, start, increment, cacheSize);
            if (ddlWriter != null) {
                try {
                    ddlWriter.write(stmt + ";\n");
                }
                catch (IOException ioe) {}
            } else {
                SQLController sqlController = rdbmsMgr.getSQLController();
                PreparedStatement ps = null;
                ManagedConnection mconn = rdbmsMgr.getConnection(0);
                try {
                    ps = sqlController.getStatementForUpdate(mconn, stmt, false);
                    sqlController.executeStatementUpdate(mconn, stmt, ps, true);
                }
                catch (SQLException e) {
                }
                finally {
                    try {
                        if (ps != null) {
                            sqlController.closeStatement(mconn, ps);
                        }
                    }
                    catch (SQLException e) {}
                    mconn.close();
                }
            }
            sequencesGenerated.add(seqName);
        }
    }

    public void deleteSchema(JDOPersistenceManagerFactory pmf, Set<String> inputClassNames) throws Exception {
        Set<String> classNames = SchemaTool.cleanInputClassNames(pmf, inputClassNames);
        if (classNames.size() <= 0) {
            String msg = LOCALISER.msg(false, "014039");
            LOGGER.info((Object)msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ExecutionContext ec = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getExecutionContext();
        StoreManager storeMgr = ec.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, ec.getClassLoaderResolver());
        storeMgr.removeAllClasses(ec.getClassLoaderResolver());
    }

    public void validateSchema(JDOPersistenceManagerFactory pmf, Set<String> inputClassNames) throws Exception {
        Set<String> classNames = SchemaTool.cleanInputClassNames(pmf, inputClassNames);
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg(false, "014039");
            LOGGER.error((Object)msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ExecutionContext ec = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getExecutionContext();
        StoreManager storeMgr = ec.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, ec.getClassLoaderResolver());
    }

    public String getApi() {
        return this.apiName;
    }

    public SchemaTool setApi(String api) {
        this.apiName = api;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public SchemaTool setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getDdlFile() {
        return this.ddlFilename;
    }

    public SchemaTool setDdlFile(String file) {
        this.ddlFilename = file;
        return this;
    }

    public SchemaTool setCompleteDdl(boolean completeDdl) {
        this.completeDdl = completeDdl;
        return this;
    }

    public boolean getCompleteDdl() {
        return this.completeDdl;
    }
}

