/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.HSQLTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class HSQLAdapter
extends DatabaseAdapter {
    public HSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.remove("GetGeneratedKeysStatement");
        this.supportedOptions.remove("StatementBatching");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("CheckInCreateStatements");
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion == 7 && this.datastoreRevisionVersion < 2) {
            this.supportedOptions.remove("CheckInEndCreateStatements");
        } else {
            this.supportedOptions.add("CheckInEndCreateStatements");
        }
        this.supportedOptions.remove("AccessParentQueryInSubquery");
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7) {
            this.supportedOptions.remove("FkDeleteActionCascade");
            this.supportedOptions.remove("FkDeleteActionRestrict");
            this.supportedOptions.remove("FkDeleteActionDefault");
            this.supportedOptions.remove("FkDeleteActionNull");
            this.supportedOptions.remove("FkUpdateActionCascade");
            this.supportedOptions.remove("FkUpdateActionRestrict");
            this.supportedOptions.remove("FkUpdateActionDefault");
            this.supportedOptions.remove("FkUpdateActionNull");
        } else {
            this.supportedOptions.remove("FkDeleteActionRestrict");
            this.supportedOptions.remove("FkUpdateActionRestrict");
        }
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLTypeInfo sqlType2 = new HSQLTypeInfo("LONGVARCHAR", 2005, Integer.MAX_VALUE, "'", "'", null, 1, true, 3, false, false, false, "LONGVARCHAR", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType2, true);
        sqlType2 = new HSQLTypeInfo("LONGVARBINARY", 2004, Integer.MAX_VALUE, "'", "'", null, 1, false, 3, false, false, false, "LONGVARBINARY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType2, true);
        Collection<SQLTypeInfo> sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2004);
        if (sqlTypes != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2005);
        if (sqlType2 != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)-4)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)-1)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
    }

    public String getVendorID() {
        return "hsql";
    }

    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return 128;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return 128;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 128;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getRangeByLimitEndOfStatementClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 9223372036854775807 OFFSET " + offset + " ";
        }
        return "";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new HSQLTypeInfo(rs);
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return "";
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (null)";
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return datatype != 2004 && datatype != 2005 && datatype != -4 && datatype != 1111 && datatype != -1;
    }

    public String getDatastoreDateStatement() {
        return "CALL NOW()";
    }

    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null) {
            stmt.append(" START WITH " + min);
        } else if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (max != null) {
            throw new NucleusUserException(LOCALISER.msg("051022"));
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null) {
            throw new NucleusUserException(LOCALISER.msg("051023"));
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CALL NEXT VALUE FOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public StringExpression trimMethod(StringExpression str, boolean leading, boolean trailing) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        if (leading && trailing) {
            StringExpression strExpr = new StringExpression("RTRIM", args);
            args.clear();
            args.add(strExpr);
            return new StringExpression("LTRIM", args);
        }
        if (leading) {
            return new StringExpression("LTRIM", args);
        }
        if (trailing) {
            return new StringExpression("RTRIM", args);
        }
        return str;
    }
}

