/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.NucleusLogger;

public class JDOHelperGetVersionMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression ignore, List args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getVersion without an argument");
        }
        SQLExpression expr = (SQLExpression)args.get(0);
        if (expr == null) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getVersion on null expression");
        }
        if (expr instanceof SQLLiteral) {
            RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
            ApiAdapter api = storeMgr.getApiAdapter();
            Object obj = ((SQLLiteral)((Object)expr)).getValue();
            if (obj == null || !api.isPersistable(obj)) {
                return new NullLiteral(this.stmt, null, null, null);
            }
            Object ver = this.stmt.getRDBMSManager().getApiAdapter().getVersionForObject(obj);
            JavaTypeMapping m = this.getMappingForClass(ver.getClass());
            return new ObjectLiteral(this.stmt, m, ver, null);
        }
        if (ObjectExpression.class.isAssignableFrom(expr.getClass())) {
            if (((ObjectExpression)expr).getJavaTypeMapping() instanceof PersistableMapping) {
                NucleusLogger.QUERY.info((Object)(">> JDOHelper.getVersion for " + expr + " table=" + expr.getSQLTable() + " mapping=" + expr.getJavaTypeMapping()));
                throw new NucleusUserException("Dont currently support JDOHelper.getVersion(ObjectExpression)");
            }
            return expr;
        }
        throw new IllegalExpressionOperationException("JDOHelper.getVersion", expr);
    }
}

