/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.oracle.OracleClobRDBMSMapping;

public class OracleStringMapping
extends StringMapping
implements MappingCallbacks {
    public void insertPostProcessing(StateManager sm) {
        String value = (String)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            value = "";
        } else if (value.length() == 0) {
            value = this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull") ? "" : ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getSurrogateForEmptyStrings();
        }
        if (this.mmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("BLOB")) {
            OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDatastoreMapping(0), value.getBytes());
        } else if (this.mmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("CLOB")) {
            OracleClobRDBMSMapping.updateClobColumn(sm, this.getDatastoreContainer(), this.getDatastoreMapping(0), value);
        } else {
            throw new NucleusException("AssertionError: Only JDBC types BLOB and CLOB are allowed!");
        }
    }

    public void postInsert(StateManager sm) {
    }

    public void postFetch(StateManager sm) {
    }

    public void postUpdate(StateManager sm) {
        this.insertPostProcessing(sm);
    }

    public void preDelete(StateManager sm) {
    }
}

