/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store.rdbms.query.legacy;

import java.util.HashSet;
import java.util.Iterator;

import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.Extent;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;

/**
 * Wrapper to generate an extent using legacy classes.
 */
public class ExtentHelper
{
    @SuppressWarnings("deprecation")
    public static Extent getExtent(RDBMSStoreManager storeMgr, Class c, boolean subclasses, ObjectManager om)
    {
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent())
        {
            throw new NoExtentException(c.getName());
        }

        DatastoreClass t = storeMgr.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE)
        {
            // "complete-table" may imply many tables not discoverable from the root table
            HashSet<DatastoreClass> candidateTables = new HashSet();
            if (t != null)
            {
                candidateTables.add(t);
            }
            if (subclasses)
            {
                HashSet<String> subclassNames = 
                    storeMgr.getSubClassesForClass(cmd.getFullClassName(), subclasses, om.getClassLoaderResolver());
                if (subclassNames != null)
                {
                    Iterator<String> subclassIter = subclassNames.iterator();
                    while (subclassIter.hasNext())
                    {
                        String subclassName = subclassIter.next();
                        DatastoreClass tbl = storeMgr.getDatastoreClass(subclassName, om.getClassLoaderResolver());
                        if (tbl != null)
                        {
                            candidateTables.add(tbl);
                        }
                    }
                }
            }
            return new org.datanucleus.store.rdbms.query.legacy.ClassTableExtent(om,
                candidateTables.toArray(new DatastoreClass[candidateTables.size()]), c, subclasses, cmd);
        }
        else
        {
            // "new-table", "superclass-table", "subclass-table"
            if (t instanceof ClassView)
            {
                return new org.datanucleus.store.rdbms.query.legacy.ClassViewExtent(om, t, c, subclasses, cmd);
            }
            else if (t instanceof ClassTable)
            {
                return new org.datanucleus.store.rdbms.query.legacy.ClassTableExtent(om, t, c, subclasses, cmd);
            }
            else
            {
                // No specific table, so either has no table, or multiple
                // This happens with the "subclass-table" inheritance strategy
                AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(cmd, om.getClassLoaderResolver());
                if (cmds != null && cmds.length > 0)
                {
                    DatastoreClass[] tables = new DatastoreClass[cmds.length];
                    for (int i=0;i<cmds.length;i++)
                    {
                        tables[i] = storeMgr.getDatastoreClass(cmds[i].getFullClassName(), om.getClassLoaderResolver());
                    }
                    return new org.datanucleus.store.rdbms.query.legacy.ClassTableExtent(om, tables, c, subclasses, cmd);
                }
                else
                {
                    throw new NucleusUserException("Attempt to create an Extent for class " + c.getName() +
                        " which has MetaData, yet no table was found! This should be impossible");
                }
            }
        }
    }
}
