/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.util.NucleusLogger;

public class MapContainsKeyMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"containsKey", (Object)"MapExpression", (Object)1));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression keyExpr = (SQLExpression)args.get(0);
        if (expr instanceof MapLiteral) {
            MapLiteral lit = (MapLiteral)expr;
            Map map = (Map)lit.getValue();
            if (map == null || map.size() == 0) {
                JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                return new BooleanLiteral(this.stmt, m, Boolean.FALSE, false);
            }
            MapLiteral.MapKeyLiteral mapKeyLiteral = lit.getKeyLiteral();
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = mapKeyLiteral.getKeyExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(keyExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(keyExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            Boolean hasNOT;
            boolean needsSubquery = false;
            Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
            if (hasOR != null && hasOR.booleanValue()) {
                needsSubquery = true;
            }
            if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
                needsSubquery = true;
            }
            if (needsSubquery) {
                NucleusLogger.QUERY.debug((Object)("MapContainsKey on " + mapExpr + "(" + keyExpr + ") using SUBQUERY"));
                return this.containsAsSubquery(mapExpr, keyExpr);
            }
            NucleusLogger.QUERY.debug((Object)("MapContainsKey on " + mapExpr + "(" + keyExpr + ") using INNERJOIN"));
            return this.containsAsInnerJoin(mapExpr, keyExpr);
        }
        return this.containsAsSubquery(mapExpr, keyExpr);
    }

    protected SQLExpression containsAsInnerJoin(MapExpression mapExpr, SQLExpression keyExpr) {
        AbstractClassMetaData keyCmd;
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            MapTable mapTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
            SQLTable joinSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping(), mapTbl, null, mapTbl.getOwnerMapping(), null, null);
            AbstractClassMetaData keyCmd2 = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            if (keyCmd2 != null) {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd2.getFullClassName(), this.clr);
                SQLTable keySqlTbl = this.stmt.innerJoin(joinSqlTbl, mapTbl.getKeyMapping(), (DatastoreContainerObject)keyTbl, null, keyTbl.getIDMapping(), null, null);
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIDMapping());
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            } else {
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getKeyMapping());
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
            DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(mmd.getKeyMetaData().getMappedBy());
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, 5);
            SQLTable valSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping(), (DatastoreContainerObject)valTbl, null, ownerMapping, null, null);
            if (keyCmd != null) {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
                SQLTable keySqlTbl = this.stmt.innerJoin(valSqlTbl, valTbl.getMemberMapping(valKeyMmd), (DatastoreContainerObject)keyTbl, null, keyTbl.getIDMapping(), null, null);
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIDMapping());
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            } else {
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getMemberMapping(valKeyMmd));
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, 5);
            SQLTable keySqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping(), (DatastoreContainerObject)keyTbl, null, ownerMapping, null, null);
            SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIDMapping());
            this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(MapExpression mapExpr, SQLExpression keyExpr) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        MapTable joinTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
        SQLStatement subStmt = null;
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            if (mmd.getMap().getKeyClassMetaData(this.clr, mmgr) == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getKeyMapping());
                subStmt.whereAnd(elemIdExpr.eq(keyExpr), true);
            } else {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), keyTbl.getIDMapping(), joinTbl, null, joinTbl.getKeyMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIDMapping());
                subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
            DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
            JavaTypeMapping ownerMapping = valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy()));
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(mmd.getKeyMetaData().getMappedBy());
            if (mmd.getMap().getKeyClassMetaData(this.clr, mmgr) == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)valTbl, null, null);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                JavaTypeMapping keyMapping = valTbl.getMemberMapping(valKeyMmd);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
                subStmt.whereAnd(elemIdExpr.eq(keyExpr), true);
            } else {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable valSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), keyTbl.getIDMapping(), (DatastoreContainerObject)valTbl, null, valTbl.getMemberMapping(valKeyMmd), null, null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, valSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIDMapping());
                subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, 5);
            subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIDMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            JavaTypeMapping keyMapping = keyTbl.getIDMapping();
            SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
            subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }
}

