/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class CollectionSizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(LOCALISER.msg("060015", (Object)"size", (Object)"CollectionExpression"));
        }
        if (expr instanceof CollectionLiteral) {
            Collection coll = (Collection)((CollectionLiteral)expr).getValue();
            return this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), new Integer(coll.size()));
        }
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        String elementType = ownerMmd.getCollection().getElementType();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject collectionTbl = null;
        if (ownerMmd.getMappedBy() != null) {
            AbstractMemberMetaData elementMmd = ownerMmd.getRelatedMemberMetaData(clr)[0];
            if (ownerMmd.getJoinMetaData() != null || elementMmd.getJoinMetaData() != null) {
                collectionTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
                ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
            } else {
                collectionTbl = storeMgr.getDatastoreClass(elementType, clr);
                ownerMapping = collectionTbl.getMemberMapping(elementMmd);
            }
        } else if (ownerMmd.getJoinMetaData() != null) {
            collectionTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
            ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
        } else {
            collectionTbl = storeMgr.getDatastoreClass(elementType, clr);
            ownerMapping = ((DatastoreClass)collectionTbl).getExternalMapping(ownerMmd, 5);
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, collectionTbl, null, null);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = this.exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIDMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        return new NumericSubqueryExpression(this.stmt, subStmt);
    }
}

