/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class SQLExpressionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    RDBMSStoreManager storeMgr;
    ClassLoaderResolver clr;
    Map<String, String> expressionByMapping = new HashMap<String, String>();
    Map<String, String> literalByMapping = new HashMap<String, String>();
    Map<String, String> methodClassByDatastoreMethodName = new HashMap<String, String>();
    Map<String, String> operationClassByDatastoreOperationName = new HashMap<String, String>();
    Map<String, SQLMethod> methodByClassMethodName = new HashMap<String, SQLMethod>();
    Map<String, SQLOperation> operationByOperationName = new HashMap<String, SQLOperation>();
    Map<Class, JavaTypeMapping> mappingByClass = new HashMap<Class, JavaTypeMapping>();

    public SQLExpressionFactory(RDBMSStoreManager storeMgr) {
        String datastoreName;
        int e;
        ConfigurationElement[] elms;
        int i;
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        ExtensionPoint exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_expression");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                String mappingName = elms[e].getAttribute("mapping-class").trim();
                String expressionName = elms[e].getAttribute("expression-class").trim();
                String literalName = elms[e].getAttribute("literal-class").trim();
                this.expressionByMapping.put(mappingName, expressionName);
                this.literalByMapping.put(mappingName, literalName);
            }
        }
        exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_method");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                datastoreName = elms[e].getAttribute("datastore");
                String className = elms[e].getAttribute("class");
                String methodName = elms[e].getAttribute("method").trim();
                String sqlMethodName = elms[e].getAttribute("evaluator").trim();
                String key = this.getSQLMethodKey(datastoreName, className, methodName);
                this.methodClassByDatastoreMethodName.put(key, sqlMethodName);
            }
        }
        exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_operation");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                datastoreName = elms[e].getAttribute("datastore");
                String name = elms[e].getAttribute("name").trim();
                String sqlOperationName = elms[e].getAttribute("evaluator").trim();
                String key = this.getSQLOperationKey(datastoreName, name);
                this.operationClassByDatastoreOperationName.put(key, sqlOperationName);
            }
        }
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        String expressionClassName = this.expressionByMapping.get(mapping.getClass().getName());
        if (expressionClassName == null) {
            throw new NucleusException(LOCALISER.msg("060004", (Object)mapping.getClass().getName()));
        }
        SQLTable exprSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sqlTbl, mapping);
        try {
            Class exprCls = this.clr.classForName(expressionClassName);
            SQLExpression expr = (SQLExpression)ClassUtils.newInstance((Class)exprCls, (Class[])new Class[]{SQLStatement.class, SQLTable.class, JavaTypeMapping.class}, (Object[])new Object[]{stmt, exprSqlTbl, mapping});
            return expr;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060005", (Object)expressionClassName));
        }
    }

    public SQLExpression newLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        String literalClassName = null;
        if (mapping != null && (literalClassName = this.literalByMapping.get(mapping.getClass().getName())) == null) {
            throw new NucleusException(LOCALISER.msg("060006", (Object)mapping.getClass().getName()));
        }
        try {
            Class exprCls = null;
            exprCls = mapping == null ? NullLiteral.class : this.clr.classForName(literalClassName);
            SQLExpression expr = (SQLExpression)ClassUtils.newInstance((Class)exprCls, (Class[])new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, Boolean.TYPE}, (Object[])new Object[]{stmt, mapping, value, false});
            return expr;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060007", (Object)literalClassName));
        }
    }

    public SQLExpression newLiteralParameter(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        String literalClassName = null;
        if (mapping != null && (literalClassName = this.literalByMapping.get(mapping.getClass().getName())) == null) {
            throw new NucleusException(LOCALISER.msg("060006", (Object)mapping.getClass().getName()));
        }
        try {
            Class exprCls = null;
            exprCls = mapping == null ? ParameterLiteral.class : this.clr.classForName(literalClassName);
            SQLExpression expr = (SQLExpression)ClassUtils.newInstance((Class)exprCls, (Class[])new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, Boolean.TYPE}, (Object[])new Object[]{stmt, mapping, value, true});
            return expr;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060007", (Object)literalClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpression invokeMethod(SQLStatement stmt, String className, String methodName, SQLExpression expr, List args) {
        String classMethodKey = className != null ? className + "_" + methodName : methodName;
        SQLMethod method = this.methodByClassMethodName.get(classMethodKey);
        if (method != null) {
            SQLMethod sQLMethod = method;
            synchronized (sQLMethod) {
                method.setStatement(stmt);
                return method.getExpression(expr, args);
            }
        }
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLMethodKey(datastoreId, className, methodName);
        String sqlMethodClassName = this.methodClassByDatastoreMethodName.get(key);
        if (sqlMethodClassName == null && (sqlMethodClassName = this.methodClassByDatastoreMethodName.get(key = this.getSQLMethodKey(null, className, methodName))) == null) {
            if (className == null) {
                throw new NucleusException(LOCALISER.msg("060008", (Object)methodName, (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("060009", (Object)methodName));
        }
        try {
            SQLMethod sQLMethod = method = (SQLMethod)this.clr.classForName(sqlMethodClassName).newInstance();
            synchronized (sQLMethod) {
                method.setStatement(stmt);
                this.methodByClassMethodName.put(classMethodKey, method);
                return method.getExpression(expr, args);
            }
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060010", (Object)sqlMethodClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
    }

    public SQLExpression invokeOperation(String name, SQLExpression expr, SQLExpression expr2) {
        SQLOperation operation = this.operationByOperationName.get(name);
        if (operation != null) {
            return operation.getExpression(expr, expr2);
        }
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLOperationKey(datastoreId, name);
        String sqlOperationClassName = this.operationClassByDatastoreOperationName.get(key);
        if (sqlOperationClassName == null && (sqlOperationClassName = this.operationClassByDatastoreOperationName.get(key = this.getSQLOperationKey(null, name))) == null) {
            throw new NucleusException(LOCALISER.msg("060012", (Object)name));
        }
        try {
            operation = (SQLOperation)this.clr.classForName(sqlOperationClassName).newInstance();
            operation.setExpressionFactory(this);
            this.operationByOperationName.put(name, operation);
            return operation.getExpression(expr, expr2);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060013", (Object)sqlOperationClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
    }

    private String getSQLMethodKey(String datastoreName, String className, String methodName) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + (className != null ? className.trim() + "." : "") + methodName;
    }

    private String getSQLOperationKey(String datastoreName, String name) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + name;
    }

    public JavaTypeMapping getMappingForType(Class cls, boolean useCached) {
        JavaTypeMapping mapping = null;
        if (useCached && (mapping = this.mappingByClass.get(cls)) != null) {
            return mapping;
        }
        mapping = this.storeMgr.getMappingManager().getMappingWithDatastoreMapping(cls, false, false, this.clr);
        this.mappingByClass.put(cls, mapping);
        return mapping;
    }
}

