/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class TinyIntRDBMSMapping
extends RDBMSMapping {
    protected TinyIntRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TinyIntRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
        }
        this.initTypeInfo();
    }

    public boolean isIntegerBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSStoreManager)this.storeMgr).getSQLTypeInfoForJDBCType(-6);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block4: {
            try {
                int intValue = ((ResultSet)rs).getInt(param);
                if (intValue == 0) {
                    value = false;
                    break block4;
                }
                if (intValue == 1) {
                    value = true;
                    break block4;
                }
                throw new NucleusDataStoreException(LOCALISER.msg("055006", (Object)"Types.TINYINT", (Object)("" + intValue)));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                    ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value instanceof Byte) {
                ((PreparedStatement)ps).setInt(param, ((Byte)value).shortValue());
            } else if (value instanceof BigInteger) {
                ((PreparedStatement)ps).setInt(param, ((BigInteger)value).shortValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"Byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Byte value;
        try {
            byte b = ((ResultSet)rs).getByte(param);
            value = ((ResultSet)rs).wasNull() ? null : new Byte(b);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"Byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

