/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.Extent;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.AggregateExpression;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.ClassExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SubqueryExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.rdbms.query.legacy.CollectionCandidates;
import org.datanucleus.store.rdbms.query.legacy.Parser;
import org.datanucleus.store.rdbms.query.legacy.QueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.ResultExpressionsQueryable;
import org.datanucleus.util.Imports;
import org.datanucleus.util.StringUtils;

public class JDOQLQueryCompiler
extends QueryCompiler {
    protected boolean explicitParameters = false;
    protected boolean explicitVariables = false;
    protected int implicitParamNo = 0;
    protected Map subqueryParameters;
    protected boolean subqueryAliasSet = false;

    public JDOQLQueryCompiler(AbstractJDOQLQuery query, Imports imports, Map parameters) {
        super((Query)query, imports, parameters);
        this.language = "JDOQL";
    }

    public void processAsSubquery(QueryExpression parentExpr, String candidateExpression, Map paramMap) {
        this.parentExpr = parentExpr;
        this.subqueryCandidateExpr = candidateExpression;
        this.subqueryParameters = paramMap;
    }

    public Object compile(int type) {
        switch (type) {
            case 1: {
                this.compileExplicitParameters();
                ObjectManager om = this.query.getObjectManager();
                if (this.query.getExplicitParameters() != null && this.query.getExplicitParameters().length() > 0) {
                    this.explicitParameters = true;
                    if (this.parameters != null) {
                        boolean checkParamCount;
                        ApiAdapter api = om.getApiAdapter();
                        Boolean checkParamCountVal = this.query.getBooleanExtensionProperty("datanucleus.query.ignoreParameterCountCheck", false);
                        boolean bl = checkParamCount = checkParamCountVal != null ? checkParamCountVal : true;
                        if (checkParamCount && this.parameters.size() != this.parameterTypesByName.size()) {
                            throw new QueryInvalidParametersException(LOCALISER.msg("021108", (Object)("" + this.parameterTypesByName.size()), (Object)("" + this.parameters.size())));
                        }
                        for (Map.Entry entry : this.parameterTypesByName.entrySet()) {
                            ObjectManager valueOM;
                            Object key = entry.getKey();
                            Object value = this.parameters.get(key);
                            if (value == null) {
                                if (!((Class)entry.getValue()).isPrimitive()) continue;
                                throw new QueryInvalidParametersException(LOCALISER.msg("021109", entry.getKey(), (Object)((Class)entry.getValue()).getName()));
                            }
                            if (!api.isPersistable(value) || (valueOM = api.getObjectManager(value)) == null || om == valueOM) continue;
                            throw new NucleusUserException(LOCALISER.msg("021068", key));
                        }
                    }
                } else if (this.parameters != null) {
                    ApiAdapter api = om.getApiAdapter();
                    for (Map.Entry entry : this.parameters.entrySet()) {
                        ObjectManager valueOM;
                        Object value = entry.getValue();
                        if (!api.isPersistable(value) || (valueOM = api.getObjectManager(value)) == null || om == valueOM) continue;
                        throw new NucleusUserException(LOCALISER.msg("021068", value));
                    }
                }
                return null;
            }
            case 2: {
                this.compileExplicitVariables();
                if (this.query.getExplicitVariables() != null && this.query.getExplicitVariables().length() > 0) {
                    this.explicitVariables = true;
                }
                return null;
            }
            case 3: {
                this.compile(1);
                this.compile(2);
                this.preCompile();
                return null;
            }
            case 4: {
                this.compile(1);
                this.compile(2);
                return this.executionCompile();
            }
        }
        return super.compile(type);
    }

    protected void performCompile(QueryExpression qs) {
        if (this.parentExpr != null) {
            this.compileSubqueryCandidateExpression(true);
        }
        this.fieldExpressions.clear();
        this.compileResult(qs, this.query.getResult());
        ScalarExpression[] resultFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        for (int i = 0; i < resultFieldExprs.length; ++i) {
            if (resultFieldExprs[i].getLogicSetExpression() == null && resultFieldExprs[i] instanceof UnboundVariable) {
                throw new NucleusUserException(LOCALISER.msg("021049", (Object)((UnboundVariable)resultFieldExprs[i]).getVariableName()));
            }
            qs.crossJoin(resultFieldExprs[i].getLogicSetExpression(), true);
        }
        this.compileFilter(qs, this.query.getFilter());
        ScalarExpression[] groupingFieldExprs = null;
        String grouping = this.query.getGrouping();
        if (grouping != null && grouping.length() > 0) {
            this.fieldExpressions.clear();
            this.compileGrouping(qs, grouping);
            groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        }
        ScalarExpression[] havingFieldExprs = null;
        String having = this.query.getHaving();
        if (having != null && having.length() > 0) {
            this.fieldExpressions.clear();
            this.compileHaving(qs, having);
            havingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        }
        this.fieldExpressions.clear();
        this.compileOrdering(qs, this.query.getOrdering());
        ScalarExpression[] orderingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        if (groupingFieldExprs != null) {
            this.checkExpressionsAgainstGrouping(orderingFieldExprs, groupingFieldExprs, "021069");
            this.checkExpressionsAgainstGrouping(havingFieldExprs, groupingFieldExprs, "021071");
            this.checkExpressionsAgainstGrouping(resultFieldExprs, groupingFieldExprs, "021070");
        }
        this.compileRange(qs);
        this.checkVariableBinding();
    }

    protected void compileCandidates() {
        ObjectManager om = this.query.getObjectManager();
        if (this.parentExpr != null) {
            if (this.subqueryCandidateExpr != null) {
                if (this.query.getCandidateClassName() == null) {
                    Class candCls = this.getClassForSubqueryCandidateExpression();
                    this.query.setCandidateClassName(candCls.getName());
                }
            } else {
                String from = this.query.getFrom();
                if (from != null) {
                    if (from.indexOf(32) > 0) {
                        String candidateExpr = from.substring(0, from.indexOf(32)).trim();
                        if (candidateExpr.startsWith("this")) {
                            this.subqueryCandidateExpr = candidateExpr.trim();
                            Class cls = this.getClassForSubqueryCandidateExpression();
                            this.query.setCandidateClassName(cls.getName());
                        } else {
                            this.query.setCandidateClassName(candidateExpr);
                        }
                        this.candidateAlias = from.substring(from.indexOf(32) + 1).trim();
                        this.subqueryAliasSet = true;
                    } else if (from.startsWith("this")) {
                        this.subqueryCandidateExpr = from.trim();
                        Class cls = this.getClassForSubqueryCandidateExpression();
                        this.query.setCandidateClassName(cls.getName());
                    } else {
                        this.query.setCandidateClassName(from);
                    }
                }
            }
            if (this.candidateAlias.equals("this")) {
                this.candidateAlias = "SUB";
            }
        }
        String candidateClassName = this.query.getCandidateClassName();
        if (this.candidateClass == null && candidateClassName != null) {
            try {
                this.candidateClass = om.getClassLoaderResolver().classForName(candidateClassName, true);
            }
            catch (NucleusException jpe) {
                this.candidateClass = this.query.resolveClassDeclaration(candidateClassName);
            }
        }
        Extent candidateExtent = ((AbstractJavaQuery)this.query).getCandidateExtent();
        Collection candidateCollection = ((AbstractJavaQuery)this.query).getCandidateCollection();
        if (candidateExtent != null) {
            this.candidates = (Queryable)candidateExtent;
        } else if (candidateCollection != null) {
            this.candidates = new CollectionCandidates(om, this.candidateClass, candidateCollection);
        } else {
            if (this.candidateClass == null) {
                throw new NucleusUserException(LOCALISER.msg("042001"));
            }
            this.candidates = (Queryable)om.getExtent(this.candidateClass, this.query.isSubclasses());
        }
        String result = this.query.getResult();
        if (result != null) {
            this.candidates = candidateCollection != null ? new ResultExpressionsQueryable(om, this.candidateClass, ((CollectionCandidates)this.candidates).getUserCandidates(), this.query.isSubclasses()) : new ResultExpressionsQueryable(om, this.candidateClass, this.query.isSubclasses());
        }
    }

    protected Class getClassForSubqueryCandidateExpression() {
        if (this.subqueryCandidateExpr == null) {
            return null;
        }
        String[] tokens = StringUtils.split((String)this.subqueryCandidateExpr, (String)".");
        Class cls = this.parentExpr.getCandidateClass();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        MetaDataManager mmgr = this.query.getObjectManager().getMetaDataManager();
        AbstractClassMetaData cmd = mmgr.getMetaDataForClass(cls, clr);
        for (int i = 1; i < tokens.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(tokens[i]);
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2 || relationType == 1 || relationType == 6) {
                cls = mmd.getType();
            } else if (relationType == 3 || relationType == 4 || relationType == 5) {
                if (mmd.hasCollection()) {
                    cls = clr.classForName(mmd.getCollection().getElementType());
                } else if (mmd.hasMap()) {
                    cls = clr.classForName(mmd.getMap().getValueType());
                } else if (mmd.hasArray()) {
                    cls = clr.classForName(mmd.getArray().getElementType());
                }
            }
            if (i >= tokens.length - 1) continue;
            cmd = mmgr.getMetaDataForClass(cls, clr);
        }
        return cls;
    }

    private void compileOrdering(QueryExpression qs, String ordering) {
        if (ordering != null && ordering.length() > 0) {
            String[] exprs = QueryUtils.getExpressionsFromString((String)ordering);
            ScalarExpression[] orderExprs = new ScalarExpression[exprs.length];
            boolean[] descending = new boolean[exprs.length];
            for (int n = 0; n < exprs.length; ++n) {
                String orderExpression = exprs[n].trim();
                if (orderExpression.endsWith("ascending") || orderExpression.endsWith("ASCENDING")) {
                    descending[n] = false;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "ascending".length());
                } else if (orderExpression.endsWith("asc") || orderExpression.endsWith("ASC")) {
                    descending[n] = false;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "asc".length());
                } else if (orderExpression.endsWith("descending") || orderExpression.endsWith("DESCENDING")) {
                    descending[n] = true;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "descending".length());
                } else if (orderExpression.endsWith("desc") || orderExpression.endsWith("DESC")) {
                    descending[n] = true;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "desc".length());
                } else {
                    throw new NucleusUserException(LOCALISER.msg("042004", (Object)ordering));
                }
                orderExprs[n] = this.compileExpressionFromString(orderExpression);
            }
            if (qs != null) {
                qs.setOrdering(orderExprs, descending);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScalarExpression compileExpressionFromString(String str) {
        try {
            this.p = new Parser(str, this.imports);
            ScalarExpression expr = this.compileExpression();
            if (!this.p.parseEOS()) {
                throw new QueryCompilerSyntaxException(LOCALISER.msg("021054", (Object)this.language), this.p.getIndex(), this.p.getInput());
            }
            ScalarExpression scalarExpression = expr;
            return scalarExpression;
        }
        finally {
            this.p = null;
        }
    }

    protected ScalarExpression compileExpression() {
        return this.compileConditionalOrExpression();
    }

    private ScalarExpression compileConditionalOrExpression() {
        ScalarExpression expr = this.compileConditionalAndExpression();
        while (this.p.parseString("||")) {
            expr = expr.ior(this.compileConditionalAndExpression());
        }
        return expr;
    }

    private ScalarExpression compileConditionalAndExpression() {
        ScalarExpression expr = this.compileInclusiveOrExpression();
        while (this.p.parseString("&&")) {
            ScalarExpression otherExpr = this.compileInclusiveOrExpression();
            expr = expr.and(otherExpr);
        }
        return expr;
    }

    private ScalarExpression compileInclusiveOrExpression() {
        ScalarExpression expr = this.compileExclusiveOrExpression();
        while (this.p.parseChar('|', '|')) {
            expr = expr.ior(this.compileExclusiveOrExpression());
        }
        return expr;
    }

    private ScalarExpression compileExclusiveOrExpression() {
        ScalarExpression expr = this.compileAndExpression();
        while (this.p.parseChar('^')) {
            expr = expr.eor(this.compileExclusiveOrExpression());
        }
        return expr;
    }

    private ScalarExpression compileAndExpression() {
        ScalarExpression expr = this.compileEqualityExpression();
        while (this.p.parseChar('&', '&')) {
            expr = expr.and(this.compileEqualityExpression());
        }
        return expr;
    }

    private ScalarExpression compileEqualityExpression() {
        ScalarExpression expr = this.compileRelationalExpression();
        while (true) {
            if (this.p.parseString("==")) {
                expr = expr.eq(this.compileRelationalExpression());
                continue;
            }
            if (!this.p.parseString("!=")) break;
            expr = expr.noteq(this.compileRelationalExpression());
        }
        if (this.p.parseString("=")) {
            throw new NucleusUserException(LOCALISER.msg("042008", (Object)this.p.getInput()));
        }
        return expr;
    }

    private ScalarExpression compileRelationalExpression() {
        ScalarExpression expr = this.compileAdditiveExpression();
        while (true) {
            if (this.p.parseString("<=")) {
                expr = expr.lteq(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseString(">=")) {
                expr = expr.gteq(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseChar('<')) {
                expr = expr.lt(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseChar('>')) {
                expr = expr.gt(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseString("instanceof")) {
                expr = expr.instanceOf(this.compileAdditiveExpression());
                continue;
            }
            if (!this.p.parseString("AS") && !this.p.parseString("as")) break;
            String asName = this.p.parseName();
            expr = expr.as(asName);
        }
        return expr;
    }

    protected ScalarExpression compilePrimary() {
        ArrayList<ScalarExpression> args;
        ScalarExpression expr = this.compileLiteral();
        if (expr == null) {
            if (this.p.parseChar('(')) {
                expr = this.compileExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                expr.encloseWithInParentheses();
            } else if (this.p.parseChar('{')) {
                ArrayList<ScalarExpression> exprs = new ArrayList<ScalarExpression>();
                while (!this.p.parseChar('}')) {
                    exprs.add(this.compileExpression());
                    if (this.p.parseChar('}')) break;
                    if (this.p.parseChar(',')) continue;
                    throw new QueryCompilerSyntaxException("',' or '}' expected", this.p.getIndex(), this.p.getInput());
                }
                expr = new ArrayExpression(this.qs, exprs.toArray(new ScalarExpression[exprs.size()]));
            } else {
                String methodId = this.p.parseMethod();
                if (methodId == null) {
                    expr = this.compileIdentifier();
                } else if (this.p.parseChar('(')) {
                    args = new ArrayList();
                    boolean isDistinct = false;
                    if (!this.p.parseChar(')')) {
                        isDistinct = this.p.parseString("DISTINCT");
                        if (!isDistinct) {
                            isDistinct = this.p.parseString("distinct");
                        }
                        do {
                            ScalarExpression argExpr = this.compileExpression();
                            args.add(argExpr);
                            this.fieldExpressions.remove(argExpr);
                        } while (this.p.parseChar(','));
                        if (!this.p.parseChar(')')) {
                            throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                        }
                    }
                    expr = new AggregateExpression(this.qs);
                    if (isDistinct) {
                        ((AggregateExpression)expr).setDistinct();
                    }
                    expr = expr.callMethod(methodId.toLowerCase(), args);
                    this.fieldExpressions.add(expr);
                }
            }
        }
        while (this.p.parseChar('.')) {
            String id = this.p.parseIdentifier();
            if (id == null) {
                throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
            }
            if (this.p.parseChar('(')) {
                args = new ArrayList<ScalarExpression>();
                if (!this.p.parseChar(')')) {
                    do {
                        args.add(this.compileExpression());
                    } while (this.p.parseChar(','));
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                }
                expr = expr.callMethod(id, args);
                continue;
            }
            expr = expr.accessField(id, false);
        }
        return expr;
    }

    private ScalarExpression compileIdentifier() {
        ScalarExpression expr;
        block32: {
            String id = this.p.parseIdentifier();
            if (id == null) {
                throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
            }
            if (JDOQLQueryHelper.isKeyword((String)id)) {
                throw new QueryCompilerSyntaxException(LOCALISER.msg("042009", (Object)id), this.p.getIndex(), this.p.getInput());
            }
            MappedStoreManager srm = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
            ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
            if (id.startsWith(":")) {
                return this.compileNamedImplicitParameter(id);
            }
            if (id.equals("new")) {
                expr = this.compileNewObject();
            } else if (this.parameterTypesByName.containsKey(id)) {
                Class parameterClass = (Class)this.parameterTypesByName.get(id);
                boolean serialised = false;
                if (parameterClass == Object.class) {
                    serialised = true;
                }
                JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(parameterClass, serialised, false, clr);
                if (!this.executionCompile) {
                    expr = m.newLiteral(this.qs, m.getSampleValue(clr));
                } else {
                    if (this.parameters == null || !this.parameters.containsKey(id)) {
                        throw new NucleusUserException(LOCALISER.msg("021110", (Object)this.language, (Object)id));
                    }
                    Object parameterValue = this.parameters.get(id);
                    if (parameterValue == null) {
                        expr = new NullLiteral(this.qs);
                    } else {
                        expr = m.newLiteral(this.qs, parameterValue);
                        expr.setParameterName(id);
                    }
                }
            } else {
                if (this.query.hasSubqueryForVariable(id)) {
                    return this.compileSubqueryVariable(id);
                }
                if (this.variableNames.contains(id)) {
                    return this.compileExplicitVariable(id);
                }
                if (this.parentExpr != null && id.equals("this")) {
                    if (this.subqueryAliasSet) {
                        return this.parentExpr.getMainTableExpression().newFieldExpression(this.parentExpr.getCandidateAlias());
                    }
                    return this.qs.getMainTableExpression().newFieldExpression(this.candidateAlias);
                }
                try {
                    expr = this.qs.getMainTableExpression().newFieldExpression(id);
                    if (!id.equals(this.candidateAlias)) {
                        if (this.candidateCmd == null) {
                            this.candidateCmd = this.query.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                        }
                        if (this.candidateCmd.getMetaDataForMember(id) == null) {
                            throw new NucleusUserException(LOCALISER.msg("021049", (Object)id));
                        }
                    }
                    this.fieldExpressions.add(expr);
                }
                catch (NoSuchPersistentFieldException nspfe) {
                    String name = id;
                    if (this.p.nextIsDot()) {
                        this.p.parseChar('.');
                        name = name + ".";
                        name = name + this.p.parseName();
                    }
                    Class cls = null;
                    try {
                        cls = this.query.resolveClassDeclaration(name);
                        expr = new ClassExpression(this.qs, cls);
                    }
                    catch (NucleusUserException jpue) {
                        if (name.indexOf(46) > 0) {
                            String partialName = name.substring(0, name.lastIndexOf(46));
                            String finalNamePart = name.substring(name.lastIndexOf(46) + 1);
                            try {
                                expr = this.callUserDefinedScalarExpression(name);
                                if (expr == null) {
                                    cls = this.query.resolveClassDeclaration(partialName);
                                    expr = new ClassExpression(this.qs, cls);
                                    expr = expr.accessField(finalNamePart, true);
                                }
                                break block32;
                            }
                            catch (NucleusUserException jpue2) {
                                throw new NucleusUserException(LOCALISER.msg("021066", (Object)partialName), (Throwable)jpue2);
                            }
                        }
                        try {
                            expr = new ClassExpression(this.qs, this.candidateClass);
                            expr = expr.accessField(name, true);
                        }
                        catch (NucleusUserException jpue2) {
                            if (this.explicitVariables) {
                                throw new NucleusUserException(LOCALISER.msg("021111", (Object)this.query.getExplicitVariables(), (Object)name));
                            }
                            expr = (ScalarExpression)this.expressionsByVariableName.get(name);
                            if (expr != null) break block32;
                            expr = new UnboundVariable(this.qs, name, (Class)this.variableTypesByName.get(name), (UnboundVariable.VariableBinder)this);
                            this.variableNames.add(name);
                            this.fieldExpressions.add(expr);
                        }
                    }
                }
            }
        }
        return expr;
    }

    protected ScalarExpression compileSubqueryVariable(String id) {
        Query.SubqueryDefinition subqueryDef = this.query.getSubqueryForVariable(id);
        JDOQLQueryCompiler subCompiler = new JDOQLQueryCompiler((AbstractJDOQLQuery)subqueryDef.getQuery(), this.imports, subqueryDef.getParameterMap());
        subCompiler.processAsSubquery(this.qs, subqueryDef.getCandidateExpression(), subqueryDef.getParameterMap());
        QueryExpression subqueryExpr = (QueryExpression)subCompiler.compile(4);
        subCompiler.getCandidates().newResultObjectFactory(subqueryExpr, false, subCompiler.getResultClass(), true);
        SubqueryExpression expr = new SubqueryExpression(this.qs, subqueryExpr);
        this.expressionsByVariableName.put(id, expr);
        return expr;
    }

    protected ScalarExpression compileNamedImplicitParameter(String id) {
        id = id.substring(1);
        if (this.explicitParameters) {
            throw new NucleusUserException(LOCALISER.msg("021055", (Object)this.parameters, (Object)id));
        }
        MappedStoreManager srm = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(id)) {
                Object paramValue = this.parameters.get(id);
                if (paramValue != null) {
                    if (this.parentExpr != null && paramValue instanceof String && ((String)paramValue).startsWith("this")) {
                        return this.getExpressionForSubqueryParentParameter((String)paramValue);
                    }
                    JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(paramValue.getClass(), false, false, clr);
                    ScalarExpression paramExpr = m.newLiteral(this.qs, paramValue);
                    paramExpr.setParameterName(id);
                    return paramExpr;
                }
                return new NullLiteral(this.qs);
            }
            if (this.parameters.size() < this.implicitParamNo + 1) {
                throw new NucleusUserException(LOCALISER.msg("021056", (Object)("" + id), (Object)("" + this.implicitParamNo)));
            }
            Integer paramNoInt = new Integer(this.implicitParamNo);
            if (!this.parameters.containsKey(paramNoInt)) {
                throw new NucleusUserException(LOCALISER.msg("021056", (Object)("" + id), (Object)("" + this.implicitParamNo)));
            }
            Object paramValue = this.parameters.get(paramNoInt);
            this.parameters.put(id, paramValue);
            this.parameters.remove(paramNoInt);
            ++this.implicitParamNo;
            if (paramValue != null) {
                if (this.parentExpr != null && paramValue instanceof String && ((String)paramValue).startsWith("this")) {
                    return this.getExpressionForSubqueryParentParameter((String)paramValue);
                }
                JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(paramValue.getClass(), false, false, clr);
                ScalarExpression paramExpr = m.newLiteral(this.qs, paramValue);
                paramExpr.setParameterName(id);
                return paramExpr;
            }
            return new NullLiteral(this.qs);
        }
        if (this.executionCompile) {
            throw new NucleusUserException(LOCALISER.msg("021056", (Object)("" + id), (Object)("" + this.implicitParamNo)));
        }
        return new NullLiteral(this.qs);
    }

    protected ScalarExpression getExpressionForSubqueryParentParameter(String val) {
        if (!this.parentExpr.getStoreManager().getDatastoreAdapter().supportsOption("AccessParentQueryInSubquery")) {
            throw new NucleusException("This datastore doesnt support the use of subquery parameters linking back to the outer query");
        }
        LogicSetExpression tblExpr = this.parentExpr.getMainTableExpression();
        if (val.equals("this")) {
            return tblExpr.newFieldExpression("this");
        }
        String[] tokens = StringUtils.split((String)val, (String)".");
        if (tokens.length == 2) {
            return tblExpr.newFieldExpression(tokens[1]);
        }
        throw new NucleusException("DataNucleus doesnt currently support subquery parameter values that arent a direct field of the outer query candidate (" + val + ")");
    }
}

