/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class OracleBlobRDBMSMapping
extends RDBMSMapping {
    public OracleBlobRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected OracleBlobRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public String getInsertionInputParameter() {
        return "EMPTY_BLOB()";
    }

    public boolean insertValuesOnInsert() {
        return false;
    }

    public Object getObject(Object rs, int param) {
        Object obj;
        block46: {
            obj = null;
            try {
                byte[] bytes = new byte[]{};
                Blob blob = ((ResultSet)rs).getBlob(param);
                if (((ResultSet)rs).wasNull()) break block46;
                bytes = blob.getBytes(1L, (int)blob.length());
                if (bytes.length < 1) {
                    return null;
                }
                try {
                    if (this.getJavaTypeMapping().isSerialised()) {
                        BlobImpl b = new BlobImpl(bytes);
                        obj = b.getObject();
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BOOLEAN_ARRAY)) {
                        obj = TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BYTE_ARRAY)) {
                        obj = bytes;
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.CHAR_ARRAY)) {
                        obj = TypeConversionHelper.getCharArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_STRING)) {
                        obj = new String(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.DOUBLE_ARRAY)) {
                        obj = TypeConversionHelper.getDoubleArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.FLOAT_ARRAY)) {
                        obj = TypeConversionHelper.getFloatArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.INT_ARRAY)) {
                        obj = TypeConversionHelper.getIntArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.LONG_ARRAY)) {
                        obj = TypeConversionHelper.getLongArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.SHORT_ARRAY)) {
                        obj = TypeConversionHelper.getShortArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY)) {
                        obj = TypeConversionHelper.getBooleanObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BYTE_ARRAY)) {
                        obj = TypeConversionHelper.getByteObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY)) {
                        obj = TypeConversionHelper.getCharObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY)) {
                        obj = TypeConversionHelper.getDoubleObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY)) {
                        obj = TypeConversionHelper.getFloatObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY)) {
                        obj = TypeConversionHelper.getIntObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_LONG_ARRAY)) {
                        obj = TypeConversionHelper.getLongObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_SHORT_ARRAY)) {
                        obj = TypeConversionHelper.getShortObjectArrayFromByteArray((byte[])bytes);
                    } else {
                        if (this.getJavaTypeMapping().getType().equals(BigDecimal[].class.getName())) {
                            return TypeConversionHelper.getBigDecimalArrayFromByteArray((byte[])bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals(BigInteger[].class.getName())) {
                            return TypeConversionHelper.getBigIntegerArrayFromByteArray((byte[])bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals(BitSet.class.getName())) {
                            return TypeConversionHelper.getBitSetFromBooleanArray((boolean[])((boolean[])TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes)));
                        }
                        obj = new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                    }
                }
                catch (StreamCorruptedException e) {
                    String msg = "StreamCorruptedException: object is corrupted";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
                catch (IOException e) {
                    String msg = "IOException: error when reading object";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
                catch (ClassNotFoundException e) {
                    String msg = "ClassNotFoundException: error when creating object";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)sqle.getMessage()), (Throwable)sqle);
            }
        }
        return obj;
    }

    public String getString(Object resultSet, int exprIndex) {
        return (String)this.getObject(resultSet, exprIndex);
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSStoreManager)this.storeMgr).getSQLTypeInfoForJDBCType(2004);
    }

    public String getUpdateInputParameter() {
        return "EMPTY_BLOB()";
    }

    public boolean includeInSQLFetchStatement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBlobColumn(StateManager sm, DatastoreContainerObject datastoreContainer, DatastoreMapping mapping, byte[] bytes) {
        StateManager[] embeddedOwners;
        ObjectManager om = sm.getObjectManager();
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
        DatastoreClass classTable = (DatastoreClass)datastoreContainer;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLStatement sqlStmt = new SQLStatement(storeMgr, datastoreContainer, null, null);
        sqlStmt.addExtension("lock-for-update", true);
        SQLTable blobSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), mapping.getJavaTypeMapping());
        sqlStmt.select(blobSqlTbl, mapping.getDatastoreField(), null);
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        int inputParamNum = 1;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = classTable.getDataStoreObjectIdMapping();
            SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, datastoreIdMapping, null, "ID");
            sqlStmt.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum});
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = classTable.getMemberMapping(mmd);
                SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, pkMapping, null, "PK" + i);
                sqlStmt.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < pkMapping.getNumberOfDatastoreFields(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        String textStmt = sqlStmt.getSelectStatement().toSQL();
        if (sm.getPcObjectType() != 0 && (embeddedOwners = sm.getEmbeddedOwners()) != null) {
            sm = embeddedOwners[0];
        }
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, textStmt);
                try {
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
                        for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                            classTable.getDataStoreObjectIdMapping().setObject(om, (Object)ps, datastoreIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                        }
                    } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(cmd.getPKMemberPositions(), storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, false));
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, textStmt, ps);
                    try {
                        Blob blob;
                        if (!rs.next()) {
                            throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                        }
                        int jdbcMajorVersion = ((DatabaseAdapter)storeMgr.getDatastoreAdapter()).getDriverMajorVersion();
                        if (jdbcMajorVersion < 10) {
                            blob = null;
                            if (jdbcMajorVersion <= 8) {
                                OracleResultSet ors = (OracleResultSet)rs;
                                blob = ors.getBLOB(1);
                            } else {
                                blob = (BLOB)rs.getBlob(1);
                            }
                            if (blob != null) {
                                blob.putBytes(1L, bytes);
                            }
                        } else {
                            blob = rs.getBlob(1);
                            if (blob != null) {
                                blob.setBytes(1L, bytes);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Update of BLOB value failed: " + textStmt, (Throwable)e);
        }
    }
}

