/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.ClassTable;

public class DiscriminatorStatementGenerator
extends AbstractStatementGenerator {
    Class[] candidates = null;

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName);
        this.setOption("restrictDiscriminator");
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, Class[] candidateTypes, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        this(storeMgr, candidateTypes[0], includeSubclasses, candidateTableAlias, candidateTableGroupName);
        this.candidates = candidateTypes;
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, DatastoreContainerObject joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
        this.setOption("restrictDiscriminator");
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, Class[] candidateTypes, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, DatastoreContainerObject joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        this(storeMgr, candidateTypes[0], includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
        this.candidates = candidateTypes;
    }

    public void setParentStatement(SQLStatement stmt) {
        this.parentStmt = stmt;
    }

    public SQLStatement getStatement() {
        String[] managedClasses;
        SQLStatement stmt = null;
        SQLTable discrimSqlTbl = null;
        if (this.joinTable == null) {
            stmt = new SQLStatement(this.parentStmt, this.storeMgr, (DatastoreContainerObject)this.candidateTable, this.candidateTableAlias, this.candidateTableGroupName);
            discrimSqlTbl = stmt.getPrimaryTable();
        } else {
            stmt = new SQLStatement(this.parentStmt, this.storeMgr, this.joinTable, this.joinTableAlias, this.candidateTableGroupName);
            JavaTypeMapping candidateIdMapping = this.candidateTable.getIDMapping();
            discrimSqlTbl = this.hasOption("allowNulls") ? stmt.leftOuterJoin(null, this.joinElementMapping, (DatastoreContainerObject)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName()) : stmt.innerJoin(null, this.joinElementMapping, (DatastoreContainerObject)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName());
        }
        JavaTypeMapping discMapping = this.candidateTable.getDiscriminatorMapping(true);
        if (discMapping != null) {
            discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, discrimSqlTbl, discMapping);
        }
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        DiscriminatorMetaData dismd = discrimSqlTbl.getTable().getDiscriminatorMetaData();
        boolean hasDiscriminator = discMapping != null && dismd != null && dismd.getStrategy() != DiscriminatorStrategy.NONE;
        boolean restrictDiscriminator = this.hasOption("restrictDiscriminator");
        if (this.includeSubclasses && hasDiscriminator && this.candidateTable.getDiscriminatorMapping(false) != null && !this.storeMgr.getOMFContext().getMetaDataManager().isPersistentDefinitionImplementation(this.candidateType.getName()) && (managedClasses = ((ClassTable)this.candidateTable).getManagedClasses()).length == 1) {
            restrictDiscriminator = false;
        }
        if (hasDiscriminator && restrictDiscriminator) {
            boolean multipleCandidates = false;
            BooleanExpression discExpr = null;
            if (this.candidates != null) {
                if (this.candidates.length > 1) {
                    multipleCandidates = true;
                }
                for (int i = 0; i < this.candidates.length; ++i) {
                    BooleanExpression discExprCandidate = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, this.candidates[i].getName(), dismd, discMapping, discrimSqlTbl);
                    discExpr = discExpr != null ? discExpr.ior(discExprCandidate) : discExprCandidate;
                    if (!this.includeSubclasses) continue;
                    HashSet subclassNames = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, clr);
                    Iterator subclassIter = subclassNames.iterator();
                    if (!multipleCandidates) {
                        boolean bl = multipleCandidates = subclassNames.size() > 0;
                    }
                    while (subclassIter.hasNext()) {
                        String subclassName = (String)subclassIter.next();
                        BooleanExpression discExprSub = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, subclassName, dismd, discMapping, discrimSqlTbl);
                        discExpr = discExpr.ior(discExprSub);
                    }
                }
            } else {
                discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, this.candidateType.getName(), dismd, discMapping, discrimSqlTbl);
                if (this.includeSubclasses) {
                    HashSet subclassNames = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, clr);
                    Iterator subclassIter = subclassNames.iterator();
                    boolean bl = multipleCandidates = subclassNames.size() > 0;
                    while (subclassIter.hasNext()) {
                        String subclassName = (String)subclassIter.next();
                        BooleanExpression discExprCandidate = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, subclassName, dismd, discMapping, discrimSqlTbl);
                        discExpr = discExpr.ior(discExprCandidate);
                    }
                }
            }
            if (this.hasOption("allowNulls")) {
                SQLExpression expr = stmt.getSQLExpressionFactory().newExpression(stmt, discrimSqlTbl, discMapping);
                NullLiteral val = new NullLiteral(stmt, null, null, null);
                BooleanExpression nullDiscExpr = expr.eq(val);
                discExpr = discExpr.ior(nullDiscExpr);
                if (!multipleCandidates) {
                    multipleCandidates = true;
                }
            }
            if (multipleCandidates) {
                discExpr.encloseInParentheses();
            }
            stmt.whereAnd(discExpr, true);
        }
        return stmt;
    }
}

