/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.legacy.LegacyForwardQueryResult;
import org.datanucleus.store.rdbms.query.legacy.LegacyScrollableQueryResult;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    Query query;
    ObjectManager om;
    ResultObjectFactory rof;
    Collection candidateCollection;

    public SQLEvaluator(Query query, ResultObjectFactory rof, Collection candidateCollection) {
        this.om = query.getObjectManager();
        this.query = query;
        this.rof = rof;
        this.candidateCollection = candidateCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(QueryExpression queryStmt) {
        AbstractRDBMSQueryResult qr;
        block18: {
            qr = null;
            boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery(this.query);
            try {
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    StatementText stmtText = null;
                    if (this.query.getType() == 0) {
                        stmtText = queryStmt.toStatementText(useUpdateLock);
                    } else {
                        if (this.query.getType() == 1) {
                            stmtText = queryStmt.toUpdateStatementText();
                            throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                        }
                        if (this.query.getType() == 2) {
                            stmtText = queryStmt.toDeleteStatementText();
                            throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                        }
                    }
                    PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, stmtText, this.query);
                    try {
                        RDBMSQueryUtils.prepareStatementForExecution(ps, this.query, true);
                        if (this.query.getType() == 0) {
                            ResultSet rs = sqlControl.executeStatementQuery(mconn, stmtText.toString(), ps);
                            try {
                                String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(this.query);
                                qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new LegacyScrollableQueryResult(this.query, this.rof, rs, this.query.getResultDistinct() ? null : this.candidateCollection) : new LegacyForwardQueryResult(this.query, this.rof, rs, this.query.getResultDistinct() ? null : this.candidateCollection);
                                LegacyScrollableQueryResult qr1 = qr;
                                ManagedConnection mconn1 = mconn;
                                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                    final /* synthetic */ QueryResult val$qr1;
                                    final /* synthetic */ ManagedConnection val$mconn1;
                                    {
                                        this.val$qr1 = queryResult;
                                        this.val$mconn1 = managedConnection;
                                    }

                                    public void managedConnectionPreClose() {
                                    }

                                    public void managedConnectionPostClose() {
                                    }

                                    public void managedConnectionFlushed() {
                                        this.val$qr1.disconnect();
                                    }

                                    public void resourcePostClose() {
                                        this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                    }
                                };
                                mconn.addListener(listener);
                                ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                break block18;
                            }
                            finally {
                                if (qr == null) {
                                    rs.close();
                                }
                            }
                        }
                        int[] rcs = sqlControl.executeStatementUpdate(mconn, stmtText.toString(), ps, true);
                        NucleusLogger.QUERY.info((Object)(">> Update statement returned " + rcs[0]));
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("042007", (Object)queryStmt.toStatementText(useUpdateLock), (Object)e.getMessage()), (Throwable)e);
            }
        }
        return qr;
    }
}

