/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JPQLQueryHelper;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.Extent;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.AggregateExpression;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.ClassExpression;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.JoinExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MathExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SubqueryExpression;
import org.datanucleus.store.mapped.expression.TemporalExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.expression.UnknownLiteral;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.rdbms.query.legacy.CollectionCandidates;
import org.datanucleus.store.rdbms.query.legacy.JPQLParser;
import org.datanucleus.store.rdbms.query.legacy.JPQLQuery;
import org.datanucleus.store.rdbms.query.legacy.QueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.ResultExpressionsQueryable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JPQLQueryCompiler
extends QueryCompiler {
    protected transient Map<String, QueryCompiler.AliasJoinInformation> aliases = new HashMap<String, QueryCompiler.AliasJoinInformation>();
    protected transient ClassExpression[] candidateExpressions;
    protected transient Set processedParameters = null;
    protected JPQLQueryCompiler parentCompiler = null;

    public JPQLQueryCompiler(AbstractJPQLQuery query, Imports imports, Map parameters) {
        super((Query)query, imports, parameters);
        this.language = "JPQL";
    }

    public void processAsSubquery(JPQLQueryCompiler parentCompiler) {
        this.parentCompiler = parentCompiler;
        this.parentExpr = parentCompiler.qs;
    }

    protected void performCompile(QueryExpression qs) {
        if (this.parentExpr != null && this.subqueryCandidateExpr != null) {
            this.compileSubqueryCandidateExpression(false);
        }
        if (this.candidateExpressions != null) {
            for (int i = 0; i < this.candidateExpressions.length; ++i) {
                this.processClassExpression(this.candidateExpressions[i]);
            }
        }
        this.fieldExpressions.clear();
        this.compileResult(qs, this.query.getResult());
        ScalarExpression[] resultFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        for (int i = 0; i < resultFieldExprs.length; ++i) {
            if (resultFieldExprs[i].getLogicSetExpression() == null && resultFieldExprs[i] instanceof UnboundVariable) {
                throw new NucleusUserException(LOCALISER.msg("021049", (Object)((UnboundVariable)resultFieldExprs[i]).getVariableName()));
            }
            qs.crossJoin(resultFieldExprs[i].getLogicSetExpression(), true);
        }
        this.compileFilter(qs, this.query.getFilter());
        ScalarExpression[] groupingFieldExprs = null;
        String grouping = this.query.getGrouping();
        if (grouping != null && grouping.length() > 0) {
            this.fieldExpressions.clear();
            this.compileGrouping(qs, grouping);
            groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        }
        this.fieldExpressions.clear();
        this.compileOrdering(qs, this.query.getOrdering());
        ScalarExpression[] orderingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        String having = this.query.getHaving();
        if (having != null && having.length() > 0) {
            this.compileHaving(qs, having);
        }
        if (groupingFieldExprs != null) {
            this.checkExpressionsAgainstGrouping(orderingFieldExprs, groupingFieldExprs, "021069");
            this.checkExpressionsAgainstGrouping(resultFieldExprs, groupingFieldExprs, "021070");
        }
        groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
        this.compileRange(qs);
        this.compileUpdate(qs, ((JPQLQuery)this.query).getUpdate());
        this.checkVariableBinding();
        if (this.parameters != null && this.parameters.size() > 0) {
            Set paramNames = this.parameters.keySet();
            for (Object param : paramNames) {
                if (this.processedParameters != null && this.processedParameters.contains(param)) continue;
                throw new QueryInvalidParametersException(LOCALISER.msg("021113", param));
            }
        }
    }

    protected void compileUpdate(QueryExpression qs, String update) {
        if (update != null && update.length() > 0) {
            ScalarExpression[] exprs = this.compileExpressionsFromString(update);
            if (qs != null) {
                qs.setUpdates(exprs);
            }
        }
    }

    protected void compileCandidates() {
        String result;
        ObjectManager om = this.query.getObjectManager();
        this.compileFrom(((JPQLQuery)this.query).getFrom());
        if (this.query.getResult() != null && (result = this.query.getResult().trim()).equalsIgnoreCase(this.candidateAlias) && !this.query.getResultDistinct()) {
            this.query.setResult(null);
        }
        String candidateClassName = this.query.getCandidateClassName();
        if (this.candidateClass == null && candidateClassName != null) {
            try {
                this.candidateClass = om.getClassLoaderResolver().classForName(candidateClassName, true);
            }
            catch (NucleusException jpe) {
                this.candidateClass = this.query.resolveClassDeclaration(candidateClassName);
            }
        }
        Extent candidateExtent = ((AbstractJavaQuery)this.query).getCandidateExtent();
        Collection candidateCollection = ((AbstractJavaQuery)this.query).getCandidateCollection();
        if (candidateExtent != null) {
            this.candidates = (Queryable)candidateExtent;
        } else if (candidateCollection != null) {
            this.candidates = new CollectionCandidates(om, this.candidateClass, candidateCollection);
        } else {
            if (this.candidateClass == null) {
                throw new NucleusUserException(LOCALISER.msg("021048", (Object)this.language));
            }
            this.candidates = (Queryable)om.getExtent(this.candidateClass, this.query.isSubclasses());
        }
        String result2 = this.query.getResult();
        if (result2 != null) {
            this.candidates = candidateCollection != null ? new ResultExpressionsQueryable(om, this.candidateClass, ((CollectionCandidates)this.candidates).getUserCandidates(), this.query.isSubclasses()) : new ResultExpressionsQueryable(om, this.candidateClass, this.query.isSubclasses());
        }
    }

    private void compileFrom(String from) {
        if (from != null) {
            int i;
            String[] exprList = QueryUtils.getExpressionsFromString((String)from);
            ScalarExpression[] exprs = null;
            if (exprList != null && exprList.length > 0) {
                exprs = new ScalarExpression[exprList.length];
                for (i = 0; i < exprs.length; ++i) {
                    exprs[i] = this.compileFromExpression(exprList[i]);
                }
            }
            this.candidateClass = ((ClassExpression)exprs[0]).getCls();
            this.candidateAlias = exprs[0].getAlias().toUpperCase();
            this.candidateExpressions = new ClassExpression[exprs.length];
            for (i = 0; i < this.candidateExpressions.length; ++i) {
                ClassExpression classExpr = (ClassExpression)exprs[i];
                if (classExpr.getCls() == null) {
                    this.candidateExpressions[i] = new ClassExpression(this.qs, this.candidateClass);
                    this.candidateExpressions[i].as(this.candidateAlias);
                    JoinExpression[] joins = classExpr.getJoins();
                    if (joins == null) continue;
                    for (int j = 0; j < joins.length; ++j) {
                        this.candidateExpressions[i].join(joins[j]);
                    }
                    continue;
                }
                this.candidateExpressions[i] = classExpr;
            }
        }
    }

    protected ClassExpression compileFromExpression(String fromStr) {
        ClassExpression expr = null;
        this.p = new JPQLParser(fromStr, this.imports);
        if (this.p.parseStringIgnoreCase("IN")) {
            if (!this.p.parseChar('(')) {
                throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            String name = this.p.parseIdentifier();
            if (this.p.nextIsDot()) {
                this.p.parseChar('.');
                name = name + ".";
                name = name + this.p.parseName();
            }
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            this.p.parseStringIgnoreCase("AS");
            String alias = this.p.parseName();
            expr = new ClassExpression(this.qs, this.candidateClass);
            expr.as(this.candidateAlias);
            JoinExpression joinExpr = new JoinExpression(this.qs, name, false, false);
            joinExpr.as(alias);
            expr.join(joinExpr);
            this.compileFromJoinExpressions(expr);
        } else {
            String id;
            String name = id = this.p.parseIdentifier();
            if (this.p.nextIsDot()) {
                this.p.parseChar('.');
                name = name + ".";
                name = name + this.p.parseName();
            }
            if (this.parentExpr != null) {
                Class cls = null;
                cls = this.getClassForSubqueryCandidateExpression(name);
                expr = new ClassExpression(this.qs, cls);
                id = this.p.parseIdentifier();
                if (id != null) {
                    if (id.equalsIgnoreCase("AS")) {
                        id = this.p.parseIdentifier();
                    }
                    if (id != null) {
                        expr.as(id);
                    }
                }
            } else {
                Class cls = this.query.resolveClassDeclaration(name);
                expr = new ClassExpression(this.qs, cls);
                id = this.p.parseIdentifier();
                if (id != null) {
                    if (id.equalsIgnoreCase("AS")) {
                        id = this.p.parseIdentifier();
                    }
                    if (id != null) {
                        expr.as(id);
                    }
                }
            }
            this.compileFromJoinExpressions(expr);
        }
        return expr;
    }

    protected void compileFromJoinExpressions(ClassExpression clsExpr) {
        boolean moreJoins = true;
        while (moreJoins) {
            if (clsExpr.getAlias() == null) {
                throw new NucleusUserException("Query has missing identifier at end");
            }
            if (this.aliases.get(clsExpr.getAlias().toUpperCase()) == null) {
                QueryCompiler.AliasJoinInformation leftAliasInfo = new QueryCompiler.AliasJoinInformation(clsExpr.getAlias().toUpperCase(), clsExpr.getCls(), null, true);
                this.aliases.put(clsExpr.getAlias().toUpperCase(), leftAliasInfo);
            }
            boolean leftJoin = false;
            boolean innerJoin = false;
            if (this.p.parseStringIgnoreCase("INNER")) {
                innerJoin = true;
            } else if (this.p.parseStringIgnoreCase("LEFT")) {
                this.p.parseStringIgnoreCase("OUTER");
                leftJoin = true;
            }
            if (this.p.parseStringIgnoreCase("JOIN")) {
                String id;
                boolean fetch = false;
                if (this.p.parseStringIgnoreCase("FETCH")) {
                    fetch = true;
                }
                String name = id = this.p.parseIdentifier();
                if (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    name = name + ".";
                    name = name + this.p.parseName();
                }
                this.p.parseStringIgnoreCase("AS");
                String alias = this.p.parseName();
                JoinExpression joinExpr = new JoinExpression(this.qs, name, leftJoin, fetch);
                joinExpr.as(alias);
                clsExpr.join(joinExpr);
                continue;
            }
            if (innerJoin || leftJoin) {
                throw new NucleusUserException("Expected JOIN after INNER/LEFT keyword at" + this.p.remaining());
            }
            moreJoins = false;
            return;
        }
    }

    protected Class getClassForSubqueryCandidateExpression(String candExpr) {
        if (candExpr == null) {
            return null;
        }
        String[] tokens = StringUtils.split((String)candExpr, (String)".");
        Class cls = null;
        if (tokens[0].equalsIgnoreCase(this.parentExpr.getCandidateAlias())) {
            cls = this.parentExpr.getCandidateClass();
        } else {
            QueryCompiler.AliasJoinInformation aliasInfo = this.parentCompiler.aliases.get(tokens[0].toUpperCase());
            if (aliasInfo == null) {
                return this.query.resolveClassDeclaration(candExpr);
            }
            cls = aliasInfo.cls;
            this.subqueryCandidateExprRootAliasInfo = aliasInfo;
        }
        this.subqueryCandidateExpr = candExpr;
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        MetaDataManager mmgr = this.query.getObjectManager().getMetaDataManager();
        AbstractClassMetaData cmd = mmgr.getMetaDataForClass(cls, clr);
        for (int i = 1; i < tokens.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(tokens[i]);
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2 || relationType == 1 || relationType == 6) {
                cls = mmd.getType();
            } else if (relationType == 3 || relationType == 4 || relationType == 5) {
                if (mmd.hasCollection()) {
                    cls = clr.classForName(mmd.getCollection().getElementType());
                } else if (mmd.hasMap()) {
                    cls = clr.classForName(mmd.getMap().getValueType());
                } else if (mmd.hasArray()) {
                    cls = clr.classForName(mmd.getArray().getElementType());
                }
            }
            if (i >= tokens.length - 1) continue;
            cmd = mmgr.getMetaDataForClass(cls, clr);
        }
        return cls;
    }

    protected void processClassExpression(ClassExpression classExpr) {
        MappedStoreManager srm = (MappedStoreManager)this.query.getStoreManager();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        JoinExpression[] joinExprs = classExpr.getJoins();
        if (classExpr.getCls() != this.candidateClass && classExpr.getCls() != null) {
            DatastoreIdentifier rightTblId = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, classExpr.getAlias());
            DatastoreClass rightTable = srm.getDatastoreClass(classExpr.getCls().getName(), clr);
            LogicSetExpression rightTblExpr = this.qs.newTableExpression((DatastoreContainerObject)rightTable, rightTblId);
            QueryCompiler.AliasJoinInformation rightAliasInfo = new QueryCompiler.AliasJoinInformation(classExpr.getAlias().toUpperCase(), classExpr.getCls(), rightTblExpr, false);
            this.aliases.put(rightAliasInfo.alias, rightAliasInfo);
            this.qs.crossJoin(rightTblExpr, true);
        }
        if (joinExprs != null) {
            for (int i = 0; i < joinExprs.length; ++i) {
                int sepPos1;
                JoinExpression joinExpr = joinExprs[i];
                String joinFieldName = joinExpr.getFieldName();
                boolean complete = false;
                int joinNum = 0;
                while (!complete && (sepPos1 = joinFieldName.indexOf(46)) >= 0) {
                    int sepPos2 = joinFieldName.indexOf(46, sepPos1 + 1);
                    if (sepPos2 < 0) {
                        complete = true;
                        sepPos2 = joinFieldName.length();
                    }
                    String leftAlias = joinFieldName.substring(0, sepPos1);
                    String fieldName = joinFieldName.substring(sepPos1 + 1, sepPos2);
                    String rightAlias = null;
                    rightAlias = complete ? joinExpr.getAlias() : "TMP" + joinNum;
                    if (joinExpr.getFieldName().equals(leftAlias + '.' + fieldName)) {
                        this.processJoinExpression(joinExpr);
                        continue;
                    }
                    JoinExpression expr = new JoinExpression(this.qs, leftAlias + '.' + fieldName, joinExpr.isLeftJoin(), joinExpr.isFetch());
                    if (rightAlias != null) {
                        expr.as(rightAlias);
                    }
                    this.processJoinExpression(expr);
                    if (complete) continue;
                    ++joinNum;
                    joinFieldName = rightAlias + '.' + joinFieldName.substring(sepPos2 + 1);
                }
            }
        }
    }

    protected void processJoinExpression(JoinExpression joinExpr) {
        MappedStoreManager srm = (MappedStoreManager)this.query.getStoreManager();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        String joinFieldName = joinExpr.getFieldName();
        if (joinFieldName.indexOf(46) >= 0) {
            String leftAlias = joinFieldName.substring(0, joinFieldName.indexOf(46)).toUpperCase();
            String leftFieldName = joinFieldName.substring(joinFieldName.indexOf(46) + 1);
            QueryCompiler.AliasJoinInformation leftAliasInfo = this.aliases.get(leftAlias);
            if (leftAliasInfo != null) {
                AbstractMemberMetaData[] rightMmds;
                AbstractMemberMetaData rightMmd;
                Class leftCls = leftAliasInfo.cls;
                DatastoreClass leftTable = srm.getDatastoreClass(leftCls.getName(), clr);
                JavaTypeMapping leftMapping = leftTable.getMemberMapping(leftFieldName);
                AbstractMemberMetaData leftMmd = leftMapping.getMemberMetaData();
                int relationType = leftMmd.getRelationType(clr);
                String rightTblIdName = joinExpr.getAlias() != null ? joinExpr.getAlias() : "UNKNOWN_ALIAS";
                DatastoreIdentifier rightTblId = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, rightTblIdName);
                LogicSetExpression leftTableExpr = leftAliasInfo.tableExpression;
                if (leftTableExpr == null) {
                    if (leftAlias.equalsIgnoreCase(this.candidateAlias)) {
                        leftAliasInfo.tableExpression = leftTableExpr = this.qs.getMainTableExpression();
                    } else {
                        throw new NucleusUserException("JPOX doesnt yet support joins to non-candidate aliases");
                    }
                }
                AbstractMemberMetaData abstractMemberMetaData = rightMmd = (rightMmds = leftMmd.getRelatedMemberMetaData(clr)) != null && rightMmds.length > 0 ? rightMmds[0] : null;
                if (leftMapping instanceof PersistableMapping) {
                    ScalarExpression leftExpr;
                    DatastoreClass rightTable = srm.getDatastoreClass(leftMmd.getTypeName(), clr);
                    LogicSetExpression rightTblExpr = this.qs.newTableExpression((DatastoreContainerObject)rightTable, rightTblId);
                    if (relationType == 1 || relationType == 2 && leftMmd.getMappedBy() == null) {
                        leftExpr = leftTableExpr.newFieldExpression(leftMmd.getName());
                        ScalarExpression rightExpr = rightTable.getIDMapping().newScalarExpression(this.qs, rightTblExpr);
                        if (joinExpr.isLeftJoin()) {
                            this.qs.leftOuterJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        } else {
                            this.qs.innerJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        }
                    } else if (relationType == 2 && leftMmd.getMappedBy() != null) {
                        leftExpr = leftTable.getIDMapping().newScalarExpression(this.qs, leftTableExpr);
                        ScalarExpression rightExpr = rightTblExpr.newFieldExpression(rightMmd.getName());
                        if (joinExpr.isLeftJoin()) {
                            this.qs.leftOuterJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        } else {
                            this.qs.innerJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        }
                    } else if (relationType == 6) {
                        if (rightMmd.getJoinMetaData() != null || leftMmd.getJoinMetaData() != null) {
                            leftExpr = leftTable.getIDMapping().newScalarExpression(this.qs, leftTableExpr);
                            ScalarExpression rightExpr = rightTable.getIDMapping().newScalarExpression(this.qs, rightTblExpr);
                            CollectionTable joinTbl = (CollectionTable)srm.getDatastoreContainerObject(rightMmd);
                            String joinTblIdName = rightTblIdName + "." + leftAlias;
                            DatastoreIdentifier joinTblId = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, joinTblIdName);
                            LogicSetExpression joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblId);
                            ScalarExpression joinLeftExpr = joinTbl.getElementMapping().newScalarExpression(this.qs, joinTblExpr);
                            ScalarExpression joinRightExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                            if (joinExpr.isLeftJoin()) {
                                this.qs.leftOuterJoin(leftExpr, joinLeftExpr, joinTblExpr, true, true);
                                this.qs.innerJoin(joinRightExpr, rightExpr, rightTblExpr, true, true);
                            } else {
                                this.qs.innerJoin(leftExpr, joinLeftExpr, joinTblExpr, true, true);
                                this.qs.innerJoin(joinRightExpr, rightExpr, rightTblExpr, true, true);
                            }
                        } else {
                            leftExpr = leftTableExpr.newFieldExpression(leftMmd.getName());
                            ScalarExpression rightExpr = rightTable.getIDMapping().newScalarExpression(this.qs, rightTblExpr);
                            if (joinExpr.isLeftJoin()) {
                                this.qs.leftOuterJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                            } else {
                                this.qs.innerJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                            }
                        }
                    }
                    if (joinExpr.getAlias() != null) {
                        QueryCompiler.AliasJoinInformation rightAliasInfo = new QueryCompiler.AliasJoinInformation(joinExpr.getAlias().toUpperCase(), leftMmd.getType(), rightTblExpr, false);
                        this.aliases.put(rightAliasInfo.alias, rightAliasInfo);
                    }
                } else if (leftMapping instanceof CollectionMapping) {
                    ScalarExpression rightExpr;
                    ScalarExpression leftExpr;
                    DatastoreClass rightTable = srm.getDatastoreClass(leftMmd.getCollection().getElementType(), clr);
                    LogicSetExpression rightTblExpr = this.qs.newTableExpression((DatastoreContainerObject)rightTable, rightTblId);
                    if (relationType == 5 || leftMmd.getJoinMetaData() != null) {
                        leftExpr = leftTable.getIDMapping().newScalarExpression(this.qs, leftTableExpr);
                        rightExpr = rightTable.getIDMapping().newScalarExpression(this.qs, rightTblExpr);
                        CollectionTable joinTbl = (CollectionTable)srm.getDatastoreContainerObject(leftMmd);
                        String joinTblIdName = leftAlias + "." + rightTblIdName;
                        DatastoreIdentifier joinTblId = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, joinTblIdName);
                        LogicSetExpression joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblId);
                        ScalarExpression joinLeftExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                        ScalarExpression joinRightExpr = joinTbl.getElementMapping().newScalarExpression(this.qs, joinTblExpr);
                        if (joinExpr.isLeftJoin()) {
                            this.qs.leftOuterJoin(leftExpr, joinLeftExpr, joinTblExpr, true, true);
                            this.qs.innerJoin(joinRightExpr, rightExpr, rightTblExpr, true, true);
                        } else {
                            this.qs.innerJoin(leftExpr, joinLeftExpr, joinTblExpr, true, true);
                            this.qs.innerJoin(joinRightExpr, rightExpr, rightTblExpr, true, true);
                        }
                    } else {
                        leftExpr = leftTable.getIDMapping().newScalarExpression(this.qs, leftTableExpr);
                        rightExpr = null;
                        if (relationType == 3) {
                            JavaTypeMapping m = rightTable.getExternalMapping(leftMmd, 5);
                            rightExpr = m.newScalarExpression(this.qs, rightTblExpr);
                        } else if (relationType == 4) {
                            rightExpr = rightTblExpr.newFieldExpression(rightMmd.getName());
                        }
                        if (joinExpr.isLeftJoin()) {
                            this.qs.leftOuterJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        } else {
                            this.qs.innerJoin(leftExpr, rightExpr, rightTblExpr, true, true);
                        }
                    }
                    if (joinExpr.getAlias() != null) {
                        Class rightCls = clr.classForName(leftMmd.getCollection().getElementType());
                        QueryCompiler.AliasJoinInformation rightAliasInfo = new QueryCompiler.AliasJoinInformation(joinExpr.getAlias().toUpperCase(), rightCls, rightTblExpr, false);
                        this.aliases.put(rightAliasInfo.alias, rightAliasInfo);
                    }
                } else if (leftMapping instanceof MapMapping) {
                    DatastoreClass rightTable = srm.getDatastoreClass(leftMmd.getMap().getValueType(), clr);
                    if (leftMmd.getJoinMetaData() != null) {
                        // empty if block
                    }
                    NucleusLogger.QUERY.debug((Object)(">> TODO 1-N (map) LEFT : type=" + leftMmd.getTypeName() + " mapping=" + leftMapping + " mmd=" + leftMmd + "RIGHT : table=" + rightTable + " mmd=" + rightMmd));
                }
            }
        }
    }

    protected void compileOrdering(QueryExpression qs, String ordering) {
        if (ordering != null && ordering.length() > 0) {
            String[] exprs = QueryUtils.getExpressionsFromString((String)ordering);
            ScalarExpression[] orderExprs = new ScalarExpression[exprs.length];
            boolean[] descending = new boolean[exprs.length];
            for (int n = 0; n < exprs.length; ++n) {
                String orderExpression = exprs[n].trim();
                if (orderExpression.endsWith("ascending") || orderExpression.endsWith("ASCENDING")) {
                    descending[n] = false;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "ascending".length());
                } else if (orderExpression.endsWith("asc") || orderExpression.endsWith("ASC")) {
                    descending[n] = false;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "asc".length());
                } else if (orderExpression.endsWith("descending") || orderExpression.endsWith("DESCENDING")) {
                    descending[n] = true;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "descending".length());
                } else if (orderExpression.endsWith("desc") || orderExpression.endsWith("DESC")) {
                    descending[n] = true;
                    orderExpression = orderExpression.substring(0, orderExpression.length() - "desc".length());
                } else {
                    descending[n] = false;
                }
                orderExprs[n] = this.compileExpressionFromString(orderExpression);
            }
            if (qs != null) {
                qs.setOrdering(orderExprs, descending);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScalarExpression compileExpressionFromString(String str) {
        try {
            this.p = new JPQLParser(str, this.imports);
            ScalarExpression expr = this.compileExpression();
            if (!this.p.parseEOS()) {
                throw new QueryCompilerSyntaxException(LOCALISER.msg("021054", (Object)this.language), this.p.getIndex(), this.p.getInput());
            }
            ScalarExpression scalarExpression = expr;
            return scalarExpression;
        }
        finally {
            this.p = null;
        }
    }

    protected ScalarExpression compileExpression() {
        return this.compileOrExpression();
    }

    protected ScalarExpression compileOrExpression() {
        ScalarExpression expr = this.compileAndExpression();
        while (this.p.parseStringIgnoreCase("OR")) {
            expr = expr.ior(this.compileAndExpression());
        }
        return expr;
    }

    protected ScalarExpression compileAndExpression() {
        ScalarExpression expr = this.compileNotExpression();
        while (this.p.parseStringIgnoreCase("AND")) {
            expr = expr.and(this.compileNotExpression());
        }
        return expr;
    }

    protected ScalarExpression compileNotExpression() {
        Object expr = null;
        expr = this.p.parseStringIgnoreCase("NOT") ? this.compileEqualityExpression().not() : this.compileEqualityExpression();
        return expr;
    }

    protected ScalarExpression compileEqualityExpression() {
        ScalarExpression expr;
        block16: {
            block17: {
                expr = this.compileRelationalExpression();
                while (true) {
                    ArrayList args;
                    ScalarExpression leftexpr;
                    if (this.p.parseString("=")) {
                        expr = expr.eq(this.compileRelationalExpression());
                        continue;
                    }
                    if (this.p.parseStringIgnoreCase("NOT")) {
                        if (this.p.parseStringIgnoreCase("BETWEEN")) {
                            leftexpr = this.compileAdditiveExpression();
                            ScalarExpression rightexpr = null;
                            if (!this.p.parseStringIgnoreCase("AND")) {
                                throw new QueryCompilerSyntaxException("Expected: 'AND' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                            }
                            rightexpr = this.compileAdditiveExpression();
                            return expr.lt(leftexpr).ior((ScalarExpression)expr.gt(rightexpr));
                        }
                        if (this.p.parseStringIgnoreCase("LIKE")) {
                            return this.compileLikeExpression(expr).not();
                        }
                        if (this.p.parseStringIgnoreCase("IN")) {
                            return this.compileInExpression(expr).not();
                        }
                        if (this.p.parseStringIgnoreCase("MEMBER")) {
                            return this.compileMemberExpression(expr).not();
                        }
                        throw new QueryCompilerSyntaxException("Expected: 'BETWEEN', 'LIKE', 'IN', or 'MEMBER' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                    }
                    if (this.p.parseStringIgnoreCase("BETWEEN")) {
                        leftexpr = this.compileAdditiveExpression();
                        ScalarExpression rightexpr = null;
                        if (!this.p.parseStringIgnoreCase("AND")) {
                            throw new QueryCompilerSyntaxException("Expected: 'AND' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                        }
                        rightexpr = this.compileAdditiveExpression();
                        return expr.gteq(leftexpr).and((ScalarExpression)expr.lteq(rightexpr));
                    }
                    if (this.p.peekStringIgnoreCase("INNER")) break block16;
                    if (this.p.parseStringIgnoreCase("IN")) {
                        return this.compileInExpression(expr);
                    }
                    if (this.p.parseStringIgnoreCase("MEMBER")) {
                        return this.compileMemberExpression(expr);
                    }
                    if (this.p.parseStringIgnoreCase("LIKE")) {
                        return this.compileLikeExpression(expr);
                    }
                    if (!this.p.parseStringIgnoreCase("IS")) break block16;
                    if (this.p.parseStringIgnoreCase("NULL")) {
                        expr = expr.eq((ScalarExpression)new NullLiteral(this.qs));
                        continue;
                    }
                    if (this.p.parseStringIgnoreCase("EMPTY")) {
                        args = new ArrayList();
                        expr = expr.callMethod("isEmpty", args);
                        continue;
                    }
                    if (!this.p.parseStringIgnoreCase("NOT")) break block17;
                    if (this.p.parseStringIgnoreCase("NULL")) {
                        expr = expr.noteq((ScalarExpression)new NullLiteral(this.qs));
                        continue;
                    }
                    if (!this.p.parseStringIgnoreCase("EMPTY")) break;
                    args = new ArrayList();
                    expr = expr.callMethod("isEmpty", args).not();
                }
                throw new QueryCompilerSyntaxException("Expected: 'null' or 'empty' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            throw new QueryCompilerSyntaxException("Expected: 'null', 'empty' or 'not' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        return expr;
    }

    protected ScalarExpression compileLikeExpression(ScalarExpression expr) {
        ScalarExpression patternExpr = this.compileAdditiveExpression();
        if (this.p.parseStringIgnoreCase("ESCAPE")) {
            String escapeChars = this.p.parseStringLiteral();
            NucleusLogger.QUERY.debug((Object)(">> Found escape " + escapeChars + " but not currently used by DataNucleus"));
        }
        ArrayList<ScalarExpression> list = new ArrayList<ScalarExpression>();
        list.add(patternExpr);
        return expr.callMethod("like", list);
    }

    protected ScalarExpression compileInExpression(ScalarExpression expr) {
        BooleanExpression finalExpr = null;
        if (!this.p.parseChar('(')) {
            String inStr = this.p.parseIdentifier();
            if (this.query.hasSubqueryForVariable(inStr)) {
                SubqueryExpression inExpr = (SubqueryExpression)this.compileSubqueryVariable(inStr);
                return inExpr.in(expr);
            }
            throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        do {
            ScalarExpression inExpr;
            if ((inExpr = this.compilePrimary()) == null) {
                throw new QueryCompilerSyntaxException("Expected literal|parameter but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            BooleanExpression eqExpr = expr.eq(inExpr);
            finalExpr = finalExpr == null ? eqExpr : finalExpr.ior((ScalarExpression)eqExpr);
        } while (this.p.parseChar(','));
        if (!this.p.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        return finalExpr.encloseWithInParentheses();
    }

    protected ScalarExpression compileMemberExpression(ScalarExpression expr) {
        this.p.parseStringIgnoreCase("OF");
        ScalarExpression containerExpr = this.compileRelationalExpression();
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return containerExpr.callMethod("contains", args);
    }

    protected ScalarExpression compileRelationalExpression() {
        ScalarExpression expr = this.compileAdditiveExpression();
        while (true) {
            if (this.p.parseString("<=")) {
                expr = expr.lteq(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseString(">=")) {
                expr = expr.gteq(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseString("<>")) {
                expr = expr.noteq(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseChar('<')) {
                expr = expr.lt(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseChar('>')) {
                expr = expr.gt(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseStringIgnoreCase("INSTANCEOF")) {
                expr = expr.instanceOf(this.compileAdditiveExpression());
                continue;
            }
            if (this.p.parseStringIgnoreCase("LIKE")) {
                expr = this.compileLikeExpression(expr);
                continue;
            }
            if (!this.p.parseStringIgnoreCase("AS")) break;
            String asName = this.p.parseName();
            expr = expr.as(asName);
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ScalarExpression compilePrimary() {
        ArrayList<ScalarExpression> args;
        ScalarExpression expr;
        block48: {
            expr = this.compileLiteral();
            if (expr == null) {
                if (this.p.parseChar('(')) {
                    expr = this.compileExpression();
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                    expr.encloseWithInParentheses();
                } else if (this.p.parseChar('{')) {
                    ArrayList<ScalarExpression> exprs = new ArrayList<ScalarExpression>();
                    while (!this.p.parseChar('}')) {
                        exprs.add(this.compileExpression());
                        if (this.p.parseChar('}')) break;
                        if (this.p.parseChar(',')) continue;
                        throw new QueryCompilerSyntaxException("',' or '}' expected", this.p.getIndex(), this.p.getInput());
                    }
                    expr = new ArrayExpression(this.qs, exprs.toArray(new ScalarExpression[exprs.size()]));
                } else if (this.p.parseStringIgnoreCase("EXISTS")) {
                    expr = this.compileIdentifier();
                    if (!(expr instanceof SubqueryExpression)) throw new NucleusUserException("EXISTS can only be followed by a subquery expression");
                    ((SubqueryExpression)expr).exists();
                } else if (this.p.parseStringIgnoreCase("ALL")) {
                    expr = this.compileIdentifier();
                    if (!(expr instanceof SubqueryExpression)) throw new NucleusUserException("ALL can only be followed by a subquery expression");
                    ((SubqueryExpression)expr).all();
                } else if (this.p.parseStringIgnoreCase("ANY")) {
                    expr = this.compileIdentifier();
                    if (!(expr instanceof SubqueryExpression)) throw new NucleusUserException("ANY can only be followed by a subquery expression");
                    ((SubqueryExpression)expr).any();
                } else if (this.p.parseStringIgnoreCase("SOME")) {
                    expr = this.compileIdentifier();
                    if (!(expr instanceof SubqueryExpression)) throw new NucleusUserException("SOME can only be followed by a subquery expression");
                    ((SubqueryExpression)expr).any();
                } else {
                    String methodId = this.p.parseMethod();
                    if (methodId == null) {
                        expr = this.compileIdentifier();
                    } else if (this.p.parseChar('(')) {
                        MappedStoreManager srm;
                        if (methodId.equals("TRIM")) {
                            boolean leading = true;
                            boolean trailing = true;
                            if (this.p.parseStringIgnoreCase("LEADING")) {
                                trailing = false;
                            } else if (this.p.parseStringIgnoreCase("TRAILING")) {
                                leading = false;
                            } else if (this.p.parseStringIgnoreCase("BOTH")) {
                                // empty if block
                            }
                            this.p.parseStringIgnoreCase("FROM");
                            ScalarExpression argExpr = this.compileExpression();
                            if (!this.p.parseChar(')')) {
                                throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                            }
                            if (leading && trailing) {
                                return argExpr.callMethod("trim", Collections.EMPTY_LIST);
                            }
                            if (!leading) return argExpr.callMethod("trimRight", Collections.EMPTY_LIST);
                            return argExpr.callMethod("trimLeft", Collections.EMPTY_LIST);
                        }
                        args = new ArrayList();
                        boolean isDistinct = false;
                        if (!this.p.parseChar(')')) {
                            isDistinct = this.p.parseStringIgnoreCase("DISTINCT");
                            do {
                                ScalarExpression argExpr = this.compileExpression();
                                args.add(argExpr);
                                this.fieldExpressions.remove(argExpr);
                            } while (this.p.parseChar(','));
                            if (!this.p.parseChar(')')) {
                                throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                            }
                        }
                        Object object = srm = this.qs != null ? this.qs.getStoreManager() : this.query.getObjectManager().getStoreManager();
                        if (methodId.equalsIgnoreCase("ABS")) {
                            return new MathExpression(this.qs).absMethod((ScalarExpression)args.get(0));
                        }
                        if (methodId.equalsIgnoreCase("SQRT")) {
                            return new MathExpression(this.qs).sqrtMethod((ScalarExpression)args.get(0));
                        }
                        if (methodId.equalsIgnoreCase("CONCAT")) {
                            return ((ScalarExpression)args.get(0)).add((ScalarExpression)args.get(1));
                        }
                        if (methodId.equalsIgnoreCase("MOD")) {
                            return ((ScalarExpression)args.get(0)).mod((ScalarExpression)args.get(1));
                        }
                        if (methodId.equalsIgnoreCase("LENGTH")) {
                            return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), Collections.EMPTY_LIST);
                        }
                        if (methodId.equalsIgnoreCase("SUBSTRING")) {
                            ArrayList<ScalarExpression> argscall = new ArrayList<ScalarExpression>();
                            JavaTypeMapping mapping = srm.getMappingManager().getMapping(String.class);
                            IntegerLiteral one = new IntegerLiteral(this.qs, mapping, (Number)BigInteger.ONE, false);
                            argscall.add(((ScalarExpression)args.get(1)).sub((ScalarExpression)one));
                            if (args.size() <= 2) return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), argscall);
                            argscall.add(((ScalarExpression)args.get(2)).add((ScalarExpression)one));
                            return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), argscall);
                        }
                        if (methodId.equalsIgnoreCase("LOWER")) {
                            return ((ScalarExpression)args.get(0)).callMethod("toLowerCase", Collections.EMPTY_LIST);
                        }
                        if (methodId.equalsIgnoreCase("UPPER")) {
                            return ((ScalarExpression)args.get(0)).callMethod("toUpperCase", Collections.EMPTY_LIST);
                        }
                        if (methodId.equalsIgnoreCase("SIZE")) {
                            return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), Collections.EMPTY_LIST);
                        }
                        if (methodId.equalsIgnoreCase("LOCATE")) {
                            ArrayList argscall = new ArrayList();
                            argscall.add(args.get(0));
                            JavaTypeMapping mapping = srm.getMappingManager().getMapping(String.class);
                            IntegerLiteral one = new IntegerLiteral(this.qs, mapping, (Number)BigInteger.ONE, false);
                            if (args.size() <= 2) return ((ScalarExpression)args.get(1)).callMethod("indexOf", argscall).add((ScalarExpression)one);
                            argscall.add(((ScalarExpression)args.get(2)).sub((ScalarExpression)one));
                            return ((ScalarExpression)args.get(1)).callMethod("indexOf", argscall).add((ScalarExpression)one);
                        }
                        expr = new AggregateExpression(this.qs);
                        if (isDistinct) {
                            ((AggregateExpression)expr).setDistinct();
                        }
                        try {
                            expr = expr.callMethod(methodId.toLowerCase(), args);
                            this.fieldExpressions.add(expr);
                        }
                        catch (ScalarExpression.MethodInvocationException ex) {
                            if (!methodId.equalsIgnoreCase("Object")) break block48;
                            expr = (ScalarExpression)args.get(0);
                        }
                    }
                }
            }
        }
        while (this.p.parseChar('.')) {
            String id = this.p.parseIdentifier();
            if (id == null) {
                throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
            }
            if (this.p.parseChar('(')) {
                args = new ArrayList<ScalarExpression>();
                if (!this.p.parseChar(')')) {
                    do {
                        args.add(this.compileExpression());
                    } while (this.p.parseChar(','));
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                }
                expr = expr.callMethod(id, args);
                continue;
            }
            expr = expr.accessField(id, true);
        }
        return expr;
    }

    protected ScalarExpression compileIdentifier() {
        ScalarExpression expr;
        block31: {
            String id = this.p.parseIdentifier();
            if (id == null) {
                throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
            }
            if (JPQLQueryHelper.isKeyword((String)id)) {
                throw new QueryCompilerSyntaxException(LOCALISER.msg("021052", (Object)this.language, (Object)id), this.p.getIndex(), this.p.getInput());
            }
            MappedStoreManager srm = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
            ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
            if (id.equalsIgnoreCase("CURRENT_DATE")) {
                return new TemporalExpression(this.qs).currentDateMethod();
            }
            if (id.equalsIgnoreCase("CURRENT_TIME")) {
                return new TemporalExpression(this.qs).currentTimeMethod();
            }
            if (id.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                return new TemporalExpression(this.qs).currentTimestampMethod();
            }
            if (id.equalsIgnoreCase("true")) {
                JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(Boolean.class, false, false, clr);
                return m.newLiteral(this.qs, (Object)Boolean.TRUE);
            }
            if (id.equalsIgnoreCase("false")) {
                JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(Boolean.class, false, false, clr);
                return m.newLiteral(this.qs, (Object)Boolean.FALSE);
            }
            if (id.startsWith(":")) {
                return this.compileNamedImplicitParameter(id);
            }
            if (id.startsWith("?")) {
                return this.compileNumberedImplicitParameter(id);
            }
            if (id.equalsIgnoreCase("NEW")) {
                return this.compileNewObject();
            }
            if (this.query.hasSubqueryForVariable(id)) {
                return this.compileSubqueryVariable(id);
            }
            if (this.variableNames.contains(id)) {
                return this.compileExplicitVariable(id);
            }
            try {
                expr = this.qs.getMainTableExpression().newFieldExpression(id);
                if (!id.equalsIgnoreCase(this.candidateAlias)) {
                    if (this.candidateCmd == null) {
                        this.candidateCmd = this.query.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                    }
                    if (this.candidateCmd.getMetaDataForMember(id) == null) {
                        throw new NucleusUserException(LOCALISER.msg("021049", (Object)id));
                    }
                }
                this.fieldExpressions.add(expr);
            }
            catch (NoSuchPersistentFieldException nspfe) {
                QueryCompiler.AliasJoinInformation aliasInfo = this.aliases.get(id.toUpperCase());
                if (aliasInfo == null && this.parentCompiler != null) {
                    aliasInfo = this.parentCompiler.aliases.get(id.toUpperCase());
                }
                if (aliasInfo != null) {
                    DatastoreClass table = srm.getDatastoreClass(aliasInfo.cls.getName(), clr);
                    if (aliasInfo.tableExpression == null) {
                        if (aliasInfo.alias.equalsIgnoreCase(this.candidateAlias)) {
                            aliasInfo.tableExpression = this.qs.getMainTableExpression();
                        } else {
                            DatastoreIdentifier tableId = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, aliasInfo.alias);
                            aliasInfo.tableExpression = this.qs.newTableExpression((DatastoreContainerObject)table, tableId);
                        }
                    }
                    return table.getIDMapping().newScalarExpression(this.qs, aliasInfo.tableExpression);
                }
                String name = id;
                if (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    name = name + ".";
                    name = name + this.p.parseName();
                }
                Class cls = null;
                try {
                    cls = this.query.resolveClassDeclaration(name);
                    expr = new ClassExpression(this.qs, cls);
                }
                catch (NucleusUserException jdoe) {
                    if (aliasInfo == null && name.indexOf(46) > 0) {
                        String partialName = name.substring(0, name.lastIndexOf(46));
                        String finalNamePart = name.substring(name.lastIndexOf(46) + 1);
                        try {
                            expr = this.callUserDefinedScalarExpression(name);
                            if (expr == null) {
                                cls = this.query.resolveClassDeclaration(partialName);
                                expr = new ClassExpression(this.qs, cls);
                                expr = expr.accessField(finalNamePart, true);
                            }
                            break block31;
                        }
                        catch (NucleusUserException jdoe2) {
                            throw new NucleusUserException(LOCALISER.msg("021066", (Object)partialName), (Throwable)jdoe2);
                        }
                    }
                    try {
                        expr = new ClassExpression(this.qs, this.candidateClass);
                        expr = expr.accessField(name, true);
                    }
                    catch (NucleusUserException jdoe2) {
                        expr = (ScalarExpression)this.expressionsByVariableName.get(name);
                        if (expr != null) break block31;
                        expr = new UnboundVariable(this.qs, name, aliasInfo.cls, (UnboundVariable.VariableBinder)this);
                        this.variableNames.add(name);
                        this.fieldExpressions.add(expr);
                    }
                }
            }
        }
        return expr;
    }

    protected ScalarExpression compileSubqueryVariable(String id) {
        Query.SubqueryDefinition subqueryDef = this.query.getSubqueryForVariable(id);
        JPQLQueryCompiler subCompiler = new JPQLQueryCompiler((AbstractJPQLQuery)subqueryDef.getQuery(), this.imports, this.parameters);
        subCompiler.processAsSubquery(this);
        QueryExpression subqueryExpr = (QueryExpression)subCompiler.compile(4);
        subCompiler.getCandidates().newResultObjectFactory(subqueryExpr, false, subCompiler.getResultClass(), true);
        SubqueryExpression expr = new SubqueryExpression(this.qs, subqueryExpr);
        Set subProcessedParams = subCompiler.processedParameters;
        if (subProcessedParams != null) {
            for (String param : subProcessedParams) {
                if (this.processedParameters == null) {
                    this.processedParameters = new HashSet();
                }
                this.processedParameters.add(param);
            }
        }
        this.expressionsByVariableName.put(id, expr);
        return expr;
    }

    protected ScalarExpression compileNamedImplicitParameter(String id) {
        MappedStoreManager srm = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        id = id.substring(1);
        if (this.processedParameters == null) {
            this.processedParameters = new HashSet();
        }
        this.processedParameters.add(id);
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(id)) {
                Object paramValue = this.parameters.get(id);
                if (paramValue != null) {
                    JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(paramValue.getClass(), false, false, clr);
                    ScalarExpression paramExpr = m.newLiteral(this.qs, paramValue);
                    paramExpr.setParameterName(id);
                    paramExpr.checkForTypeAssignability();
                    return paramExpr;
                }
                return new NullLiteral(this.qs);
            }
            if (!this.executionCompile) {
                return new UnknownLiteral(this.qs);
            }
            throw new NucleusUserException(LOCALISER.msg("021112", (Object)id));
        }
        throw new NucleusUserException(LOCALISER.msg("021112", (Object)id));
    }

    protected ScalarExpression compileNumberedImplicitParameter(String id) {
        MappedStoreManager srm = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
        id = id.substring(1);
        Integer position = new Integer(id);
        if (this.processedParameters == null) {
            this.processedParameters = new HashSet();
        }
        this.processedParameters.add(position);
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(position)) {
                Object paramValue = this.parameters.get(position);
                if (paramValue != null) {
                    JavaTypeMapping m = srm.getMappingManager().getMappingWithDatastoreMapping(paramValue.getClass(), false, false, clr);
                    ScalarExpression paramExpr = m.newLiteral(this.qs, paramValue);
                    paramExpr.setParameterName(id);
                    paramExpr.checkForTypeAssignability();
                    return paramExpr;
                }
                return new NullLiteral(this.qs);
            }
            if (!this.executionCompile) {
                return new UnknownLiteral(this.qs);
            }
            throw new NucleusUserException(LOCALISER.msg("021112", (Object)("" + position)));
        }
        throw new NucleusUserException(LOCALISER.msg("021112", (Object)("" + position)));
    }
}

