/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.query.legacy.AbstractRDBMSExtent;
import org.datanucleus.store.rdbms.query.legacy.TransientIDROF;
import org.datanucleus.util.Localiser;

public class ClassViewExtent
extends AbstractRDBMSExtent
implements Queryable {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private final DatastoreClass view;
    private final int fieldCount;
    private final int[] prefetchFieldNumbers;
    private final StatementMappingIndex[] stmtMappings;

    public ClassViewExtent(ObjectManager om, DatastoreClass view, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.view = view;
        this.fieldCount = cmd.getNoOfManagedMembers();
        int[] fn = new int[this.fieldCount];
        this.stmtMappings = new StatementMappingIndex[this.fieldCount];
        int prefetchFieldCount = 0;
        for (int i = 0; i < this.fieldCount; ++i) {
            JavaTypeMapping m = view.getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(i));
            if (m == null) continue;
            if (!m.includeInFetchStatement() || m instanceof AbstractContainerMapping) {
                throw new NucleusException(LOCALISER_RDBMS.msg("053001", (Object)m, (Object)this.candidateClass.getName())).setFatal();
            }
            this.stmtMappings[i] = new StatementMappingIndex(m);
            fn[prefetchFieldCount++] = i;
        }
        if (prefetchFieldCount == 0) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("053000", (Object)this.candidateClass.getName())).setFatal();
        }
        this.prefetchFieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, this.prefetchFieldNumbers, 0, prefetchFieldCount);
    }

    public QueryExpression newQueryStatement() {
        return ((MappedStoreManager)this.storeMgr).getDatastoreAdapter().newQueryStatement((DatastoreContainerObject)this.view, null, this.om.getClassLoaderResolver());
    }

    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias) {
        String extentType = this.view.getType();
        if (!extentType.equals(candidateClass.getName())) {
            throw new IncompatibleQueryElementTypeException(extentType, candidateClass.getName());
        }
        return ((MappedStoreManager)this.storeMgr).getDatastoreAdapter().newQueryStatement((DatastoreContainerObject)this.view, null, this.om.getClassLoaderResolver());
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        for (int i = 0; i < this.stmtMappings.length; ++i) {
            ExpressionHelper.selectMapping((StatementMappingIndex)this.stmtMappings[i], (QueryExpression)stmt, null, (ClassLoaderResolver)clr);
        }
        return new TransientIDROF(this.getCandidateClass(), this.prefetchFieldNumbers, this.stmtMappings);
    }

    public boolean isEmpty() {
        return false;
    }
}

