/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLiteral
extends ArrayExpression
implements SQLLiteral {
    final Object value;
    private List<SQLExpression> elementExpressions;

    public ArrayLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        this.value = value;
        if (value != null && !value.getClass().isArray()) {
            throw new NucleusUserException("Invalid argument literal : " + value);
        }
        if (this.isParameter) {
            this.st.appendParameter(mapping, null);
        } else {
            this.setStatement();
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public List<SQLExpression> getElementExpressions() {
        return this.elementExpressions;
    }

    @Override
    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.value != null && Array.getLength(this.value) > 0) {
            RDBMSManager storeMgr = this.stmt.getRDBMSManager();
            this.elementExpressions = new ArrayList<SQLExpression>();
            this.st.append("(");
            boolean hadPrev = false;
            for (int i = 0; i < Array.getLength(this.value); ++i) {
                Object current = Array.get(this.value, i);
                if (current == null) continue;
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                SQLExpression expr = storeMgr.getSQLExpressionFactory().newLiteral(this.stmt, m, current);
                this.st.append(hadPrev ? "," : "");
                this.st.append(expr);
                this.elementExpressions.add(expr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }
}

