/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.CastExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.query2.QueryGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NewObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToSQLMapper
extends AbstractExpressionEvaluator
implements QueryGenerator {
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final QueryCompilation compilation;
    final Map parameters;
    final SQLStatement stmt;
    final StatementClassMapping resultDefinitionForClass;
    final StatementResultMapping resultDefinition;
    StatementParameterMapping parameterDefinition;
    final RDBMSManager storeMgr;
    final FetchPlan fetchPlan;
    final SQLExpressionFactory exprFactory;
    ObjectManager om;
    ClassLoaderResolver clr;
    Map<String, Object> compileProperties = new HashMap<String, Object>();
    CompilationComponent compileComponent;
    int paramNumber = 1;
    Stack<SQLExpression> stack = new Stack();
    Map<String, SQLTableMapping> sqlTableByPrimary = new HashMap<String, SQLTableMapping>();
    Map<SQLExpression, int[]> paramPositionByExpression = new HashMap<SQLExpression, int[]>();
    boolean caseInsensitive = false;
    boolean precompilable = true;

    public QueryToSQLMapper(SQLStatement stmt, QueryCompilation compilation, Map parameters, StatementClassMapping resultDefForClass, StatementResultMapping resultDef, AbstractClassMetaData cmd, FetchPlan fetchPlan, StatementParameterMapping paramInfo, ObjectManager om) {
        this.parameters = parameters;
        this.compilation = compilation;
        this.stmt = stmt;
        this.resultDefinitionForClass = resultDefForClass;
        this.resultDefinition = resultDef;
        this.parameterDefinition = paramInfo;
        this.candidateAlias = compilation.getCandidateAlias();
        this.fetchPlan = fetchPlan;
        this.storeMgr = stmt.getRDBMSManager();
        this.exprFactory = stmt.getRDBMSManager().getSQLExpressionFactory();
        this.candidateCmd = cmd;
        this.om = om;
        this.clr = om.getClassLoaderResolver();
        if (compilation.getQueryLanguage().equalsIgnoreCase("JPQL")) {
            this.caseInsensitive = true;
        }
        this.stmt.setQueryGenerator(this);
        SQLTableMapping tblMapping = new SQLTableMapping(stmt.getPrimaryTable(), this.candidateCmd, stmt.getPrimaryTable().getTable().getIDMapping());
        this.setSQLTableMappingForAlias(this.candidateAlias, tblMapping);
    }

    @Override
    public String getQueryLanguage() {
        return this.compilation.getQueryLanguage();
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public CompilationComponent getCompilationComponent() {
        return this.compileComponent;
    }

    @Override
    public ObjectManager getObjectManager() {
        return this.om;
    }

    @Override
    public Object getProperty(String name) {
        return this.compileProperties.get(name);
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    @Override
    public void useParameterExpressionAsLiteral(SQLLiteral paramLiteral) {
        int[] exprPositions = this.paramPositionByExpression.get(paramLiteral);
        if (exprPositions != null) {
            int increment = exprPositions.length;
            String[] paramNames = this.parameterDefinition.getParameterNames();
            for (int i = 0; i < paramNames.length; ++i) {
                StatementMappingIndex idx = this.parameterDefinition.getMappingForParameter(paramNames[i]);
                int numOccurs = idx.getNumberOfParameterOccurrences();
                for (int j = 0; j < numOccurs; ++j) {
                    int[] posns = idx.getParameterPositionsForOccurrence(j);
                    if (posns[0] == exprPositions[0]) {
                        idx.removeParameterOccurrence(posns);
                        this.paramNumber -= increment;
                        NucleusLogger.QUERY.debug((Object)(">> Removed parameter positions for " + paramLiteral + " : was " + StringUtils.intArrayToString((int[])exprPositions)));
                        continue;
                    }
                    if (posns[0] <= exprPositions[0]) continue;
                    for (int k = 0; k < posns.length; ++k) {
                        posns[k] = posns[k] - increment;
                    }
                    NucleusLogger.QUERY.debug((Object)(">> Incremented back parameter positions for " + paramLiteral + " to " + StringUtils.intArrayToString((int[])posns)));
                }
            }
        }
        paramLiteral.setNotParameter();
        this.precompilable = false;
    }

    public void compile() {
        String[] paramNames;
        int i;
        NucleusLogger.QUERY.debug((Object)this.compilation.toString());
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (i = 0; i < fromExprs.length; ++i) {
                ClassExpression clsExpr = (ClassExpression)fromExprs[i];
                this.compileFromClassExpression(clsExpr);
            }
        }
        if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            Expression[] resultExprs = this.compilation.getExprResult();
            for (i = 0; i < resultExprs.length; ++i) {
                StatementMappingIndex idx;
                SQLExpression sqlExpr;
                if (resultExprs[i] instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    int col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    if (sqlExpr instanceof SQLLiteral) {
                        int col = this.stmt.select(sqlExpr, null);
                        idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                        idx.setColumnPositions(new int[]{col});
                        this.resultDefinition.addMappingForResultExpression(i, idx);
                        continue;
                    }
                    int[] cols = this.stmt.select(sqlExpr.getSQLTable(), sqlExpr.getJavaTypeMapping(), null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols);
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    int col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    int col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof Literal) {
                    this.processLiteral((Literal)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    int col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof CreatorExpression) {
                    this.processCreatorExpression((CreatorExpression)resultExprs[i]);
                    sqlExpr = (NewObjectExpression)this.stack.pop();
                    StatementNewObjectMapping stmtMap = this.getStatementMappingForNewObjectExpression((NewObjectExpression)sqlExpr);
                    this.resultDefinition.addMappingForResultExpression(i, stmtMap);
                    continue;
                }
                throw new NucleusException("Dont currently support result clause containing expression of type " + resultExprs[i]);
            }
            if (this.stmt.getNumberOfSelects() == 0) {
                this.stmt.select(this.exprFactory.newLiteral(this.stmt, this.storeMgr.getMappingManager().getMapping(Integer.class), 1), null);
            }
        } else {
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.fetchPlan, this.candidateCmd, 1);
        }
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            if (QueryUtils.expressionHasOrOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.OR", true);
            }
            if (QueryUtils.expressionHasNotOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.NOT", true);
            }
            BooleanExpression filterExpr = (BooleanExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
            this.stmt.whereAnd(filterExpr, true);
        }
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (i = 0; i < groupExprs.length; ++i) {
                Expression groupExpr = groupExprs[i];
                SQLExpression sqlGroupExpr = (SQLExpression)groupExpr.evaluate((ExpressionEvaluator)this);
                this.stmt.addGroupingExpression(sqlGroupExpr);
            }
        }
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            Expression havingExpr = this.compilation.getExprHaving();
            BooleanExpression sqlHavingExpr = (BooleanExpression)havingExpr.evaluate((ExpressionEvaluator)this);
            this.stmt.setHaving(sqlHavingExpr);
        }
        if (this.stmt.getNumberOfUnions() > 0 && (paramNames = this.parameterDefinition.getParameterNames()) != null) {
            HashMap<String, Integer> paramCols = new HashMap<String, Integer>();
            for (int j = 0; j < paramNames.length; ++j) {
                StatementMappingIndex idx = this.parameterDefinition.getMappingForParameter(paramNames[j]);
                paramCols.put(paramNames[j], idx.getNumberOfParameterOccurrences());
            }
            for (int i2 = 0; i2 < this.stmt.getNumberOfUnions(); ++i2) {
                for (int j = 0; j < paramNames.length; ++j) {
                    int numOccurrences = (Integer)paramCols.get(paramNames[j]);
                    StatementMappingIndex idx = this.parameterDefinition.getMappingForParameter(paramNames[j]);
                    for (int k = 0; k < numOccurrences; ++k) {
                        int[] paramPositions = idx.getParameterPositionsForOccurrence(k);
                        int[] newPositions = new int[paramPositions.length];
                        for (int l = 0; l < newPositions.length; ++l) {
                            ++this.paramNumber;
                        }
                        idx.addParameterOccurrence(newPositions);
                    }
                }
            }
        }
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            SQLExpression[] orderSqlExprs = new SQLExpression[orderingExpr.length];
            boolean[] directions = new boolean[orderingExpr.length];
            for (int i3 = 0; i3 < orderingExpr.length; ++i3) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i3];
                orderSqlExprs[i3] = (SQLExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                String orderDir = orderExpr.getSortOrder();
                directions[i3] = orderDir != null && !orderDir.equals("ascending");
            }
            this.stmt.setOrdering(orderSqlExprs, directions);
        }
        this.compileComponent = null;
        Collection symbols = this.compilation.getSymbolTable().getSymbolNames();
        Iterator symIter = symbols.iterator();
        while (symIter.hasNext()) {
            Symbol sym = this.compilation.getSymbolTable().getSymbol((String)symIter.next());
            if (sym.getType() != 2 || this.hasSQLTableMappingForAlias(sym.getQualifiedName())) continue;
            throw new QueryCompilerSyntaxException("Query has variable \"" + sym.getQualifiedName() + "\" which is not bound to the query");
        }
    }

    protected void compileFromClassExpression(ClassExpression clsExpr) {
        Symbol clsExprSym = clsExpr.getSymbol();
        Class baseCls = clsExprSym.getValueType();
        SQLTable candSqlTbl = this.stmt.getPrimaryTable();
        AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(baseCls, this.clr);
        if (baseCls != null && baseCls != this.compilation.getCandidateClass()) {
            DatastoreClass candTbl = this.storeMgr.getDatastoreClass(baseCls.getName(), this.clr);
            candSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)candTbl, clsExpr.getAlias(), null);
            SQLTableMapping tblMapping = new SQLTableMapping(candSqlTbl, cmd, candTbl.getIDMapping());
            this.setSQLTableMappingForAlias(clsExpr.getAlias(), tblMapping);
        }
        for (Expression rightExpr = clsExpr.getRight(); rightExpr != null; rightExpr = rightExpr.getRight()) {
            if (!(rightExpr instanceof JoinExpression)) continue;
            JoinExpression joinExpr = (JoinExpression)rightExpr;
            JoinExpression.JoinType joinType = joinExpr.getType();
            String joinAlias = joinExpr.getAlias();
            PrimaryExpression joinPrimExpr = joinExpr.getPrimaryExpression();
            List joinPrimTuples = joinPrimExpr.getTuples();
            Iterator iter = joinPrimTuples.iterator();
            iter.next();
            SQLTable sqlTbl = candSqlTbl;
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(id);
                int relationType = mmd.getRelationType(this.clr);
                DatastoreClass relTable = null;
                AbstractMemberMetaData relMmd = null;
                switch (relationType) {
                    case 1: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                        break;
                    }
                    case 2: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        if (mmd.getMappedBy() != null) {
                            relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, null);
                                break;
                            }
                            sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, null);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                        break;
                    }
                    case 4: {
                        SQLTable joinSqlTbl;
                        CollectionTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, null);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, null);
                        break;
                    }
                    case 3: {
                        SQLTable joinSqlTbl;
                        CollectionTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                        if (mmd.getJoinMetaData() != null) {
                            joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        JavaTypeMapping relMapping = relTable.getExternalMapping(mmd, 5);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, null);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, null);
                        break;
                    }
                    case 5: {
                        SQLTable joinSqlTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        CollectionTable joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                        sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                        break;
                    }
                    case 6: {
                        SQLTable joinSqlTbl;
                        CollectionTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(relMmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        JavaTypeMapping fkMapping = sqlTbl.getTable().getMemberMapping(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIDMapping(), null, null);
                        break;
                    }
                }
            }
            SQLTableMapping tblMapping = new SQLTableMapping(sqlTbl, cmd, sqlTbl.getTable().getIDMapping());
            this.setSQLTableMappingForAlias(joinAlias, tblMapping);
        }
    }

    protected StatementNewObjectMapping getStatementMappingForNewObjectExpression(NewObjectExpression expr) {
        List<SQLExpression> argExprs = expr.getConstructorArgExpressions();
        StatementNewObjectMapping stmtMap = new StatementNewObjectMapping(expr.getNewClass());
        if (argExprs != null) {
            Iterator<SQLExpression> argIter = argExprs.iterator();
            int j = 0;
            while (argIter.hasNext()) {
                SQLExpression argExpr = argIter.next();
                if (argExpr instanceof SQLLiteral) {
                    stmtMap.addConstructorArgMapping(j, ((SQLLiteral)((Object)argExpr)).getValue());
                } else if (argExpr instanceof NewObjectExpression) {
                    stmtMap.addConstructorArgMapping(j, (Object)this.getStatementMappingForNewObjectExpression((NewObjectExpression)argExpr));
                } else {
                    StatementMappingIndex idx = new StatementMappingIndex(argExpr.getJavaTypeMapping());
                    int col = this.stmt.select(argExpr, null);
                    idx.setColumnPositions(new int[]{col});
                    stmtMap.addConstructorArgMapping(j, (Object)idx);
                }
                ++j;
            }
        }
        return stmtMap;
    }

    protected Object processAndExpression(Expression expr) {
        BooleanExpression rightExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression leftExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression opExpr = leftExpr.and(rightExpr);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processOrExpression(Expression expr) {
        BooleanExpression rightExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression leftExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression opExpr = leftExpr.ior(rightExpr);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processEqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        BooleanExpression opExpr = left.eq(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        BooleanExpression opExpr = left.ne(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.ge(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.gt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.le(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.lt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Class) {
            litValue = ((Class)litValue).getName();
        }
        JavaTypeMapping m = null;
        if (litValue != null) {
            m = this.exprFactory.getMappingForType(litValue.getClass(), false);
        }
        SQLExpression sqlExpr = this.exprFactory.newLiteral(this.stmt, m, litValue);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        SQLExpression sqlExpr = null;
        if (expr.getLeft() != null) {
            if (expr.getLeft() instanceof ParameterExpression) {
                String fieldName;
                this.precompilable = false;
                ParameterExpression paramExpr = (ParameterExpression)expr.getLeft();
                Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramExpr.getId());
                if (paramSym.getValueType().isArray()) {
                    String first = (String)expr.getTuples().get(0);
                    this.processParameterExpression(paramExpr, true);
                    SQLExpression paramSqlExpr = this.stack.pop();
                    sqlExpr = this.exprFactory.invokeMethod(this.stmt, "ARRAY", first, paramSqlExpr, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                this.processParameterExpression(paramExpr, true);
                SQLExpression paramSqlExpr = this.stack.pop();
                SQLLiteral lit = (SQLLiteral)((Object)paramSqlExpr);
                Object paramValue = lit.getValue();
                List tuples = expr.getTuples();
                Iterator tuplesIter = tuples.iterator();
                Object objValue = paramValue;
                while (tuplesIter.hasNext() && (objValue = this.getValueForObjectField(objValue, fieldName = (String)tuplesIter.next())) != null) {
                }
                if (objValue == null) {
                    sqlExpr = this.exprFactory.newLiteral(this.stmt, null, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(objValue.getClass(), false);
                sqlExpr = this.exprFactory.newLiteral(this.stmt, m, objValue);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof VariableExpression) {
                VariableExpression varExpr = (VariableExpression)expr.getLeft();
                this.processVariableExpression(varExpr);
                SQLExpression varSqlExpr = this.stack.pop();
                NucleusLogger.QUERY.debug((Object)(">> PrimaryExpr left(var)=" + expr.getLeft() + " id=" + expr.getId() + " varExpr=" + varSqlExpr + " varType=" + varSqlExpr.getJavaTypeMapping().getType() + " varExpr.tbl=" + varSqlExpr.getSQLTable() + " stmt=" + this.stmt + " varExpr.stmt=" + varSqlExpr.getSQLStatement()));
                Class varType = this.clr.classForName(varSqlExpr.getJavaTypeMapping().getType());
                AbstractClassMetaData varCmd = this.om.getMetaDataManager().getMetaDataForClass(varType, this.clr);
                if (varCmd != null) {
                    SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(varExpr.getId(), expr.getTuples(), false);
                    NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processPrimary (VAR) sqlMapping=" + sqlMapping + " stmt(after)=" + this.stmt.getSelectStatement().toSQL()));
                }
                throw new NucleusUserException("Dont currently support VariableExpression.field(s) : " + expr.getLeft() + "." + expr.getId());
            }
            if (expr.getLeft() instanceof CastExpression) {
                CastExpression castExpr = (CastExpression)expr.getLeft();
                PrimaryExpression castLeftExpr = (PrimaryExpression)castExpr.getLeft();
                this.processPrimaryExpressionInternal(castLeftExpr, true);
                SQLExpression castLeftSqlExpr = this.stack.pop();
                String castClassName = castExpr.getClassName();
                SQLExpression castClassNameExpr = this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(String.class, false), castClassName);
                sqlExpr = castLeftSqlExpr.cast(castClassNameExpr);
                String exprPrimName = "CAST_" + castLeftExpr.getId();
                AbstractClassMetaData castCmd = this.om.getMetaDataManager().getMetaDataForClass(castClassName, this.clr);
                SQLTableMapping tblMapping = new SQLTableMapping(sqlExpr.getSQLTable(), castCmd, sqlExpr.getJavaTypeMapping());
                this.setSQLTableMappingForAlias(exprPrimName, tblMapping);
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(exprPrimName, expr.getTuples(), false);
                if (sqlMapping == null) {
                    throw new NucleusException("PrimaryExpression " + expr + " is not yet supported");
                }
                sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)expr.getLeft());
                SQLExpression invokeSqlExpr = this.stack.pop();
                throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr);
            }
            throw new NucleusUserException("Dont currently support PrimaryExpression with 'left' of " + expr.getLeft());
        }
        return this.processPrimaryExpressionInternal(expr, false);
    }

    private SQLExpression processPrimaryExpressionInternal(PrimaryExpression primExpr, boolean forceJoin) {
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(null, primExpr.getTuples(), forceJoin);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + primExpr.getId() + " is not yet supported");
        }
        SQLExpression sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    private SQLTableMapping getSQLTableMappingForPrimaryExpression(String exprName, List<String> tuples, boolean forceJoin) {
        SQLTableMapping sqlMapping = null;
        Iterator<String> iter = tuples.iterator();
        String first = tuples.get(0);
        String primaryName = null;
        if (exprName != null) {
            sqlMapping = this.getSQLTableMappingForAlias(exprName);
            primaryName = exprName;
        } else if (this.hasSQLTableMappingForAlias(first)) {
            sqlMapping = this.getSQLTableMappingForAlias(first);
            primaryName = first;
            iter.next();
        } else {
            sqlMapping = this.getSQLTableMappingForAlias(this.candidateAlias);
            primaryName = this.candidateAlias;
        }
        while (iter.hasNext()) {
            String component = iter.next();
            SQLTableMapping sqlMappingNew = this.getSQLTableMappingForAlias(primaryName = primaryName + "." + component);
            if (sqlMappingNew == null) {
                AbstractMemberMetaData mmd = sqlMapping.cmd.getMetaDataForMember(component);
                if (mmd == null) {
                    throw new NucleusUserException("Query contains access of " + primaryName + " yet this field/property doesnt exist");
                }
                int relationType = mmd.getRelationType(this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(sqlMapping.cmd.getFullClassName(), this.clr);
                JavaTypeMapping mapping = table.getMemberMapping(mmd);
                SQLTable sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(this.stmt, sqlMapping.table, mapping);
                switch (relationType) {
                    case 0: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        if (mmd.getMappedBy() != null) {
                            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            DatastoreClass relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                            JavaTypeMapping relMapping = relTable.getMemberMapping(relMmd);
                            sqlTbl = this.stmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(this.stmt, sqlMapping.table.getTable().getIDMapping(), sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, primaryName);
                            }
                            if (iter.hasNext()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIDMapping());
                                break;
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, relTable.getIDMapping());
                            break;
                        }
                        if (iter.hasNext() || forceJoin) {
                            AbstractClassMetaData relCmd = null;
                            JavaTypeMapping relMapping = null;
                            DatastoreClass relTable = null;
                            if (relationType == 2) {
                                AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                relCmd = relMmd.getAbstractClassMetaData();
                            } else {
                                relCmd = this.om.getMetaDataManager().getMetaDataForClass(mmd.getTypeName(), this.clr);
                            }
                            relTable = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                            relMapping = relTable.getIDMapping();
                            sqlTbl = this.stmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(this.stmt, mapping, sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, primaryName);
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, relMapping);
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            break;
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                }
            }
            sqlMapping = sqlMappingNew;
        }
        return sqlMapping;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return this.processParameterExpression(expr, false);
    }

    protected Object processParameterExpression(ParameterExpression expr, boolean asLiteral) {
        Object paramValue = null;
        if (this.parameters != null && this.parameters.containsKey(expr.getId())) {
            paramValue = this.parameters.get(expr.getId());
        }
        JavaTypeMapping m = null;
        StatementMappingIndex paramIdx = this.parameterDefinition.getMappingForParameter(expr.getId());
        if (paramIdx != null) {
            m = paramIdx.getMapping();
        } else if (paramValue != null) {
            m = this.exprFactory.getMappingForType(paramValue.getClass(), false);
            if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                if (!QueryUtils.queryParameterTypesAreCompatible((Class)expr.getSymbol().getValueType(), paramValue.getClass())) {
                    throw new QueryCompilerSyntaxException("Supplied parameter " + expr.getId() + " is declared as " + expr.getSymbol().getValueType().getName() + " yet a value of type " + paramValue.getClass().getName() + " was supplied");
                }
                if (expr.getSymbol().getValueType() != paramValue.getClass()) {
                    this.precompilable = false;
                }
            }
        } else if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
            m = this.exprFactory.getMappingForType(expr.getSymbol().getValueType(), false);
        }
        SQLExpression sqlExpr = null;
        if (asLiteral && paramValue != null) {
            sqlExpr = this.exprFactory.newLiteral(this.stmt, m, paramValue);
        } else {
            sqlExpr = this.exprFactory.newLiteralParameter(this.stmt, m, paramValue);
            if (sqlExpr instanceof ParameterLiteral) {
                ((ParameterLiteral)sqlExpr).setName(expr.getId());
            }
            if (paramIdx == null) {
                paramIdx = new StatementMappingIndex(m);
            }
            int[] paramPositions = null;
            if (m == null) {
                paramPositions = new int[]{this.paramNumber++};
            } else {
                paramPositions = new int[m.getNumberOfDatastoreFields()];
                for (int i = 0; i < paramPositions.length; ++i) {
                    ++this.paramNumber;
                }
            }
            paramIdx.addParameterOccurrence(paramPositions);
            this.paramPositionByExpression.put(sqlExpr, paramPositions);
            this.parameterDefinition.addMappingForParameter(expr.getId(), paramIdx);
        }
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        SQLExpression invokedSqlExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof Literal) {
                this.processLiteral((Literal)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.precompilable = false;
                this.processParameterExpression((ParameterExpression)invokedExpr, true);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else {
                throw new NucleusException("Dont currently support invoke expression " + invokedExpr);
            }
        }
        String operation = expr.getOperation();
        List args = expr.getArguments();
        ArrayList<SQLExpression> sqlExprArgs = null;
        if (args != null) {
            sqlExprArgs = new ArrayList<SQLExpression>();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof DyadicExpression) {
                    argExpr.evaluate((ExpressionEvaluator)this);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                throw new NucleusException("Dont currently support invoke expression argument " + argExpr);
            }
        }
        SQLExpression sqlExpr = null;
        sqlExpr = invokedSqlExpr != null ? invokedSqlExpr.invoke(operation, sqlExprArgs) : this.exprFactory.invokeMethod(this.stmt, null, operation, null, sqlExprArgs);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processAddExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.add(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDivExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.div(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processMulExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mul(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processSubExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.sub(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processComExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.com();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processModExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mod(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNegExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.neg();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNotExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        BooleanExpression resultExpr = sqlExpr.not();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processCastExpression(CastExpression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression instanceofExpr = left.cast(right);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processIsExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        String className = expr.getId();
        Class cls = this.clr.classForName(className);
        ArrayList<SQLExpression> ctrArgExprs = null;
        List args = expr.getArguments();
        if (args != null) {
            ctrArgExprs = new ArrayList<SQLExpression>(args.size());
            for (Expression argExpr : args) {
                SQLExpression sqlExpr = (SQLExpression)this.evaluate(argExpr);
                ctrArgExprs.add(sqlExpr);
            }
        }
        NewObjectExpression newExpr = new NewObjectExpression(this.stmt, cls, ctrArgExprs);
        this.stack.push(newExpr);
        return newExpr;
    }

    protected Object processLikeExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(right);
        SQLExpression likeExpr = this.exprFactory.invokeMethod(this.stmt, String.class.getName(), "like", left, args);
        this.stack.push(likeExpr);
        return likeExpr;
    }

    protected Object processVariableExpression(VariableExpression expr) {
        Symbol varSym = expr.getSymbol();
        String varName = varSym.getQualifiedName();
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable expr=" + expr + " var=" + varName));
        QueryCompilation subCompilation = this.compilation.getCompilationForSubquery(varName);
        if (this.hasSQLTableMappingForAlias(varName)) {
            SQLTableMapping tblMapping = this.getSQLTableMappingForAlias(varName);
            NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable var=" + varName + " tableMapping=" + tblMapping));
            SQLExpression sqlExpr = this.exprFactory.newExpression(this.stmt, tblMapping.table, tblMapping.mapping);
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (subCompilation != null) {
            throw new QueryCompilerSyntaxException("Query makes use of subquery " + varName + " but subqueries not yet supported");
        }
        AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(varSym.getValueType(), this.clr);
        if (cmd != null) {
            DatastoreClass varTable = this.storeMgr.getDatastoreClass(varSym.getValueType().getName(), this.clr);
            SQLTable varSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)varTable, "VAR_" + varName, null);
            SQLTableMapping varSqlTblMapping = new SQLTableMapping(varSqlTbl, cmd, varTable.getIDMapping());
            this.setSQLTableMappingForAlias(varName, varSqlTblMapping);
            SQLExpression sqlExpr = this.exprFactory.newExpression(this.stmt, varSqlTbl, varTable.getIDMapping());
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        throw new NucleusUserException("We dont currently support " + expr);
    }

    protected SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, JavaTypeMapping mapping) {
        String paramName = paramLit.getName();
        StatementMappingIndex paramIdxOld = this.parameterDefinition.getMappingForParameter(paramName);
        if (paramIdxOld.getMapping() == null) {
            StatementMappingIndex paramIdxNew = new StatementMappingIndex(mapping);
            for (int i = 0; i < paramIdxOld.getNumberOfParameterOccurrences(); ++i) {
                paramIdxNew.addParameterOccurrence(paramIdxOld.getParameterPositionsForOccurrence(i));
            }
            this.parameterDefinition.addMappingForParameter(paramName, paramIdxNew);
        }
        SQLExpression paramExpr = this.exprFactory.newLiteralParameter(this.stmt, mapping, paramLit.getValue());
        int[] positions = this.paramPositionByExpression.get(paramLit);
        if (positions != null) {
            this.paramPositionByExpression.remove(paramLit);
            this.paramPositionByExpression.put(paramExpr, positions);
        }
        return paramExpr;
    }

    protected Object getValueForObjectField(Object obj, String fieldName) {
        if (obj != null) {
            Object paramFieldValue = null;
            if (this.om.getApiAdapter().isPersistable(obj)) {
                StateManager paramSM = this.om.findStateManager(obj);
                AbstractClassMetaData paramCmd = this.om.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                AbstractMemberMetaData paramFieldMmd = paramCmd.getMetaDataForMember(fieldName);
                if (paramSM != null) {
                    paramSM.isLoaded((PersistenceCapable)obj, paramFieldMmd.getAbsoluteFieldNumber());
                    paramFieldValue = paramSM.provideField(paramFieldMmd.getAbsoluteFieldNumber());
                } else {
                    paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
                }
            } else {
                paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
            }
            return paramFieldValue;
        }
        return null;
    }

    protected SQLTableMapping getSQLTableMappingForAlias(String alias) {
        if (this.caseInsensitive) {
            return this.sqlTableByPrimary.get(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.get(alias);
    }

    protected void setSQLTableMappingForAlias(String alias, SQLTableMapping mapping) {
        if (alias == null) {
            return;
        }
        if (this.caseInsensitive) {
            this.sqlTableByPrimary.put(alias.toUpperCase(), mapping);
        } else {
            this.sqlTableByPrimary.put(alias, mapping);
        }
    }

    protected boolean hasSQLTableMappingForAlias(String alias) {
        if (this.caseInsensitive) {
            return this.sqlTableByPrimary.containsKey(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.containsKey(alias);
    }

    class SQLTableMapping {
        SQLTable table;
        AbstractClassMetaData cmd;
        JavaTypeMapping mapping;

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mapping = m;
        }

        public String toString() {
            return "SQLTableMapping: tbl=" + this.table + " class=" + this.cmd.getFullClassName() + " mapping=" + this.mapping;
        }
    }
}

