/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class BooleanLiteral
extends BooleanExpression
implements SQLLiteral {
    private final Boolean value;

    public BooleanLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Boolean) {
            this.value = (Boolean)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (this.isParameter) {
            this.st.appendParameter(mapping, value);
        } else {
            this.setStatement();
        }
    }

    public Object getValue() {
        return new Boolean(this.value);
    }

    public BooleanExpression and(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? (BooleanExpression)expr : this;
        }
        return super.and(expr);
    }

    public BooleanExpression eor(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? expr.not() : (BooleanExpression)expr;
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? this : (BooleanExpression)expr;
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanLiteral(this.stmt, this.mapping, this.value == false, false);
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? (BooleanExpression)expr : expr.not();
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? expr.not() : (BooleanExpression)expr;
        }
        return super.ne(expr);
    }

    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        DatastoreMapping datastoreMapping = this.mapping.getDataStoreMapping(0);
        if (datastoreMapping.isStringBased()) {
            this.st.append(this.value != false ? "'Y'" : "'N'");
        } else if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
            this.st.append(this.value != false ? "1" : "0");
        } else {
            this.st.append(this.value != false ? "TRUE" : "(1=0)");
        }
    }
}

