/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class CollectionSizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        String elementType = ownerMmd.getCollection().getElementType();
        SQLStatement stmt = expr.getSQLStatement();
        RDBMSManager storeMgr = stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject collectionTbl = null;
        if (ownerMmd.getMappedBy() != null) {
            AbstractMemberMetaData elementMmd = ownerMmd.getRelatedMemberMetaData(clr)[0];
            if (ownerMmd.getJoinMetaData() != null || elementMmd.getJoinMetaData() != null) {
                collectionTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
                ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
            } else {
                collectionTbl = storeMgr.getDatastoreClass(elementType, clr);
                ownerMapping = collectionTbl.getMemberMapping(elementMmd);
            }
        } else if (ownerMmd.getJoinMetaData() != null) {
            collectionTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
            ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
        } else {
            collectionTbl = storeMgr.getDatastoreClass(elementType, clr);
            ownerMapping = ((DatastoreClass)collectionTbl).getExternalMapping(ownerMmd, 5);
        }
        SQLStatement subStmt = new SQLStatement(stmt, storeMgr, collectionTbl, null, null);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = stmt.getSQLExpressionFactory().newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = stmt.getSQLExpressionFactory().newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = stmt.getSQLExpressionFactory().newExpression(stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIDMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        return new NumericSubqueryExpression(stmt, subStmt);
    }
}

