/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKArrayStoreSpecialization;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractArrayStoreSpecialization;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RDBMSFKArrayStoreSpecialization
extends RDBMSAbstractArrayStoreSpecialization
implements FKArrayStoreSpecialization {
    private String updateFkStmt;
    private String clearNullifyStmt;

    public RDBMSFKArrayStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUpdateElementFk(StateManager ownerSM, Object element, Object owner, int index, ElementContainerStore ecs) {
        boolean retval;
        String updateFkStmt = this.getUpdateFkStmt(ecs);
        ObjectManager om = ownerSM.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (ecs.getElementInfo().length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, table.toString());
                        } else {
                            NucleusLogger.PERSISTENCE.info((Object)(">> InverseArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                        }
                    }
                    if (owner == null) {
                        JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
                        ownerMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ownerMapping), null);
                        jdbcPosition += ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(om, ps, index, jdbcPosition, ecs.getOrderMapping());
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(om, ps, element, jdbcPosition, ecs.getElementMapping());
                    sqlControl.executeStatementUpdate(mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM, ElementContainerStore ecs) {
        String clearNullifyStmt = this.getClearNullifyStmt(ecs);
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = ecs.getStoreManager().getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearNullifyStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
        }
    }

    private String getUpdateFkStmt(ElementContainerStore ecs) {
        if (this.updateFkStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            JavaTypeMapping elementMapping = ecs.getElementMapping();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(elementInfo[0].getDatastoreClass().toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    protected String getClearNullifyStmt(ElementContainerStore ecs) {
        if (this.clearNullifyStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(elementInfo[0].getDatastoreClass().toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
            }
            for (i = 0; i < orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(", ");
                stmt.append(orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }
}

