/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.StatementMappingDefinition;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class UpdateRequest
extends Request {
    private final String updateStmt;
    private final String updateStmtOptimistic;
    private final MappingCallbacks[] callbacks;
    private StatementMappingDefinition stmtMappingDefinition;
    private final int[] updateFieldNumbers;
    private final int[] pkFieldNumbers;
    protected AbstractClassMetaData cmd = null;
    protected VersionMetaData versionMetaData = null;
    protected boolean versionChecks = false;

    public UpdateRequest(DatastoreClass table, AbstractMemberMetaData[] reqFieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractMemberMetaData[] updateFmds;
        this.cmd = table.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(cls, clr);
        this.versionMetaData = table.getVersionMetaData();
        if (this.versionMetaData != null && this.versionMetaData.getVersionStrategy() != VersionStrategy.NONE) {
            this.versionChecks = true;
        }
        this.stmtMappingDefinition = new StatementMappingDefinition();
        UpdateMappingConsumer consumer = new UpdateMappingConsumer(this.cmd);
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[reqFieldMetaData.length + 1];
                for (int i = 0; i < reqFieldMetaData.length; ++i) {
                    updateFmds[i] = reqFieldMetaData[i];
                }
                updateFmds[updateFmds.length - 1] = this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName());
                table.provideMappingsForMembers((MappingConsumer)consumer, updateFmds, false);
            } else {
                table.provideMappingsForMembers((MappingConsumer)consumer, reqFieldMetaData, false);
                table.provideVersionMappings((MappingConsumer)consumer);
            }
        } else {
            table.provideMappingsForMembers((MappingConsumer)consumer, reqFieldMetaData, false);
        }
        consumer.setWhereClauseConsumption(true);
        table.providePrimaryKeyMappings((MappingConsumer)consumer);
        table.provideDatastoreIdMappings((MappingConsumer)consumer);
        this.updateStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[]{this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName())};
                table.provideMappingsForMembers((MappingConsumer)consumer, updateFmds, false);
            } else {
                table.provideVersionMappings((MappingConsumer)consumer);
            }
        }
        this.updateStmtOptimistic = consumer.getStatement();
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        this.updateFieldNumbers = consumer.getUpdateFieldNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        String stmt = null;
        ObjectManager om = sm.getObjectManager();
        boolean optimisticChecks = this.versionMetaData != null && om.getTransaction().getOptimistic() && this.versionChecks;
        stmt = optimisticChecks ? this.updateStmtOptimistic : this.updateStmt;
        if (stmt != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < this.updateFieldNumbers.length; ++i) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.updateFieldNumbers[i]).getName());
                }
                if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append("[VERSION]");
                }
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052214", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)fieldStr.toString(), (Object)this.table));
            }
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            boolean batch = false;
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, batch);
                    try {
                        int[] rcs;
                        StatementMappingIndex mapIdx;
                        int i;
                        StatementMappingIndex[] idxs;
                        StatementMappingForClass mappingDefinition;
                        Object currentVersion = sm.getTransactionalVersion(sm.getObject());
                        Object nextVersion = null;
                        if (this.versionMetaData != null) {
                            if (this.versionMetaData.getFieldName() != null) {
                                AbstractMemberMetaData verfmd = this.cmd.getMetaDataForMember(this.table.getVersionMetaData().getFieldName());
                                if (currentVersion instanceof Integer) {
                                    currentVersion = new Long(((Integer)currentVersion).longValue());
                                }
                                nextVersion = this.versionMetaData.getNextVersion(currentVersion);
                                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                                    nextVersion = new Integer(((Long)nextVersion).intValue());
                                }
                                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion, false);
                            } else {
                                nextVersion = this.versionMetaData.getNextVersion(currentVersion);
                            }
                            sm.setTransactionalVersion(nextVersion);
                        }
                        if (this.updateFieldNumbers != null) {
                            mappingDefinition = new StatementMappingForClass(null);
                            idxs = this.stmtMappingDefinition.getFields();
                            for (i = 0; i < idxs.length; ++i) {
                                if (idxs[i] == null) continue;
                                mappingDefinition.addMappingForMember(i, idxs[i]);
                            }
                            sm.provideFields(this.updateFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, true));
                        }
                        if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                            mapIdx = this.stmtMappingDefinition.getVersion();
                            for (int i2 = 0; i2 < mapIdx.getNumberOfParameterOccurrences(); ++i2) {
                                this.table.getVersionMapping(false).setObject(om, (Object)ps, mapIdx.getParameterPositionsForOccurrence(i2), nextVersion);
                            }
                        }
                        if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                            mapIdx = this.stmtMappingDefinition.getDatastoreId();
                            for (int i3 = 0; i3 < mapIdx.getNumberOfParameterOccurrences(); ++i3) {
                                this.table.getDataStoreObjectIdMapping().setObject(om, (Object)ps, mapIdx.getParameterPositionsForOccurrence(i3), sm.getInternalObjectId());
                            }
                        } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                            mappingDefinition = new StatementMappingForClass(null);
                            idxs = this.stmtMappingDefinition.getPrimaryKeys();
                            for (i = 0; i < idxs.length; ++i) {
                                if (idxs[i] == null) continue;
                                mappingDefinition.addMappingForMember(i, idxs[i]);
                            }
                            sm.provideFields(this.pkFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, true));
                        }
                        if (optimisticChecks) {
                            if (currentVersion == null) {
                                String msg = LOCALISER.msg("052201", sm.getInternalObjectId(), (Object)this.table);
                                NucleusLogger.PERSISTENCE.error((Object)msg);
                                throw new NucleusException(msg);
                            }
                            mapIdx = this.stmtMappingDefinition.getVersion2();
                            for (int i4 = 0; i4 < mapIdx.getNumberOfParameterOccurrences(); ++i4) {
                                mapIdx.getMapping().setObject(om, (Object)ps, mapIdx.getParameterPositionsForOccurrence(i4), currentVersion);
                            }
                        }
                        if ((rcs = sqlControl.executeStatementUpdate(mconn, stmt, ps, !batch))[0] == 0 && optimisticChecks) {
                            String msg = LOCALISER.msg("052203", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)("" + sm.getTransactionalVersion(sm.getObject())));
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusOptimisticException(msg, sm.getObject());
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("052215", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)stmt, (Object)StringUtils.getStringFromStackTrace((Throwable)e));
                NucleusLogger.DATASTORE_PERSIST.error((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(e);
                while ((e = e.getNextException()) != null) {
                    exceptions.add(e);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052216", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)((JavaTypeMapping)this.callbacks[i]).getMemberMetaData().getFullFieldName()));
                }
                this.callbacks[i].postUpdate(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)this.callbacks[i]).getMemberMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    private class UpdateMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        int paramIndex = 1;
        int highestFieldNumber = 0;
        List updateFields = new ArrayList();
        List pkFields = new ArrayList();
        List mc = new ArrayList();
        StringBuffer columnAssignments = new StringBuffer();
        Map assignedColumns = new HashMap();
        StringBuffer where = new StringBuffer();
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public UpdateMappingConsumer(AbstractClassMetaData cmd) {
            this.cmd = cmd;
        }

        public void setWhereClauseConsumption(boolean whereClause) {
            this.whereClauseConsumption = whereClause;
        }

        public int getHighestFieldNumber() {
            return this.highestFieldNumber;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                this.highestFieldNumber = highest;
                UpdateRequest.this.stmtMappingDefinition.setPrimaryKeys(new StatementMappingIndex[highest]);
                UpdateRequest.this.stmtMappingDefinition.setFields(new StatementMappingIndex[highest]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (fmd.hasExtension("updateable") && fmd.getValueForExtension("updateable").equalsIgnoreCase("false")) {
                    return;
                }
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds != null && colmds.length > 0) {
                    for (int i = 0; i < colmds.length; ++i) {
                        if (colmds[i].getUpdateable()) continue;
                        return;
                    }
                }
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                StatementMappingIndex sei = new StatementMappingIndex(m);
                sei.addParameterOccurrence(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    ((UpdateRequest)UpdateRequest.this).stmtMappingDefinition.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.where.append(condition);
                        if (!this.pkFields.contains(abs_field_num)) {
                            this.pkFields.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                } else if (this.whereClauseConsumption) {
                    UpdateRequest.this.stmtMappingDefinition.setVersion2(sei);
                    ++this.paramIndex;
                    String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                } else {
                    ((UpdateRequest)UpdateRequest.this).stmtMappingDefinition.getFields()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (!this.assignedColumns.containsKey(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString())) {
                            if (this.columnAssignments.length() > 0) {
                                this.columnAssignments.append(", ");
                            }
                            String param = ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                            this.columnAssignments.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).append("=").append(param);
                            if (param.indexOf("?") > -1) {
                                if (!this.updateFields.contains(abs_field_num)) {
                                    this.updateFields.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                            continue;
                        }
                        parametersIndex[j] = (Integer)this.assignedColumns.get(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                if (this.whereClauseConsumption) {
                    this.where.append(" AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam);
                    StatementMappingIndex versStmtIdx = new StatementMappingIndex(m);
                    versStmtIdx.addParameterOccurrence(new int[]{this.paramIndex++});
                    UpdateRequest.this.stmtMappingDefinition.setVersion2(versStmtIdx);
                } else {
                    String condition = m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    if (this.columnAssignments.length() > 0) {
                        this.columnAssignments.append(", ");
                    }
                    this.columnAssignments.append(condition);
                    StatementMappingIndex versStmtIdx = new StatementMappingIndex(m);
                    versStmtIdx.addParameterOccurrence(new int[]{this.paramIndex++});
                    UpdateRequest.this.stmtMappingDefinition.setVersion(versStmtIdx);
                }
            } else if (mappingType == 2) {
                this.where.append(((DatastoreField)UpdateRequest.this.key.getColumns().get(0)).getIdentifier() + "=?");
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(m);
                datastoreIdIdx.addParameterOccurrence(new int[]{this.paramIndex++});
                UpdateRequest.this.stmtMappingDefinition.setDatastoreId(datastoreIdIdx);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getUpdateFieldNumbers() {
            int[] fieldNumbers = new int[this.updateFields.size()];
            for (int i = 0; i < this.updateFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.updateFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public String getStatement() {
            if (this.columnAssignments.length() < 1) {
                return null;
            }
            return "UPDATE " + UpdateRequest.this.table.toString() + " SET " + this.columnAssignments + " WHERE " + this.where;
        }
    }
}

