/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.CastExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class QueryToSQLMapper
extends AbstractExpressionEvaluator {
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final QueryCompilation compilation;
    Map parameters;
    final SQLStatement stmt;
    final StatementMappingForClass resultDefinitionForClass;
    final StatementResultMapping resultDefinition;
    StatementParameterMapping parameterDefinition;
    final RDBMSManager storeMgr;
    final FetchPlan fetchPlan;
    final SQLExpressionFactory exprFactory;
    ClassLoaderResolver clr;
    int paramNumber = 1;
    Stack stack = new Stack();
    Map<String, SQLTableMapping> sqlTableByPrimary = new HashMap<String, SQLTableMapping>();

    public QueryToSQLMapper(SQLStatement stmt, QueryCompilation compilation, Map parameters, StatementMappingForClass resultDefForClass, StatementResultMapping resultDef, AbstractClassMetaData cmd, FetchPlan fetchPlan, StatementParameterMapping paramInfo) {
        this.parameters = parameters;
        this.compilation = compilation;
        this.stmt = stmt;
        this.resultDefinitionForClass = resultDefForClass;
        this.resultDefinition = resultDef;
        this.candidateAlias = compilation.getCandidateAlias();
        this.fetchPlan = fetchPlan;
        this.storeMgr = stmt.getRDBMSManager();
        this.exprFactory = stmt.getRDBMSManager().getSQLExpressionFactory();
        this.candidateCmd = cmd;
        this.clr = stmt.getRDBMSManager().getOMFContext().getClassLoaderResolver(null);
        this.parameterDefinition = paramInfo;
        this.sqlTableByPrimary.put(this.candidateAlias, new SQLTableMapping(stmt.getPrimaryTable(), this.candidateCmd, stmt.getPrimaryTable().getTable().getIDMapping()));
    }

    public void compile() {
        if (this.compilation.getExprResult() != null) {
            Expression[] resultExprs = this.compilation.getExprResult();
            for (int i = 0; i < resultExprs.length; ++i) {
                StatementMappingIndex idx;
                int col;
                SQLExpression sqlExpr;
                if (resultExprs[i] instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)resultExprs[i]);
                    sqlExpr = (SQLExpression)this.stack.pop();
                    col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)resultExprs[i]);
                    sqlExpr = (SQLExpression)this.stack.pop();
                    int[] cols = this.stmt.select(sqlExpr.getSQLTable(), sqlExpr.getJavaTypeMapping(), null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols);
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)resultExprs[i]);
                    sqlExpr = (SQLExpression)this.stack.pop();
                    col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof Literal) {
                    this.processLiteral((Literal)resultExprs[i]);
                    sqlExpr = (SQLExpression)this.stack.pop();
                    col = this.stmt.select(sqlExpr, null);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                throw new NucleusException("Dont currently support result clause containing expression of type " + resultExprs[i]);
            }
        } else {
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.fetchPlan, this.candidateCmd, 1);
        }
        if (this.compilation.getExprFilter() != null) {
            BooleanExpression filterExpr = (BooleanExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
            this.stmt.whereAnd(filterExpr, true);
        }
        if (this.compilation.getExprGrouping() != null) {
            // empty if block
        }
        if (this.compilation.getExprOrdering() != null) {
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            SQLExpression[] orderSqlExprs = new SQLExpression[orderingExpr.length];
            boolean[] directions = new boolean[orderingExpr.length];
            for (int i = 0; i < orderingExpr.length; ++i) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                orderSqlExprs[i] = this.getSQLExpressionForPrimaryExpressionOrdering((PrimaryExpression)orderExpr.getLeft());
                String orderDir = orderExpr.getSortOrder();
                directions[i] = orderDir != null && !orderDir.equals("ascending");
            }
            this.stmt.setOrdering(orderSqlExprs, directions);
        }
    }

    protected Object processAndExpression(Expression expr) {
        BooleanExpression rightExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression leftExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression opExpr = leftExpr.and(rightExpr);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processOrExpression(Expression expr) {
        BooleanExpression rightExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression leftExpr = (BooleanExpression)this.stack.pop();
        BooleanExpression opExpr = leftExpr.ior(rightExpr);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processEqExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.eq(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.ge(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGtExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.gt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.le(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLtExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.lt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        BooleanExpression opExpr = left.ne(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Class) {
            litValue = ((Class)litValue).getName();
        }
        JavaTypeMapping m = null;
        if (litValue != null) {
            m = this.stmt.getRDBMSManager().getMappingManager().getMapping(litValue.getClass());
        }
        SQLExpression sqlExpr = this.exprFactory.newLiteral(this.stmt, m, litValue);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        SQLExpression sqlExpr = null;
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(expr);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
        }
        sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    private SQLTableMapping getSQLTableMappingForPrimaryExpression(PrimaryExpression primExpr) {
        SQLTableMapping sqlMapping = null;
        List exprComponents = primExpr.getTuples();
        Iterator iter = exprComponents.iterator();
        String componentName = null;
        while (iter.hasNext()) {
            String component = (String)iter.next();
            if (component.equals(this.candidateAlias)) {
                componentName = component;
            } else {
                if (componentName == null) {
                    componentName = this.candidateAlias;
                    sqlMapping = this.sqlTableByPrimary.get(componentName);
                }
                componentName = componentName + "." + component;
            }
            SQLTableMapping sqlMappingNew = this.sqlTableByPrimary.get(componentName);
            if (sqlMappingNew == null) {
                AbstractMemberMetaData mmd = sqlMapping.cmd.getMetaDataForMember(component);
                int relationType = mmd.getRelationType(this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(sqlMapping.cmd.getFullClassName(), this.clr);
                JavaTypeMapping mapping = table.getMemberMapping(mmd);
                SQLTable sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(this.stmt, sqlMapping.table, mapping);
                switch (relationType) {
                    case 0: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.sqlTableByPrimary.put(componentName, sqlMappingNew);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        if (mmd.getMappedBy() != null) {
                            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            DatastoreClass relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                            JavaTypeMapping relMapping = relTable.getMemberMapping(relMmd);
                            sqlTbl = this.stmt.getTable((DatastoreContainerObject)relTable, componentName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(this.stmt, sqlMapping.table.getTable().getIDMapping(), sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, componentName);
                            }
                            if (iter.hasNext()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIDMapping());
                                break;
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, relTable.getIDMapping());
                            break;
                        }
                        if (iter.hasNext()) {
                            AbstractClassMetaData relCmd = null;
                            JavaTypeMapping relMapping = null;
                            DatastoreClass relTable = null;
                            if (relationType == 2) {
                                AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                relCmd = relMmd.getAbstractClassMetaData();
                                relTable = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                                relMapping = relTable.getMemberMapping(relMmd);
                            } else {
                                relCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getTypeName(), this.clr);
                                relTable = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                                relMapping = relTable.getExternalMapping(mmd, 5);
                            }
                            sqlTbl = this.stmt.getTable((DatastoreContainerObject)relTable, componentName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(this.stmt, mapping, sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, componentName);
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, relMapping);
                            this.sqlTableByPrimary.put(componentName, sqlMappingNew);
                            break;
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.sqlTableByPrimary.put(componentName, sqlMappingNew);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, sqlMapping.cmd, mapping);
                        this.sqlTableByPrimary.put(componentName, sqlMappingNew);
                        break;
                    }
                }
            }
            sqlMapping = sqlMappingNew;
        }
        return sqlMapping;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        JavaTypeMapping m = null;
        StatementMappingIndex paramIdx = this.parameterDefinition.getMappingForParameter(expr.getId());
        if (this.parameters != null && this.parameters.containsKey(expr.getId())) {
            m = this.storeMgr.getSQLExpressionFactory().getMappingForType(this.parameters.get(expr.getId()).getClass(), false);
        } else if (paramIdx != null) {
            m = paramIdx.getMapping();
        }
        SQLExpression sqlExpr = this.exprFactory.newLiteralParameter(this.stmt, m);
        if (sqlExpr instanceof ParameterLiteral) {
            ((ParameterLiteral)sqlExpr).setName(expr.getId());
        }
        if (paramIdx == null) {
            paramIdx = new StatementMappingIndex(m);
        }
        int[] paramPositions = new int[]{this.paramNumber++};
        paramIdx.addParameterOccurrence(paramPositions);
        this.parameterDefinition.addMappingForParameter(expr.getId(), paramIdx);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        SQLExpression invokedSqlExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedSqlExpr = (SQLExpression)this.stack.pop();
            } else if (invokedExpr instanceof Literal) {
                this.processLiteral((Literal)invokedExpr);
                invokedSqlExpr = (SQLExpression)this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.processParameterExpression((ParameterExpression)invokedExpr);
                invokedSqlExpr = (SQLExpression)this.stack.pop();
            } else {
                throw new NucleusException("Dont currently support invoke expression " + invokedExpr);
            }
        }
        String operation = expr.getOperation();
        List args = expr.getParameters();
        ArrayList sqlExprArgs = null;
        if (args != null) {
            sqlExprArgs = new ArrayList();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                throw new NucleusException("Dont currently support invoke expression argument " + argExpr);
            }
        }
        SQLExpression sqlExpr = null;
        sqlExpr = invokedSqlExpr != null ? invokedSqlExpr.invoke(operation, sqlExprArgs) : this.exprFactory.invokeMethod(null, operation, null, sqlExprArgs);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processAddExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = left.add(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDivExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = left.div(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processMulExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = left.mul(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processSubExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = left.sub(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processComExpression(Expression expr) {
        SQLExpression sqlExpr = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = sqlExpr.com();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processModExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = left.mod(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNegExpression(Expression expr) {
        SQLExpression sqlExpr = (SQLExpression)this.stack.pop();
        SQLExpression resultExpr = sqlExpr.neg();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNotExpression(Expression expr) {
        SQLExpression sqlExpr = (SQLExpression)this.stack.pop();
        BooleanExpression resultExpr = sqlExpr.not();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processCastExpression(CastExpression expr) {
        return super.processCastExpression(expr);
    }

    protected Object processIsExpression(Expression expr) {
        SQLExpression right = (SQLExpression)this.stack.pop();
        SQLExpression left = (SQLExpression)this.stack.pop();
        Class instanceofType = null;
        try {
            instanceofType = this.clr.classForName((String)((StringLiteral)right).getValue());
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException("Query has been specified with instanceof for " + right + " which is not a known class name");
        }
        JavaTypeMapping mapping = left.getJavaTypeMapping();
        Class memberType = this.clr.classForName(mapping.getType());
        if (!memberType.isAssignableFrom(instanceofType) && !instanceofType.isAssignableFrom(memberType)) {
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            return this.exprFactory.newLiteral(this.stmt, m, false).eq(this.exprFactory.newLiteral(this.stmt, m, true));
        }
        if (memberType == instanceofType) {
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
        }
        return left.is(instanceofType);
    }

    protected SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, JavaTypeMapping mapping) {
        String paramName = paramLit.getName();
        StatementMappingIndex paramIdxOld = this.parameterDefinition.getMappingForParameter(paramName);
        if (paramIdxOld.getMapping() == null) {
            StatementMappingIndex paramIdxNew = new StatementMappingIndex(mapping);
            for (int i = 0; i < paramIdxOld.getNumberOfParameterOccurrences(); ++i) {
                paramIdxNew.addParameterOccurrence(paramIdxOld.getParameterPositionsForOccurrence(i));
            }
            this.parameterDefinition.addMappingForParameter(paramName, paramIdxNew);
        }
        return this.exprFactory.newLiteralParameter(this.stmt, mapping);
    }

    protected SQLExpression getSQLExpressionForPrimaryExpressionOrdering(PrimaryExpression primExpr) {
        SQLExpression sqlExpr = null;
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(primExpr);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + primExpr.getId() + " is not yet supported");
        }
        sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        return sqlExpr;
    }

    protected boolean operationIsAggregate(String operation) {
        return operation.equals("count") || operation.equals("min") || operation.equals("max") || operation.equals("sum") || operation.equals("avg");
    }

    class SQLTableMapping {
        SQLTable table;
        AbstractClassMetaData cmd;
        JavaTypeMapping mapping;

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mapping = m;
        }
    }
}

