/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class MapSizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        boolean keyStoredInValue = false;
        if (ownerMmd.getKeyMetaData() != null && ownerMmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        }
        SQLStatement stmt = expr.getSQLStatement();
        RDBMSManager storeMgr = stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject mapTbl = null;
        if (ownerMmd.getJoinMetaData() != null) {
            mapTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
            ownerMapping = ((JoinTable)mapTbl).getOwnerMapping();
        } else if (keyStoredInValue) {
            AbstractClassMetaData valueCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getValueType(), clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getValueType(), clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(valueCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        } else {
            AbstractClassMetaData keyCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getKeyType(), clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getKeyType(), clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        }
        SQLStatement subStmt = new SQLStatement(stmt, storeMgr, mapTbl, null, null);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = stmt.getSQLExpressionFactory().newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = stmt.getSQLExpressionFactory().newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = stmt.getSQLExpressionFactory().newExpression(stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIDMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        return new NumericSubqueryExpression(stmt, subStmt);
    }
}

